/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.location.ActivityIdentificationData;

public class ActivityConversionData
implements Parcelable {
    public static final Parcelable.Creator<ActivityConversionData> CREATOR = new Parcelable.Creator<ActivityConversionData>(){

        public Object[] newArray(int n) {
            return new ActivityConversionData[0];
        }

        public Object createFromParcel(Parcel parcel) {
            return new ActivityConversionData(parcel);
        }
    };
    private int activityType;
    private int conversionType;
    private long elapsedTimeFromReboot;

    public ActivityConversionData() {
    }

    public ActivityConversionData(int n, int n2, long l) {
        if (ActivityIdentificationData.isValidType(n) && (n2 == 0 || n2 == 1)) {
            ActivityConversionData activityConversionData = this;
            activityConversionData.activityType = n;
            activityConversionData.conversionType = n2;
            activityConversionData.elapsedTimeFromReboot = l;
            return;
        }
        throw new IllegalArgumentException("ActivityConversionData:The parameter is out of range");
    }

    private ActivityConversionData(Parcel parcel) {
        this.activityType = parcel.readInt();
        this.conversionType = parcel.readInt();
        this.elapsedTimeFromReboot = parcel.readLong();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.activityType);
        parcel.writeInt(this.conversionType);
        parcel.writeLong(this.elapsedTimeFromReboot);
    }

    public int getActivityType() {
        return this.activityType;
    }

    public int getConversionType() {
        return this.conversionType;
    }

    public long getElapsedTimeFromReboot() {
        return this.elapsedTimeFromReboot;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivityConversionData)) {
            return false;
        }
        return this.activityType == ((ActivityConversionData)(object = (ActivityConversionData)object)).getActivityType() && this.conversionType == ((ActivityConversionData)object).getConversionType() && this.elapsedTimeFromReboot == ((ActivityConversionData)object).getElapsedTimeFromReboot();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "ActivityConversionData{activityType=" + this.activityType + ", conversionType=" + this.conversionType + ", elapsedTimeFromReboot=" + this.elapsedTimeFromReboot + '}';
    }
}

