/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.common.internal.Objects;
import com.huawei.hms.common.internal.Preconditions;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.core.aidl.annotation.Packed;
import com.huawei.hms.location.ActivityIdentificationData;

public class ActivityConversionInfo
implements Parcelable,
IMessageEntity {
    public static final int ENTER_ACTIVITY_CONVERSION = 0;
    public static final int EXIT_ACTIVITY_CONVERSION = 1;
    public static final Parcelable.Creator<ActivityConversionInfo> CREATOR = new Parcelable.Creator<ActivityConversionInfo>(){

        public Object[] newArray(int n) {
            return new ActivityConversionInfo[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new ActivityConversionInfo(parcel);
        }
    };
    @Packed
    private int activityType;
    @Packed
    private int conversionType;

    public ActivityConversionInfo() {
    }

    public ActivityConversionInfo(int n, int n2) {
        if (ActivityIdentificationData.isValidType(n) && (n2 == 0 || n2 == 1)) {
            ActivityConversionInfo activityConversionInfo = this;
            activityConversionInfo.activityType = n;
            activityConversionInfo.conversionType = n2;
            return;
        }
        throw new IllegalArgumentException("ActivityConversionInfo:The parameter is out of range");
    }

    protected ActivityConversionInfo(Parcel parcel) {
        this.activityType = parcel.readInt();
        this.conversionType = parcel.readInt();
    }

    public int getActivityType() {
        return this.activityType;
    }

    public void setActivityType(int n) {
        if (ActivityIdentificationData.isValidType(n)) {
            this.activityType = n;
            return;
        }
        throw new IllegalArgumentException("ActivityConversionInfo:The parameter is out of range");
    }

    public int getConversionType() {
        return this.conversionType;
    }

    public void setConversionType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("ActivityConversionInfo:The parameter is out of range");
        }
        this.conversionType = n;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.activityType, this.conversionType});
    }

    public String toString() {
        return "ActivityConversionInfo{activityType=" + this.activityType + ", conversionType=" + this.conversionType + '}';
    }

    public boolean equals(Object object) {
        if (object == null) {
            return true;
        }
        if (!(object instanceof ActivityConversionInfo)) {
            return false;
        }
        return this.activityType == ((ActivityConversionInfo)(object = (ActivityConversionInfo)object)).getActivityType() && this.conversionType == ((ActivityConversionInfo)object).getConversionType();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.activityType);
        parcel.writeInt(this.conversionType);
    }

    public static class Builder {
        private int mActivityType = -1;
        private int mConversionType = -1;

        public ActivityConversionInfo build() {
            Preconditions.checkState((this.mActivityType != -1 ? 1 : 0) != 0, (Object)"ActivityType not set.");
            Preconditions.checkState((this.mConversionType != -1 ? 1 : 0) != 0, (Object)"ConversionType not set.");
            Builder builder = this;
            int n = builder.mActivityType;
            return new ActivityConversionInfo(n, builder.mConversionType);
        }

        public Builder setActivityType(int n) {
            if (ActivityIdentificationData.isValidType(n)) {
                this.mActivityType = n;
                return this;
            }
            throw new IllegalArgumentException("ActivityConversionInfo:The parameter is out of range");
        }

        public Builder setConversionType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException("ActivityConversionInfo:The parameter is out of range");
            }
            this.mConversionType = n;
            return this;
        }
    }
}

