/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.common.ApiException;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.location.common.exception.LocationStatusCode;
import java.util.Arrays;
import java.util.Objects;

public class ActivityIdentificationData
implements Parcelable {
    public static final Parcelable.Creator<ActivityIdentificationData> CREATOR = new Parcelable.Creator<ActivityIdentificationData>(){

        public Object[] newArray(int n) {
            return new ActivityIdentificationData[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new ActivityIdentificationData(parcel);
        }
    };
    public static final int VEHICLE = 100;
    public static final int BIKE = 101;
    public static final int FOOT = 102;
    public static final int STILL = 103;
    public static final int OTHERS = 104;
    public static final int WALKING = 107;
    public static final int RUNNING = 108;
    private static final int[] VALID_TYPE_ARRAY = new int[]{100, 101, 102, 103, 107, 108};
    private static final int POSSIBILITY_MAX = 100;
    private static final int POSSIBILITY_MIN = 0;
    private int identificationActivity;
    private int possibility;

    public ActivityIdentificationData(int n, int n2) throws ApiException {
        Status status;
        if (n2 <= 100 && n2 >= 0) {
            ActivityIdentificationData activityIdentificationData = activityIdentificationData;
            activityIdentificationData.identificationActivity = n;
            activityIdentificationData.possibility = n2;
            return;
        }
        ActivityIdentificationData activityIdentificationData = status;
        status = new Status(10802, LocationStatusCode.getStatusCodeString(10802));
        throw new ApiException((Status)activityIdentificationData);
    }

    private ActivityIdentificationData(Parcel parcel) {
        this.identificationActivity = parcel.readInt();
        this.possibility = parcel.readInt();
    }

    public static boolean isValidType(int n) {
        return Arrays.binarySearch(VALID_TYPE_ARRAY, n) >= 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.identificationActivity);
        parcel.writeInt(this.possibility);
    }

    public int getPossibility() {
        return this.possibility;
    }

    public void setPossibility(int n) throws ApiException {
        Status status;
        if (n <= 100 && n >= 0) {
            activityIdentificationData.possibility = n;
            return;
        }
        ActivityIdentificationData activityIdentificationData = status;
        status = new Status(10802, LocationStatusCode.getStatusCodeString(10802));
        throw new ApiException((Status)activityIdentificationData);
    }

    public int getIdentificationActivity() {
        return this.identificationActivity;
    }

    public void setIdentificationActivity(int n) {
        this.identificationActivity = n;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.identificationActivity, this.possibility});
    }

    public boolean equals(Object object) {
        if (object == null) {
            return true;
        }
        if (this.getClass() == object.getClass() && object instanceof ActivityIdentificationData) {
            return this.identificationActivity == ((ActivityIdentificationData)(object = (ActivityIdentificationData)object)).getIdentificationActivity() && this.possibility == ((ActivityIdentificationData)object).getPossibility();
        }
        return false;
    }

    public String toString() {
        String string;
        int n = this.identificationActivity;
        switch (n) {
            default: {
                string = Integer.toString(n);
                break;
            }
            case 108: {
                string = "RUNNING";
                break;
            }
            case 107: {
                string = "WALKING";
                break;
            }
            case 104: {
                string = "OTHERS";
                break;
            }
            case 103: {
                string = "STILL";
                break;
            }
            case 102: {
                string = "FOOT";
                break;
            }
            case 101: {
                string = "BIKE";
                break;
            }
            case 100: {
                string = "VEHICLE";
            }
        }
        return "ActivityIdentificationData{identificationActivity=" + string + ", possibility=" + this.possibility + '}';
    }
}

