/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.core.aidl.annotation.Packed;
import com.huawei.hms.location.ActivityIdentificationData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ActivityIdentificationResponse
implements Parcelable,
IMessageEntity {
    private static final String TAG = "ActivityIdentificationResponse";
    public static final Parcelable.Creator<ActivityIdentificationResponse> CREATOR = new Parcelable.Creator<ActivityIdentificationResponse>(){

        public Object[] newArray(int n) {
            return new ActivityIdentificationResponse[0];
        }

        public Object createFromParcel(Parcel parcel) {
            return new ActivityIdentificationResponse(parcel);
        }
    };
    private static final String EXTRA_CONSTANT = "com.huawei.hms.location.internal.EXTRA_ACTIVITY_RESULT";
    @Packed
    private long time;
    @Packed
    private long elapsedTimeFromReboot;
    @Packed
    private List<ActivityIdentificationData> activityIdentificationDatas;

    public ActivityIdentificationResponse() {
    }

    public ActivityIdentificationResponse(List<ActivityIdentificationData> list, long l, long l2) {
        this.activityIdentificationDatas = list;
        this.time = l;
        this.elapsedTimeFromReboot = l2;
    }

    public ActivityIdentificationResponse(ActivityIdentificationData activityIdentificationData, long l, long l2) {
        this.activityIdentificationDatas = Collections.singletonList(activityIdentificationData);
        this.time = l;
        this.elapsedTimeFromReboot = l2;
    }

    private ActivityIdentificationResponse(Parcel parcel) {
        this.time = parcel.readLong();
        this.elapsedTimeFromReboot = parcel.readLong();
        this.activityIdentificationDatas = parcel.createTypedArrayList(ActivityIdentificationData.CREATOR);
    }

    public static ActivityIdentificationResponse getDataFromIntent(Intent intent) {
        ActivityIdentificationResponse activityIdentificationResponse;
        block7: {
            Intent intent2;
            block8: {
                block9: {
                    activityIdentificationResponse = null;
                    try {
                        if (!ActivityIdentificationResponse.containDataFromIntent(intent)) break block7;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    intent = intent.getParcelableExtra(EXTRA_CONSTANT);
                    intent2 = null;
                    if (intent == null) break block8;
                    if (!(intent instanceof Bundle)) break block9;
                    intent2 = ((Bundle)intent).getParcelable("KEY_RESPONSE");
                    break block8;
                }
                intent2 = intent;
            }
            if (!(intent2 instanceof ActivityIdentificationResponse)) break block7;
            activityIdentificationResponse = (ActivityIdentificationResponse)intent2;
        }
        return activityIdentificationResponse;
    }

    public static boolean containDataFromIntent(Intent intent) {
        if (intent != null) {
            try {
                if (intent.hasExtra(EXTRA_CONSTANT)) {
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public ActivityIdentificationData getMostActivityIdentification() {
        List<ActivityIdentificationData> list = this.activityIdentificationDatas;
        if (list != null && list.size() > 0) {
            return this.activityIdentificationDatas.get(0);
        }
        return null;
    }

    public int getActivityPossibility(int n) {
        List<ActivityIdentificationData> object2 = ((ActivityIdentificationResponse)this).activityIdentificationDatas;
        if (object2 != null && object2.size() > 0) {
            for (ActivityIdentificationData activityIdentificationData : ((ActivityIdentificationResponse)this).activityIdentificationDatas) {
                if (activityIdentificationData.getIdentificationActivity() != n) continue;
                return activityIdentificationData.getPossibility();
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass() && object instanceof ActivityIdentificationResponse) {
            return this.time == ((ActivityIdentificationResponse)(object = (ActivityIdentificationResponse)object)).getTime() && this.elapsedTimeFromReboot == ((ActivityIdentificationResponse)object).getElapsedTimeFromReboot() && Objects.equals(this.activityIdentificationDatas, ((ActivityIdentificationResponse)object).getActivityIdentificationDatas());
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.time;
        objectArray2[1] = this.elapsedTimeFromReboot;
        objectArray[2] = this.activityIdentificationDatas;
        return Objects.hashCode(objectArray);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.time);
        parcel.writeLong(this.elapsedTimeFromReboot);
        parcel.writeTypedList(this.activityIdentificationDatas);
    }

    public List<ActivityIdentificationData> getActivityIdentificationDatas() {
        return this.activityIdentificationDatas;
    }

    public void setActivityIdentificationDatas(List<ActivityIdentificationData> list) {
        this.activityIdentificationDatas = list;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l) {
        this.time = l;
    }

    public long getElapsedTimeFromReboot() {
        return this.elapsedTimeFromReboot;
    }

    public void setElapsedTimeFromReboot(long l) {
        this.elapsedTimeFromReboot = l;
    }

    public String toString() {
        return "ActivityIdentificationResponse{time=" + this.time + ", elapsedTimeFromReboot=" + this.elapsedTimeFromReboot + ", activityIdentificationDatas=" + this.activityIdentificationDatas + '}';
    }
}

