/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location;

import android.text.TextUtils;
import com.huawei.hms.support.api.entity.location.fence.GeofenceEntity;

public interface Geofence {
    public static final int ENTER_GEOFENCE_CONVERSION = 1;
    public static final int EXIT_GEOFENCE_CONVERSION = 2;
    public static final int DWELL_GEOFENCE_CONVERSION = 4;
    public static final long GEOFENCE_NEVER_EXPIRE = -1L;
    public static final int CONVERSIONS_MIN = 0;
    public static final int CONVERSIONS_MAX = 7;
    public static final long DEFAULT_DURATION = -2L;
    public static final int DEFAULT_INTERVAL = 0;

    public String getUniqueId();

    public static final class Builder {
        private String uniqueId = null;
        private int conversions = 0;
        private long validDuration = -2L;
        private double latitude;
        private double longitude;
        private float radius;
        private int notificationInterval = 0;
        private int dwellDelayTime = -1;

        public Builder setUniqueId(String string) {
            this.uniqueId = string;
            return this;
        }

        public Builder setConversions(int n) {
            this.conversions = n;
            return this;
        }

        public Builder setValidContinueTime(long l) {
            if (l < 0L) {
                l = -1L;
            }
            this.validDuration = l;
            return this;
        }

        public Builder setRoundArea(double d, double d3, float f) {
            this.latitude = d;
            this.longitude = d3;
            this.radius = f;
            return this;
        }

        public Builder setNotificationInterval(int n) {
            this.notificationInterval = n;
            return this;
        }

        public Builder setDwellDelayTime(int n) {
            this.dwellDelayTime = n;
            return this;
        }

        public Geofence build() {
            if (!TextUtils.isEmpty((CharSequence)((Builder)((Object)string)).uniqueId)) {
                int n = ((Builder)((Object)string)).conversions;
                if (n > 0 && n <= 7) {
                    if ((n & 4) != 0 && ((Builder)((Object)string)).dwellDelayTime < 0) {
                        throw new IllegalArgumentException("Non-negative dwellDelayTime needs to be set when conversions include DWELL_GEOFENCE_CONVERSION.");
                    }
                    long l = ((Builder)((Object)string)).validDuration;
                    if (l != -2L) {
                        int n2 = ((Builder)((Object)string)).notificationInterval;
                        if (n2 >= 0) {
                            Builder builder = string;
                            String string = builder.uniqueId;
                            double d = builder.latitude;
                            double d3 = builder.longitude;
                            float f = builder.radius;
                            int n3 = builder.dwellDelayTime;
                            return new GeofenceEntity(string, n, d, d3, f, l, n2, n3);
                        }
                        throw new IllegalArgumentException("notificationInterval should be nonnegative.");
                    }
                    throw new IllegalArgumentException("validDuration not set.");
                }
                throw new IllegalArgumentException("invalid conversions.");
            }
            throw new IllegalArgumentException("uniqueId not set.");
        }
    }
}

