/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location;

import android.content.Intent;
import android.location.Location;
import com.huawei.hms.location.Geofence;
import com.huawei.secure.android.common.intent.SafeBundle;
import com.huawei.secure.android.common.intent.SafeIntent;
import java.util.ArrayList;
import java.util.List;

public class GeofenceData {
    public static final String KEY_ERROR_CODE = "hms_error_code";
    public static final String KEY_TRANSITION = "com.huawei.hms.location.geofence.conversion";
    public static final String KEY_GEOFENCE_LIST = "com.huawei.hms.location.geofence.geofence_list";
    public static final String KEY_LOCATION = "com.huawei.hms.location.geofence.location";
    private static final String KEY_GEOFENCE_BUNDLE = "com.huawei.hms.location.geofence.geofence_list_bundle";
    private final int errorCode;
    private final int conversion;
    private final List<Geofence> convertingGeofenceList;
    private final Location convertingLocation;

    private GeofenceData(int n, int n2, List<Geofence> list, Location location) {
        this.errorCode = n;
        this.conversion = n2;
        this.convertingGeofenceList = list;
        this.convertingLocation = location;
    }

    public static GeofenceData getDataFromIntent(Intent intent) {
        ArrayList<Geofence> arrayList;
        SafeIntent safeIntent;
        if (intent == null) {
            return null;
        }
        SafeIntent safeIntent2 = safeIntent;
        int n = new SafeIntent(intent).getIntExtra(KEY_ERROR_CODE, -1);
        int n2 = safeIntent2.getIntExtra(KEY_TRANSITION, -1);
        if (n2 != 1 && n2 != 2 && n2 != 4) {
            n2 = -1;
        }
        Location location = (Location)safeIntent2.getParcelableExtra(KEY_LOCATION);
        ArrayList<Geofence> arrayList2 = arrayList;
        arrayList = new ArrayList<Geofence>();
        ArrayList arrayList3 = new SafeBundle(safeIntent2.getBundleExtra(KEY_GEOFENCE_BUNDLE)).getParcelableArrayList(KEY_GEOFENCE_LIST);
        if (arrayList3 == null) {
            arrayList3 = safeIntent2.getParcelableArrayListExtra(KEY_GEOFENCE_LIST);
        }
        if (arrayList3 != null && arrayList3.size() > 0) {
            arrayList2.addAll(arrayList3);
        }
        return new GeofenceData(n, n2, arrayList2, location);
    }

    public boolean isSuccess() {
        return this.errorCode == -1;
    }

    public boolean isFailure() {
        return this.errorCode != -1;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getConversion() {
        return this.conversion;
    }

    public List<Geofence> getConvertingGeofenceList() {
        return this.convertingGeofenceList;
    }

    public Location getConvertingLocation() {
        return this.convertingLocation;
    }
}

