/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.common.internal.Preconditions;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.core.aidl.annotation.Packed;
import com.huawei.hms.location.Geofence;
import com.huawei.hms.support.api.entity.location.fence.GeofenceEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GeofenceRequest
implements Parcelable,
IMessageEntity {
    public static final int ENTER_INIT_CONVERSION = 1;
    public static final int EXIT_INIT_CONVERSION = 2;
    public static final int DWELL_INIT_CONVERSION = 4;
    public static final int COORDINATE_TYPE_WGS_84 = 1;
    public static final int COORDINATE_TYPE_GCJ_02 = 0;
    public static final Parcelable.Creator<GeofenceRequest> CREATOR = new Parcelable.Creator<GeofenceRequest>(){

        public Object[] newArray(int n) {
            return new GeofenceRequest[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new GeofenceRequest(parcel);
        }
    };
    private static final int CONVERSIONS_MAX = 7;
    private static final int CONVERSIONS_MIN = 0;
    @Packed
    private List<GeofenceEntity> geofenceList;
    @Packed
    private int initConversions;
    @Packed
    private int coordinateType;

    public GeofenceRequest() {
    }

    GeofenceRequest(List<GeofenceEntity> list, int n, int n2) {
        this.geofenceList = list;
        this.initConversions = n;
        this.coordinateType = n2;
    }

    private GeofenceRequest(Parcel parcel) {
        this.geofenceList = parcel.createTypedArrayList(GeofenceEntity.CREATOR);
        this.initConversions = parcel.readInt();
        this.coordinateType = parcel.readInt();
    }

    public List<Geofence> getGeofences() {
        if (this.geofenceList == null) {
            return new ArrayList<Geofence>();
        }
        return new ArrayList<Geofence>(this.geofenceList);
    }

    public int getInitConversions() {
        return this.initConversions;
    }

    public int getCoordinateType() {
        return this.coordinateType;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeTypedList(this.geofenceList);
        parcel.writeInt(this.initConversions);
        parcel.writeInt(this.coordinateType);
    }

    public String toString() {
        return "GeofenceRequest{geofenceList=" + this.geofenceList + ", initConversions=" + this.initConversions + ", coordinateType=" + this.coordinateType + '}';
    }

    public static final class Builder {
        private final List<GeofenceEntity> geofenceList;
        private int initConversions;
        private int coordinateType;

        public Builder() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.geofenceList = arrayList2;
            v1.initConversions = 5;
            v1.coordinateType = 1;
        }

        public Builder createGeofence(Geofence geofence) {
            Builder builder = this;
            Geofence geofence2 = geofence;
            Preconditions.checkNotNull((Object)geofence2, (Object)"geofence can't be null.");
            Preconditions.checkArgument((boolean)(geofence2 instanceof GeofenceEntity), (Object)"Geofence must be instanceof GeofenceEntity");
            builder.geofenceList.add((GeofenceEntity)geofence);
            return builder;
        }

        public Builder createGeofenceList(List<Geofence> object) {
            if (object != null && !object.isEmpty()) {
                object = object.iterator();
                while (object.hasNext()) {
                    Geofence geofence = (Geofence)object.next();
                    if (geofence == null) continue;
                    this.createGeofence(geofence);
                }
            }
            return this;
        }

        public Builder setInitConversions(int n) {
            this.initConversions = n;
            return this;
        }

        public Builder setCoordinateType(int n) {
            this.coordinateType = n;
            return this;
        }

        public GeofenceRequest build() {
            HashSet<String> hashSet;
            Builder builder = list;
            Preconditions.checkArgument((boolean)(builder.geofenceList.isEmpty() ^ true), (Object)"No geofence has been added.");
            int n = builder.coordinateType;
            if (n != 0 && n != 1) {
                ((Builder)((Object)list)).coordinateType = 1;
            }
            HashSet<String> hashSet2 = hashSet;
            hashSet = new HashSet<String>();
            Iterator<GeofenceEntity> iterator = ((Builder)((Object)list)).geofenceList.iterator();
            while (iterator.hasNext()) {
                hashSet2.add(iterator.next().getUniqueId());
            }
            if (hashSet2.size() == ((Builder)((Object)list)).geofenceList.size()) {
                int n2 = ((Builder)((Object)list)).initConversions;
                if (n2 <= 7 && n2 >= 0) {
                    Builder builder2 = list;
                    List<GeofenceEntity> list = builder2.geofenceList;
                    int n3 = builder2.coordinateType;
                    return new GeofenceRequest(list, n2, n3);
                }
                throw new IllegalArgumentException("invalid initConversions");
            }
            throw new IllegalArgumentException("more than one geofence has same requestId.");
        }
    }
}

