/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.core.aidl.annotation.Packed;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LocationRequest
implements IMessageEntity,
Parcelable {
    public static final Parcelable.Creator<LocationRequest> CREATOR = new Parcelable.Creator<LocationRequest>(){

        public Object[] newArray(int n) {
            return new LocationRequest[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new LocationRequest(parcel);
        }
    };
    public static final int COORDINATE_TYPE_WGS84 = 0;
    public static final int COORDINATE_TYPE_GCJ02 = 1;
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    public static final int PRIORITY_HD_ACCURACY = 200;
    public static final int PRIORITY_INDOOR = 300;
    public static final int PRIORITY_MAG_POSITION = 301;
    public static final int PRIORITY_HIGH_ACCURACY_AND_INDOOR = 400;
    private static final double FASTEST_INTERVAL_FACTOR = 6.0;
    @Packed
    private int priority;
    @Packed
    private long interval;
    @Packed
    private long fastestInterval;
    @Packed
    private boolean isFastestIntervalExplicitlySet;
    @Packed
    private long expirationTime;
    @Packed
    private int numUpdates;
    @Packed
    private float smallestDisplacement;
    @Packed
    private long maxWaitTime;
    @Packed
    private boolean needAddress;
    @Packed
    private String language;
    @Packed
    private String countryCode;
    @Packed
    private int coordinateType;
    @Packed
    private Map<String, String> extras;

    public LocationRequest() {
        this.priority = 102;
        long l = 3600000L;
        this.interval = 3600000L;
        this.fastestInterval = (long)((double)l / 6.0);
        this.isFastestIntervalExplicitlySet = false;
        this.expirationTime = Long.MAX_VALUE;
        this.numUpdates = Integer.MAX_VALUE;
        this.smallestDisplacement = 0.0f;
        this.maxWaitTime = 0L;
        this.needAddress = false;
        this.language = "";
        this.countryCode = "";
        this.coordinateType = 0;
    }

    protected LocationRequest(Parcel parcel) {
        HashMap<String, String> hashMap;
        ((LocationRequest)((Object)hashMap2)).priority = parcel.readInt();
        ((LocationRequest)((Object)hashMap2)).interval = parcel.readLong();
        ((LocationRequest)((Object)hashMap2)).fastestInterval = parcel.readLong();
        boolean bl = parcel.readByte() != 0;
        ((LocationRequest)((Object)hashMap2)).isFastestIntervalExplicitlySet = bl;
        ((LocationRequest)((Object)hashMap2)).expirationTime = parcel.readLong();
        ((LocationRequest)((Object)hashMap2)).numUpdates = parcel.readInt();
        ((LocationRequest)((Object)hashMap2)).smallestDisplacement = parcel.readFloat();
        ((LocationRequest)((Object)hashMap2)).maxWaitTime = parcel.readLong();
        bl = parcel.readByte() != 0;
        LocationRequest locationRequest = hashMap2;
        ((LocationRequest)((Object)hashMap2)).needAddress = bl;
        ((LocationRequest)((Object)hashMap2)).language = parcel.readString();
        ((LocationRequest)((Object)hashMap2)).countryCode = parcel.readString();
        locationRequest.coordinateType = parcel.readInt();
        HashMap<String, String> hashMap2 = hashMap;
        locationRequest.extras = new HashMap<String, String>();
        parcel.readMap((Map)hashMap2, LocationRequest.class.getClassLoader());
    }

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.priority);
        parcel.writeLong(this.interval);
        parcel.writeLong(this.fastestInterval);
        parcel.writeByte((byte)(this.isFastestIntervalExplicitlySet ? 1 : 0));
        parcel.writeLong(this.expirationTime);
        parcel.writeInt(this.numUpdates);
        parcel.writeFloat(this.smallestDisplacement);
        parcel.writeLong(this.maxWaitTime);
        parcel.writeByte((byte)(this.needAddress ? 1 : 0));
        parcel.writeString(this.language);
        parcel.writeString(this.countryCode);
        parcel.writeInt(this.coordinateType);
        parcel.writeMap(this.extras);
    }

    public int describeContents() {
        return 0;
    }

    public void putExtras(String string, String string2) {
        if (this.extras == null) {
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2 = hashMap;
            hashMap = new HashMap<String, String>();
            this.extras = hashMap2;
        }
        this.extras.put(string, string2);
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public LocationRequest setCoordinateType(int n) {
        this.coordinateType = n;
        return this;
    }

    public int getCoordinateType() {
        return this.coordinateType;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getFastestInterval() {
        return this.fastestInterval;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getMaxWaitTime() {
        long l = this.maxWaitTime;
        long l2 = this.interval;
        if (l >= l2) {
            l2 = l;
        }
        return l2;
    }

    public int getNumUpdates() {
        return this.numUpdates;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getSmallestDisplacement() {
        return this.smallestDisplacement;
    }

    public boolean isFastestIntervalExplicitlySet() {
        return this.isFastestIntervalExplicitlySet;
    }

    public LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        l = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : (l += l2);
        this.expirationTime = l;
        if (l < 0L) {
            l = 0L;
        }
        this.expirationTime = l;
        return this;
    }

    public LocationRequest setExpirationTime(long l) {
        if (l < 0L) {
            l = 0L;
        }
        this.expirationTime = l;
        return this;
    }

    public LocationRequest setFastestInterval(long l) throws IllegalArgumentException {
        if (l >= 0L) {
            this.isFastestIntervalExplicitlySet = true;
            this.fastestInterval = l;
            return this;
        }
        throw new IllegalArgumentException("FastestInterval is invalid");
    }

    public LocationRequest setInterval(long l) throws IllegalArgumentException {
        if (l >= 0L) {
            this.interval = l;
            l = this.isFastestIntervalExplicitlySet ? this.fastestInterval : (long)((double)l / 6.0);
            this.fastestInterval = l;
            return this;
        }
        throw new IllegalArgumentException("interval is invalid");
    }

    public LocationRequest setNumUpdates(int n) throws IllegalArgumentException {
        if (n > 0) {
            this.numUpdates = n;
            return this;
        }
        throw new IllegalArgumentException("numUpdates is invalid");
    }

    public LocationRequest setMaxWaitTime(long l) {
        if (l + SystemClock.uptimeMillis() >= 0L) {
            this.maxWaitTime = l;
            return this;
        }
        throw new IllegalArgumentException("maxWaitTime value is out of system time,is invalid");
    }

    public LocationRequest setPriority(int n) {
        if (n != 102 && n != 100 && n != 104 && n != 105 && n != 200 && n != 300 && n != 400 && n != 301) {
            throw new IllegalArgumentException("priority is not a known constant");
        }
        this.priority = n;
        return this;
    }

    public LocationRequest setSmallestDisplacement(float f) {
        if (!(f < 0.0f)) {
            this.smallestDisplacement = f;
            return this;
        }
        throw new IllegalArgumentException("smallestDisplacement param invalid");
    }

    public boolean getNeedAddress() {
        return this.needAddress;
    }

    public LocationRequest setNeedAddress(boolean bl) {
        this.needAddress = bl;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public LocationRequest setLanguage(String string) {
        this.language = string;
        return this;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public LocationRequest setCountryCode(String string) {
        this.countryCode = string;
        return this;
    }

    public boolean equals(Object object) {
        if (string3 == object) {
            return true;
        }
        if (object != null && string3.getClass() == object.getClass()) {
            String string;
            Object object2 = null;
            if (object instanceof LocationRequest) {
                object2 = (LocationRequest)object;
            }
            if (object2 == null) {
                return false;
            }
            boolean bl = ((LocationRequest)((Object)string3)).expirationTime == ((LocationRequest)object2).expirationTime && ((LocationRequest)((Object)string3)).isFastestIntervalExplicitlySet == ((LocationRequest)object2).isFastestIntervalExplicitlySet && ((LocationRequest)((Object)string3)).fastestInterval == ((LocationRequest)object2).fastestInterval && ((LocationRequest)((Object)string3)).interval == ((LocationRequest)object2).interval && ((LocationRequest)((Object)string3)).maxWaitTime == ((LocationRequest)object2).maxWaitTime && ((LocationRequest)((Object)string3)).numUpdates == ((LocationRequest)object2).numUpdates && ((LocationRequest)((Object)string3)).priority == ((LocationRequest)object2).priority && ((LocationRequest)((Object)string3)).needAddress == ((LocationRequest)object2).needAddress && Float.compare(((LocationRequest)((Object)string3)).smallestDisplacement, ((LocationRequest)object2).smallestDisplacement) == 0 && ((LocationRequest)((Object)string3)).coordinateType == ((LocationRequest)object2).coordinateType;
            String string2 = ((LocationRequest)((Object)string3)).language;
            bl = string2 != null && (string = ((LocationRequest)object2).language) != null && bl && string2.equals(string);
            String string3 = ((LocationRequest)((Object)string3)).countryCode;
            boolean bl2 = string3 != null && (object2 = ((LocationRequest)object2).countryCode) != null && bl && string3.equals(object2);
            return bl2;
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[12];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.priority;
        objectArray2[1] = this.interval;
        objectArray2[2] = this.fastestInterval;
        objectArray2[3] = this.isFastestIntervalExplicitlySet;
        objectArray2[4] = this.expirationTime;
        objectArray2[5] = this.numUpdates;
        objectArray2[6] = Float.valueOf(this.smallestDisplacement);
        objectArray2[7] = this.maxWaitTime;
        objectArray2[8] = this.needAddress;
        objectArray2[9] = this.language;
        objectArray2[10] = this.countryCode;
        objectArray[11] = this.coordinateType;
        return Objects.hash(objectArray);
    }

    public String toString() {
        return "LocationRequest{priority=" + this.priority + ", interval=" + this.interval + ", fastestInterval=" + this.fastestInterval + ", isFastestIntervalExplicitlySet=" + this.isFastestIntervalExplicitlySet + ", expirationTime=" + this.expirationTime + ", numUpdates=" + this.numUpdates + ", smallestDisplacement=" + this.smallestDisplacement + ", maxWaitTime=" + this.maxWaitTime + ", needAddress=" + this.needAddress + ", language=" + this.language + ", countryCode=" + this.countryCode + ", coordinateType=" + this.coordinateType + '}';
    }
}

