/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.location.entity.activity;

import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.location.entity.activity.DetectedActivity;
import java.util.List;

public class ActivityRecognitionResult
implements Parcelable {
    public static final Parcelable.Creator<ActivityRecognitionResult> CREATOR = new Parcelable.Creator<ActivityRecognitionResult>(){

        public Object[] newArray(int n) {
            return new ActivityRecognitionResult[0];
        }

        public Object createFromParcel(Parcel parcel) {
            return new ActivityRecognitionResult(parcel);
        }
    };
    private long time;
    private long elapsedRealtimeMillis;
    private List<DetectedActivity> probableActivities;

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2) {
        this.probableActivities = list;
        this.time = l;
        this.elapsedRealtimeMillis = l2;
    }

    private ActivityRecognitionResult(Parcel parcel) {
        this.time = parcel.readLong();
        this.elapsedRealtimeMillis = parcel.readLong();
        this.probableActivities = parcel.createTypedArrayList(DetectedActivity.CREATOR);
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.probableActivities;
    }

    public void setProbableActivities(List<DetectedActivity> list) {
        this.probableActivities = list;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l) {
        this.time = l;
    }

    public long getElapsedRealtimeMillis() {
        return this.elapsedRealtimeMillis;
    }

    public void setElapsedRealtimeMillis(long l) {
        this.elapsedRealtimeMillis = l;
    }

    public DetectedActivity getMostProbableActivity() {
        List<DetectedActivity> list = this.probableActivities;
        if (list != null && list.size() > 0) {
            return this.probableActivities.get(0);
        }
        return null;
    }

    public int getActivityConfidence(int n) {
        List<DetectedActivity> object2 = ((ActivityRecognitionResult)this).probableActivities;
        if (object2 != null && object2.size() > 0) {
            for (DetectedActivity detectedActivity : ((ActivityRecognitionResult)this).probableActivities) {
                if (detectedActivity.getType() != n) continue;
                return detectedActivity.getConfidence();
            }
        }
        return 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.time);
        parcel.writeLong(this.elapsedRealtimeMillis);
        parcel.writeTypedList(this.probableActivities);
    }
}

