/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.entity.location.fence;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.core.aidl.annotation.Packed;
import com.huawei.hms.location.Geofence;

public class GeofenceEntity
implements Parcelable,
Geofence,
IMessageEntity {
    public static final Parcelable.Creator<GeofenceEntity> CREATOR = new Parcelable.Creator<GeofenceEntity>(){

        public Object[] newArray(int n) {
            return new GeofenceEntity[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new GeofenceEntity(parcel);
        }
    };
    private static final int DEFAULT_UNIQUE_ID_LENGTH_MAX = 100;
    private static final float DEFAULT_RADIUS = 0.0f;
    private static final double DEFAULT_LATITUDE_MAX = 90.0;
    private static final double DEFAULT_LATITUDE_MIN = -90.0;
    private static final double DEFAULT_LONGITUDE_MAX = 180.0;
    private static final double DEFAULT_LONGITUDE_MIN = -180.0;
    private static final int CONVERSIONS_MAX = 7;
    @Packed
    private String uniqueId;
    @Packed
    private int conversions;
    @Packed
    private long validDuration;
    @Packed
    private double latitude;
    @Packed
    private double longitude;
    @Packed
    private float radius;
    @Packed
    private int notificationInterval;
    @Packed
    private int dwellDelayTime;

    public GeofenceEntity(String string, int n, double d, double d3, float f, long l, int n2, int n3) {
        ((GeofenceEntity)this).dwellDelayTime = -1;
        if (!TextUtils.isEmpty((CharSequence)string) && string.length() <= 100) {
            if (!(f <= 0.0f)) {
                if (!(d > 90.0) && !(d < -90.0)) {
                    if (!(d3 > 180.0) && !(d3 < -180.0)) {
                        if ((n & 7) != 0) {
                            Object object = this;
                            ((GeofenceEntity)object).uniqueId = string;
                            ((GeofenceEntity)object).latitude = d;
                            ((GeofenceEntity)object).longitude = d3;
                            ((GeofenceEntity)object).radius = f;
                            ((GeofenceEntity)object).validDuration = l;
                            ((GeofenceEntity)object).conversions = n;
                            ((GeofenceEntity)object).notificationInterval = n2;
                            ((GeofenceEntity)object).dwellDelayTime = n3;
                            return;
                        }
                        throw new IllegalArgumentException("invalid conversions: " + n);
                    }
                    throw new IllegalArgumentException("invalid longitude");
                }
                throw new IllegalArgumentException("invalid latitude");
            }
            throw new IllegalArgumentException("invalid radius: " + f);
        }
        string = TextUtils.isEmpty((CharSequence)string) ? "uniqueId is null" : "uniqueId is too long: ".concat(string);
        Object object = this;
        ((IllegalArgumentException)object)(string);
        throw object;
    }

    private GeofenceEntity(Parcel parcel) {
        this.dwellDelayTime = -1;
        this.uniqueId = parcel.readString();
        this.conversions = parcel.readInt();
        this.validDuration = parcel.readLong();
        this.latitude = parcel.readDouble();
        this.longitude = parcel.readDouble();
        this.radius = parcel.readFloat();
        this.notificationInterval = parcel.readInt();
        this.dwellDelayTime = parcel.readInt();
    }

    @Override
    public final String getUniqueId() {
        return this.uniqueId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.uniqueId);
        parcel.writeInt(this.conversions);
        parcel.writeLong(this.validDuration);
        parcel.writeDouble(this.latitude);
        parcel.writeDouble(this.longitude);
        parcel.writeFloat(this.radius);
        parcel.writeInt(this.notificationInterval);
        parcel.writeInt(this.dwellDelayTime);
    }

    public String toString() {
        return "GeofenceEntity{uniqueId='" + this.uniqueId + '\'' + ", conversions=" + this.conversions + ", validDuration=" + this.validDuration + ", radius=" + this.radius + ", notificationInterval=" + this.notificationInterval + ", dwellDelayTime=" + this.dwellDelayTime + '}';
    }
}

