/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.location.common;

import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.huawei.hms.common.ApiException;
import com.huawei.hms.location.HWLocation;
import com.huawei.hms.location.LocationAvailability;
import com.huawei.hms.location.LocationResult;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.location.common.CollectionsUtil;
import com.huawei.hms.support.api.location.common.exception.LocationStatusCode;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationJsonUtil {
    private static final String TAG = "LocationJsonUtil";

    public static HWLocation parseLocationFromJsonObject(JSONObject jSONObject) throws JSONException, ApiException {
        Status status;
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("location")) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("location");
        if (jSONObject2 == null) {
            return null;
        }
        if (jSONObject2.has("mProvider")) {
            HWLocation hWLocation;
            String string = jSONObject2.getString("mProvider");
            HWLocation hWLocation2 = hWLocation;
            hWLocation2();
            hWLocation2.setProvider(string);
            hWLocation2.setAltitude(jSONObject2.optDouble("mAltitude", 0.0));
            hWLocation.setBearing((float)jSONObject2.optDouble("mBearing", 0.0));
            int n = Build.VERSION.SDK_INT;
            if (n >= 26) {
                hWLocation2.setBearingAccuracyDegrees((float)jSONObject2.optDouble("mBearingAccuracyDegrees", 0.0));
            }
            hWLocation2.setElapsedRealtimeNanos(jSONObject2.optLong("mElapsedRealtimeNanos", 0L));
            hWLocation2.setAccuracy((float)jSONObject2.optDouble("mHorizontalAccuracyMeters", 0.0));
            hWLocation2.setLatitude(jSONObject2.optDouble("mLatitude", 0.0));
            hWLocation2.setLongitude(jSONObject2.optDouble("mLongitude", 0.0));
            hWLocation2.setSpeed((float)jSONObject2.optDouble("mSpeed", 0.0));
            if (n >= 26) {
                hWLocation2.setSpeedAccuracyMetersPerSecond((float)jSONObject2.optDouble("mSpeedAccuracyMetersPerSecond", 0.0));
            }
            hWLocation2.setTime(jSONObject2.optLong("mTime", 0L));
            if (n >= 26) {
                hWLocation2.setVerticalAccuracyMeters((float)jSONObject2.optDouble("mVerticalAccuracyMeters", 0.0));
            }
            LocationJsonUtil.fillAddress(jSONObject, hWLocation2);
            return hWLocation2;
        }
        jSONObject = status;
        status = new Status(10000, LocationStatusCode.getStatusCodeString(10000));
        throw new ApiException((Status)jSONObject);
    }

    private static void fillAddress(JSONObject object, HWLocation hWLocation) throws JSONException {
        if (object.has("address")) {
            HashMap<String, Object> hashMap;
            if ((object = object.getJSONObject("address")) == null) {
                return;
            }
            hWLocation.setCountryCode(object.optString("mCountryCode", ""));
            hWLocation.setCountryName(object.optString("mCountryName", ""));
            hWLocation.setState(object.optString("mState", ""));
            hWLocation.setCity(object.optString("mCity", ""));
            hWLocation.setCounty(object.optString("mCounty", ""));
            hWLocation.setStreet(object.optString("mStreet", ""));
            hWLocation.setFeatureName(object.optString("mFeatureName", ""));
            hWLocation.setPostalCode(object.optString("mPostalCode", ""));
            hWLocation.setPhone(object.optString("mPhone", ""));
            hWLocation.setUrl(object.optString("mUrl", ""));
            if (!object.has("mExtraInfo")) {
                return;
            }
            object = object.opt("mExtraInfo");
            Object object2 = null;
            if (object instanceof JSONObject) {
                object2 = object;
            }
            if (object2 == null) {
                return;
            }
            object = object2.keys();
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap = new HashMap<String, Object>();
            while (object.hasNext()) {
                String string = (String)object.next();
                hashMap2.put(string, object2.get(string));
            }
            hWLocation.setExtraInfo(hashMap2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Location convertLocation(HWLocation iterator) {
        Location location;
        if (iterator == null) {
            return null;
        }
        Location location2 = location;
        location2(((HWLocation)((Object)iterator)).getProvider());
        location.setTime(((HWLocation)((Object)iterator)).getTime());
        int n = Build.VERSION.SDK_INT;
        if (n >= 17) {
            location2.setElapsedRealtimeNanos(((HWLocation)((Object)iterator)).getElapsedRealtimeNanos());
        }
        location2.setLatitude(((HWLocation)((Object)iterator)).getLatitude());
        location2.setLongitude(((HWLocation)((Object)iterator)).getLongitude());
        location2.setAltitude(((HWLocation)((Object)iterator)).getAltitude());
        location2.setSpeed(((HWLocation)((Object)iterator)).getSpeed());
        location2.setBearing(((HWLocation)((Object)iterator)).getBearing());
        location2.setAccuracy(((HWLocation)((Object)iterator)).getAccuracy());
        if (n >= 26) {
            location2.setVerticalAccuracyMeters(((HWLocation)((Object)iterator)).getVerticalAccuracyMeters());
            location2.setSpeedAccuracyMetersPerSecond(((HWLocation)((Object)iterator)).getSpeedAccuracyMetersPerSecond());
            location2.setBearingAccuracyDegrees(((HWLocation)((Object)iterator)).getBearingAccuracyDegrees());
        }
        if (((HWLocation)((Object)iterator)).getExtraInfo() != null) {
            JSONObject jSONObject;
            Bundle bundle;
            Bundle bundle2 = bundle;
            bundle = new Bundle();
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject(((HWLocation)((Object)iterator)).getExtraInfo());
            for (Map.Entry<String, Object> entry : ((HWLocation)((Object)iterator)).getExtraInfo().entrySet()) {
                Object object;
                String string;
                try {
                    string = entry.getKey();
                    if (entry.getKey().startsWith("hw-address-")) continue;
                    object = jSONObject2.get(string);
                }
                catch (JSONException jSONException) {
                    LogLocation.e(TAG, "convertLocation: JSONException");
                }
                {
                    if (object instanceof Boolean) {
                        bundle2.putBoolean(string, ((Boolean)object).booleanValue());
                        continue;
                    }
                    if (object instanceof Integer) {
                        bundle2.putInt(string, ((Integer)object).intValue());
                        continue;
                    }
                    if (object instanceof Float) {
                        bundle2.putFloat(string, ((Float)object).floatValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        bundle2.putLong(string, ((Long)object).longValue());
                        continue;
                    }
                    if (object instanceof Short) {
                        bundle2.putShort(string, ((Short)object).shortValue());
                        continue;
                    }
                    if (object instanceof Double) {
                        bundle2.putDouble(string, ((Double)object).doubleValue());
                        continue;
                    }
                    bundle2.putString(string, jSONObject2.getString(string));
                }
            }
            location2.setExtras(bundle2);
        }
        return location2;
    }

    public static List<HWLocation> parseLocationsFromJsonObject(JSONObject jSONObject) throws JSONException, ApiException {
        ArrayList<HWLocation> arrayList;
        jSONObject = jSONObject.getJSONArray("locations");
        ArrayList<HWLocation> arrayList2 = arrayList;
        arrayList = new ArrayList<HWLocation>();
        for (int i = 0; i < jSONObject.length(); ++i) {
            HWLocation hWLocation = LocationJsonUtil.parseLocationFromJsonObject(jSONObject.getJSONObject(i));
            if (hWLocation == null) continue;
            arrayList2.add(hWLocation);
        }
        if (CollectionsUtil.isEmpty(arrayList2)) {
            return Collections.emptyList();
        }
        return arrayList2;
    }

    public static List<HWLocation> parseHwLocationsFromJsonObject(JSONObject jSONObject) throws JSONException, ApiException {
        ArrayList<HWLocation> arrayList;
        jSONObject = jSONObject.getJSONArray("geocoderResult");
        ArrayList<HWLocation> arrayList2 = arrayList;
        arrayList = new ArrayList<HWLocation>();
        for (int i = 0; i < jSONObject.length(); ++i) {
            HWLocation hWLocation = LocationJsonUtil.parseLocationFromJsonObject(jSONObject.getJSONObject(i));
            if (hWLocation == null) continue;
            arrayList2.add(hWLocation);
        }
        if (CollectionsUtil.isEmpty(arrayList2)) {
            return Collections.emptyList();
        }
        return arrayList2;
    }

    public static LocationResult parseLocationResultFromJsonObject(JSONObject object) throws JSONException, ApiException {
        if (object == null) {
            return null;
        }
        if ((object = object.getJSONObject("locationResult")) == null) {
            return null;
        }
        if (CollectionsUtil.isEmpty(object = LocationJsonUtil.parseLocationsFromJsonObject(object))) {
            return null;
        }
        return LocationResult.create((List<HWLocation>)object);
    }

    public static LocationAvailability parseLocationAvailabilityFromString(String string) throws JSONException {
        LocationAvailability locationAvailability;
        JSONObject jSONObject;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Object object = jSONObject;
        if (!new JSONObject(string).has("locationAvailability")) {
            return null;
        }
        string = object.getJSONObject("locationAvailability");
        if (string == null) {
            return null;
        }
        object = locationAvailability;
        ((LocationAvailability)object)();
        ((LocationAvailability)object).setCellStatus(string.optInt("cellStatus"));
        ((LocationAvailability)object).setWifiStatus(string.optInt("wifiStatus"));
        ((LocationAvailability)object).setElapsedRealtimeNs(string.optLong("elapsedRealtimeNs"));
        locationAvailability.setLocationStatus(string.optInt("locationStatus"));
        return locationAvailability;
    }

    public static JSONObject createLocationJsonObject(Location location) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject2.put("mProvider", (Object)location.getProvider());
        double d = location.getAltitude();
        jSONObject2.put("mAltitude", d);
        d = location.getBearing();
        jSONObject.put("mBearing", d);
        int n = Build.VERSION.SDK_INT;
        if (n >= 17) {
            long l = location.getElapsedRealtimeNanos();
            jSONObject2.put("mElapsedRealtimeNanos", l);
        }
        double d3 = location.getAccuracy();
        jSONObject2.put("mHorizontalAccuracyMeters", d3);
        d3 = location.getLatitude();
        jSONObject2.put("mLatitude", d3);
        d3 = location.getLongitude();
        jSONObject2.put("mLongitude", d3);
        d3 = location.getSpeed();
        jSONObject2.put("mSpeed", d3);
        if (n >= 26) {
            d3 = location.getSpeedAccuracyMetersPerSecond();
            jSONObject2.put("mSpeedAccuracyMetersPerSecond", d3);
            d3 = location.getVerticalAccuracyMeters();
            jSONObject2.put("mVerticalAccuracyMeters", d3);
            d3 = location.getBearingAccuracyDegrees();
            jSONObject2.put("mBearingAccuracyDegrees", d3);
        }
        JSONObject jSONObject3 = jSONObject2;
        long l = location.getTime();
        jSONObject3.put("mTime", l);
        return jSONObject3;
    }
}

