/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.location.common;

import android.net.wifi.ScanResult;
import android.os.Build;
import android.telephony.CellIdentity;
import android.telephony.CellIdentityNr;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoNr;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthNr;
import androidx.annotation.RequiresApi;
import com.huawei.hms.support.api.entity.location.offlinelocation.HwCellInfo;
import com.huawei.hms.support.api.entity.location.offlinelocation.HwWifiInfo;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class OfflineLocationUtil {
    private static final String TAG = "OfflineLocationUtil";
    private static final int RAT_GSM = 1;
    private static final int RAT_WCDMA = 2;
    private static final int RAT_LTE = 3;
    private static final int RAT_NR = 4;
    private static AtomicBoolean isHasCellInfoNr;

    public static List<HwWifiInfo> transformWifiInfo(List<ScanResult> arrayList) {
        if (arrayList != null && arrayList.size() != 0) {
            ArrayList<HwWifiInfo> arrayList2;
            ArrayList<HwWifiInfo> arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<HwWifiInfo>();
            for (ScanResult scanResult : arrayList3) {
                HwWifiInfo hwWifiInfo;
                HwWifiInfo hwWifiInfo2 = hwWifiInfo;
                hwWifiInfo2();
                try {
                    hwWifiInfo.setBssid(scanResult.BSSID);
                }
                catch (NumberFormatException numberFormatException) {
                    LogLocation.e(TAG, "parse bssid failed");
                }
                HwWifiInfo hwWifiInfo3 = hwWifiInfo2;
                hwWifiInfo2.setRssi(scanResult.level);
                hwWifiInfo2.setFrequency(scanResult.frequency);
                hwWifiInfo3.setTimestamp(scanResult.timestamp);
                arrayList.add(hwWifiInfo3);
            }
            LogLocation.i(TAG, "transformWifiInfo end,size is:" + arrayList.size());
            return arrayList;
        }
        return null;
    }

    public static List<HwCellInfo> transformCellInfo(List<CellInfo> arrayList) {
        if (arrayList != null && arrayList.size() != 0) {
            ArrayList<HwCellInfo> arrayList2;
            ArrayList<HwCellInfo> arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<HwCellInfo>();
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                HwCellInfo hwCellInfo = OfflineLocationUtil.parseCellInfo((CellInfo)iterator.next());
                if (hwCellInfo == null) continue;
                arrayList.add(hwCellInfo);
            }
            LogLocation.i(TAG, "transformCellInfo end,size is:" + arrayList.size());
            return arrayList;
        }
        return null;
    }

    private static HwCellInfo parseCellInfo(CellInfo cellInfo) {
        block9: {
            HwCellInfo hwCellInfo;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            HwCellInfo hwCellInfo2;
                            hwCellInfo = hwCellInfo2;
                            hwCellInfo2 = new HwCellInfo();
                            if (!(cellInfo instanceof CellInfoGsm)) break block5;
                            OfflineLocationUtil.parseCellInfoGsm((CellInfoGsm)cellInfo, hwCellInfo);
                            break block6;
                        }
                        if (!(cellInfo instanceof CellInfoWcdma)) break block7;
                        OfflineLocationUtil.parseCellInfoWcdma((CellInfoWcdma)cellInfo, hwCellInfo);
                        break block6;
                    }
                    if (!(cellInfo instanceof CellInfoLte)) break block8;
                    OfflineLocationUtil.parseCellInfoLte((CellInfoLte)cellInfo, hwCellInfo);
                    break block6;
                }
                if (Build.VERSION.SDK_INT < 29) break block9;
                if (isHasCellInfoNr == null) {
                    isHasCellInfoNr = new AtomicBoolean(ReflectionUtils.isSupportClass("android.telephony.CellInfoNr"));
                }
                if (isHasCellInfoNr.get() && cellInfo instanceof CellInfoNr) {
                    OfflineLocationUtil.parseCellInfoNr((CellInfoNr)cellInfo, hwCellInfo);
                }
            }
            HwCellInfo hwCellInfo3 = hwCellInfo;
            hwCellInfo.setTimeStamp(cellInfo.getTimeStamp());
            hwCellInfo3.setRegistered(cellInfo.isRegistered());
            return hwCellInfo3;
        }
        LogLocation.i(TAG, "parseCellInfo fail");
        return null;
    }

    private static void parseCellInfoLte(CellInfoLte cellInfoLte, HwCellInfo hwCellInfo) {
        HwCellInfo hwCellInfo2 = hwCellInfo;
        hwCellInfo.setMcc(cellInfoLte.getCellIdentity().getMcc());
        hwCellInfo.setMnc(cellInfoLte.getCellIdentity().getMnc());
        hwCellInfo.setLacOrTac(cellInfoLte.getCellIdentity().getTac());
        hwCellInfo2.setCellId(cellInfoLte.getCellIdentity().getCi());
        hwCellInfo2.setRat(3);
        hwCellInfo.setRssi(cellInfoLte.getCellSignalStrength().getDbm());
        hwCellInfo.setPhysicalIdentity(cellInfoLte.getCellIdentity().getPci());
        if (Build.VERSION.SDK_INT >= 24) {
            hwCellInfo.setChannelNumber(cellInfoLte.getCellIdentity().getEarfcn());
        }
    }

    private static void parseCellInfoWcdma(CellInfoWcdma cellInfoWcdma, HwCellInfo hwCellInfo) {
        HwCellInfo hwCellInfo2 = hwCellInfo;
        hwCellInfo.setMcc(cellInfoWcdma.getCellIdentity().getMcc());
        hwCellInfo.setMnc(cellInfoWcdma.getCellIdentity().getMnc());
        hwCellInfo.setLacOrTac(cellInfoWcdma.getCellIdentity().getLac());
        hwCellInfo2.setCellId(cellInfoWcdma.getCellIdentity().getCid());
        hwCellInfo2.setRat(2);
        hwCellInfo.setRssi(cellInfoWcdma.getCellSignalStrength().getDbm());
        hwCellInfo.setPhysicalIdentity(cellInfoWcdma.getCellIdentity().getPsc());
        if (Build.VERSION.SDK_INT >= 24) {
            hwCellInfo.setChannelNumber(cellInfoWcdma.getCellIdentity().getUarfcn());
        }
    }

    private static void parseCellInfoGsm(CellInfoGsm cellInfoGsm, HwCellInfo hwCellInfo) {
        HwCellInfo hwCellInfo2 = hwCellInfo;
        hwCellInfo.setMcc(cellInfoGsm.getCellIdentity().getMcc());
        hwCellInfo.setMnc(cellInfoGsm.getCellIdentity().getMnc());
        hwCellInfo.setLacOrTac(cellInfoGsm.getCellIdentity().getLac());
        hwCellInfo2.setCellId(cellInfoGsm.getCellIdentity().getCid());
        hwCellInfo2.setRat(1);
        hwCellInfo.setRssi(cellInfoGsm.getCellSignalStrength().getDbm());
        if (Build.VERSION.SDK_INT >= 24) {
            hwCellInfo.setChannelNumber(cellInfoGsm.getCellIdentity().getArfcn());
            hwCellInfo.setPhysicalIdentity(cellInfoGsm.getCellIdentity().getBsic());
        }
    }

    @RequiresApi(api=29)
    private static void parseCellInfoNr(CellInfoNr cellInfoNr, HwCellInfo hwCellInfo) {
        CellIdentity cellIdentity = cellInfoNr.getCellIdentity();
        if (cellIdentity instanceof CellIdentityNr) {
            HwCellInfo hwCellInfo2 = hwCellInfo;
            cellIdentity = (CellIdentityNr)cellIdentity;
            try {
                hwCellInfo2.setMcc(Integer.parseInt(cellIdentity.getMccString()));
                hwCellInfo2.setMnc(Integer.parseInt(cellIdentity.getMncString()));
            }
            catch (NumberFormatException numberFormatException) {
                LogLocation.e(TAG, "parse cellInfoNr mcc/mnc failed");
            }
            HwCellInfo hwCellInfo3 = hwCellInfo;
            hwCellInfo.setLacOrTac(cellIdentity.getTac());
            hwCellInfo3.setCellId(cellIdentity.getNci());
            hwCellInfo3.setRat(4);
            hwCellInfo.setPhysicalIdentity(cellIdentity.getPci());
            hwCellInfo.setChannelNumber(cellIdentity.getNrarfcn());
            hwCellInfo.setRssi(OfflineLocationUtil.getCellSignalStrength(cellInfoNr));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresApi(api=29)
    private static int getCellSignalStrength(CellInfoNr cellInfoNr) {
        int n = cellInfoNr.getCellSignalStrength().getDbm();
        if (n != Integer.MAX_VALUE) return n;
        if (!((cellInfoNr = cellInfoNr.getCellSignalStrength()) instanceof CellSignalStrengthNr)) {
            return Integer.MAX_VALUE;
        }
        cellInfoNr = (CellSignalStrengthNr)cellInfoNr;
        int n2 = cellInfoNr.getSsRsrp();
        CellInfoNr cellInfoNr2 = cellInfoNr;
        int n3 = cellInfoNr2.getSsRsrq();
        int n4 = cellInfoNr2.getSsSinr();
        int n5 = cellInfoNr2.getCsiRsrp();
        int n6 = cellInfoNr2.getCsiRsrq();
        int n7 = cellInfoNr2.getCsiSinr();
        if (n2 != Integer.MAX_VALUE && n3 != Integer.MAX_VALUE && n4 != Integer.MAX_VALUE) {
            if (n2 <= 0) return n2;
            n2 = -n2;
            return n2;
        }
        if (n5 != Integer.MAX_VALUE && n6 != Integer.MAX_VALUE && n7 != Integer.MAX_VALUE) {
            if (n5 <= 0) return n5;
            return -n5;
        }
        LogLocation.d(TAG, "getCellSignalStrength error");
        return n;
    }
}

