/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.base.activity;

import android.content.Context;
import com.huawei.hms.location.entity.activity.ActivityRecognitionResult;
import com.huawei.hms.location.entity.activity.ActivityTransitionRequest;
import com.huawei.location.base.activity.ActivityRecognitionMappingManager;
import com.huawei.location.base.activity.ActivityTransitionMappingManager;
import com.huawei.location.base.activity.callback.ARCallback;
import com.huawei.location.base.activity.callback.ATCallback;
import com.huawei.location.base.activity.entity.ClientInfo;
import com.huawei.location.base.activity.permission.ARLocationPermissionManager;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractARServiceManager {
    private static final String TAG = "AbstractARServiceManager";
    protected Context mContext = ContextUtil.getContext();
    protected ActivityTransitionMappingManager transitionMappingManager;
    protected ActivityRecognitionMappingManager recognitionMappingManager;
    protected ScheduledFuture scheduledFuture;
    protected ScheduledExecutorService scheduledExecutorService;
    protected long lastTimeByTimer = -1L;

    protected AbstractARServiceManager(ActivityTransitionMappingManager activityTransitionMappingManager, ActivityRecognitionMappingManager activityRecognitionMappingManager) {
        this.transitionMappingManager = activityTransitionMappingManager;
        this.recognitionMappingManager = activityRecognitionMappingManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void scheduleTimer() {
        try {
            long l = this.recognitionMappingManager.getMinTime();
            if (-1L == l) {
                LogLocation.i(TAG, "scheduleTimer return time is " + l);
                this.lastTimeByTimer = -1L;
                this.stopScheduled();
                return;
            }
            long l2 = this.lastTimeByTimer;
            if (l2 != -1L) {
                if (l == l2) return;
                LogLocation.i(TAG, "scheduleTimer begin again time is " + l);
                this.lastTimeByTimer = l;
                this.restartScheduled(l);
                return;
            }
            LogLocation.i(TAG, "scheduleTimer begin time is " + l);
            this.lastTimeByTimer = l;
            this.startScheduled(l);
            return;
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "scheduleTimer exception", true);
        }
    }

    protected void restartScheduled(long l) {
        AbstractARServiceManager abstractARServiceManager = this;
        abstractARServiceManager.stopScheduled();
        abstractARServiceManager.startScheduled(l);
    }

    protected Runnable getTask() {
        return null;
    }

    protected void startScheduled(long l) {
        LogLocation.i(TAG, "startScheduled enter");
        if (object.scheduledExecutorService == null) {
            object.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        AbstractARServiceManager abstractARServiceManager = object;
        Runnable runnable = object.getTask();
        Object object = TimeUnit.MILLISECONDS;
        abstractARServiceManager.scheduledFuture = abstractARServiceManager.scheduledExecutorService.scheduleWithFixedDelay(runnable, 0L, l, (TimeUnit)((Object)object));
        LogLocation.i(TAG, "startScheduled exit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopScheduled() {
        LogLocation.i(TAG, "stopScheduled enter");
        try {
            ScheduledFuture scheduledFuture = this.scheduledFuture;
            if (scheduledFuture != null && !scheduledFuture.isCancelled()) {
                boolean bl = this.scheduledFuture.cancel(true);
                LogLocation.i(TAG, "stopScheduled exit:" + bl);
                return;
            }
            LogLocation.i(TAG, "scheduled not init or cancelled");
            return;
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "stopScheduled exit exception", true);
        }
    }

    public abstract boolean isConnected();

    protected boolean checkActivityRecognitionPermission(ClientInfo clientInfo) {
        if (clientInfo == null) {
            return false;
        }
        ClientInfo clientInfo2 = clientInfo;
        int n = clientInfo2.getClientPid();
        int n2 = clientInfo2.getClientUid();
        return ARLocationPermissionManager.checkCPActivityRecognitionPermission(TAG, n, n2);
    }

    public ActivityTransitionMappingManager getTransitionMappingManager() {
        return this.transitionMappingManager;
    }

    public ActivityRecognitionMappingManager getRecognitionRequestMapping() {
        return this.recognitionMappingManager;
    }

    public abstract boolean connectService();

    public abstract boolean disConnectService();

    public abstract void requestActivityTransitionUpdates(ActivityTransitionRequest var1, ATCallback var2, ClientInfo var3);

    public abstract void removeActivityTransitionUpdates(ATCallback var1, ClientInfo var2);

    public abstract void requestActivityUpdates(long var1, ARCallback var3, ClientInfo var4);

    public abstract void removeActivityUpdates(ARCallback var1, ClientInfo var2);

    public abstract ActivityRecognitionResult getDetectedActivity(int var1, int var2);
}

