/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.base.activity;

import android.os.SystemClock;
import com.huawei.hms.location.entity.activity.ActivityRecognitionResult;
import com.huawei.hms.location.entity.activity.DetectedActivity;
import com.huawei.location.base.activity.ActivityRecognitionMappingInfo;
import com.huawei.location.base.activity.callback.ARCallback;
import com.huawei.location.base.activity.entity.ClientInfo;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActivityRecognitionMappingManager {
    private static final String TAG = "ActivityRecognitionMappingManager";
    private List<ActivityRecognitionMappingInfo> activityRecognitionMappingInfoList;

    public ActivityRecognitionMappingManager() {
        CopyOnWriteArrayList copyOnWriteArrayList;
        CopyOnWriteArrayList copyOnWriteArrayList2 = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.activityRecognitionMappingInfoList = copyOnWriteArrayList2;
    }

    private boolean isUpdate(ActivityRecognitionMappingInfo activityRecognitionMappingInfo) {
        for (int i = 0; i < ((ActivityRecognitionMappingManager)((Object)activityRecognitionMappingInfo2)).activityRecognitionMappingInfoList.size(); ++i) {
            if (!((ActivityRecognitionMappingManager)((Object)activityRecognitionMappingInfo2)).activityRecognitionMappingInfoList.get(i).equals(activityRecognitionMappingInfo)) continue;
            ActivityRecognitionMappingInfo activityRecognitionMappingInfo2 = ((ActivityRecognitionMappingManager)((Object)activityRecognitionMappingInfo2)).activityRecognitionMappingInfoList.get(i);
            LogLocation.i(TAG, "need update arMappingInfo:time:" + activityRecognitionMappingInfo2.getDetectionIntervalMillis() + "->" + activityRecognitionMappingInfo.getDetectionIntervalMillis());
            activityRecognitionMappingInfo2.setDetectionIntervalMillis(activityRecognitionMappingInfo.getDetectionIntervalMillis());
            activityRecognitionMappingInfo2.setClientInfo(activityRecognitionMappingInfo.getClientInfo());
            return true;
        }
        return false;
    }

    private void callBackWithReport(ActivityRecognitionMappingInfo activityRecognitionMappingInfo, ActivityRecognitionResult activityRecognitionResult) {
        try {
            activityRecognitionMappingInfo.getCallback().onActivityRecognition(activityRecognitionResult);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "Failed to get activity recognition callback", true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addActivityUpdatesMappingInfo(long l, ARCallback aRCallback, ClientInfo clientInfo) {
        ActivityRecognitionMappingInfo activityRecognitionMappingInfo;
        LogLocation.i(TAG, "addActivityUpdatesMappingInfo enter, detectionIntervalMillis:" + l + ", callback:" + aRCallback);
        ActivityRecognitionMappingInfo activityRecognitionMappingInfo2 = activityRecognitionMappingInfo;
        activityRecognitionMappingInfo2();
        activityRecognitionMappingInfo2.setCallback(aRCallback);
        activityRecognitionMappingInfo2.setClientInfo(clientInfo);
        activityRecognitionMappingInfo.setDetectionIntervalMillis(l);
        if (this.activityRecognitionMappingInfoList.isEmpty() || !this.isUpdate(activityRecognitionMappingInfo2)) {
            this.activityRecognitionMappingInfoList.add(activityRecognitionMappingInfo2);
        }
        LogLocation.i(TAG, "addActivityUpdatesMappingInfo success, infos size:" + this.activityRecognitionMappingInfoList.size());
    }

    public void removeActivityUpdatesMappingInfo(ARCallback aRCallback) {
        ArrayList<ActivityRecognitionMappingInfo> arrayList;
        LogLocation.i(TAG, "removeActivityUpdatesMappingInfo enter, callback:" + aRCallback, true);
        if (aRCallback == null) {
            LogLocation.e(TAG, "callback is null");
            return;
        }
        ArrayList<ActivityRecognitionMappingInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<ActivityRecognitionMappingInfo>();
        for (ActivityRecognitionMappingInfo activityRecognitionMappingInfo : this.activityRecognitionMappingInfoList) {
            if (!activityRecognitionMappingInfo.getCallback().equals(aRCallback)) continue;
            arrayList2.add(activityRecognitionMappingInfo);
        }
        this.activityRecognitionMappingInfoList.removeAll(arrayList2);
        LogLocation.i(TAG, "removeActivityUpdatesMappingInfo success,  infos size:" + this.activityRecognitionMappingInfoList.size(), true);
    }

    public List<ActivityRecognitionMappingInfo> removeActivityUpdatesMappingInfoByPackageName(String string) {
        ArrayList<ActivityRecognitionMappingInfo> arrayList;
        LogLocation.i(TAG, "removeActivityUpdatesMappingInfoByPackageName:enter:" + string);
        ArrayList<ActivityRecognitionMappingInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<ActivityRecognitionMappingInfo>();
        for (ActivityRecognitionMappingInfo activityRecognitionMappingInfo : this.activityRecognitionMappingInfoList) {
            if (!activityRecognitionMappingInfo.getClientInfo().getPackageName().equals(string)) continue;
            arrayList2.add(activityRecognitionMappingInfo);
        }
        this.activityRecognitionMappingInfoList.removeAll(arrayList2);
        LogLocation.i(TAG, "removeActivityUpdatesMappingInfoByPackageName:exit:" + string);
        return arrayList2;
    }

    public void send(List<DetectedActivity> object) {
        LogLocation.i(TAG, "send begin");
        if (object.size() > 0) {
            ActivityRecognitionResult activityRecognitionResult;
            ActivityRecognitionResult activityRecognitionResult2 = activityRecognitionResult;
            long l = System.currentTimeMillis();
            long l2 = SystemClock.elapsedRealtime();
            activityRecognitionResult = new ActivityRecognitionResult((List<DetectedActivity>)object, l, l2);
            for (ActivityRecognitionMappingInfo activityRecognitionMappingInfo : this.activityRecognitionMappingInfoList) {
                LogLocation.i(TAG, "sending");
                this.callBackWithReport(activityRecognitionMappingInfo, activityRecognitionResult2);
            }
        }
    }

    public long getMinTime() {
        long l = -1L;
        Iterator<ActivityRecognitionMappingInfo> iterator = ((ActivityRecognitionMappingManager)((Object)iterator)).activityRecognitionMappingInfoList.iterator();
        while (iterator.hasNext()) {
            long l2 = ((ActivityRecognitionMappingInfo)iterator.next()).getDetectionIntervalMillis();
            if (l != -1L && l2 >= l) {
                l2 = l;
            }
            l = l2;
        }
        LogLocation.i(TAG, "getMinTime ,minTime is " + l);
        return l;
    }

    public boolean isEmptyRequest() {
        List<ActivityRecognitionMappingInfo> list = ((ActivityRecognitionMappingManager)((Object)list)).activityRecognitionMappingInfoList;
        return list == null || list.isEmpty();
    }

    public List<ActivityRecognitionMappingInfo> getInfos() {
        return this.activityRecognitionMappingInfoList;
    }
}

