/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.base.activity;

import android.content.Context;
import android.os.SystemClock;
import com.huawei.hms.location.entity.activity.ActivityTransition;
import com.huawei.hms.location.entity.activity.ActivityTransitionEvent;
import com.huawei.hms.location.entity.activity.ActivityTransitionResult;
import com.huawei.location.base.activity.ActivityRecognitionConstantsMapping;
import com.huawei.location.base.activity.ActivityTransitionMappingInfo;
import com.huawei.location.base.activity.callback.ATCallback;
import com.huawei.location.base.activity.entity.ClientInfo;
import com.huawei.location.base.activity.entity.MovementEvent;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActivityTransitionMappingManager {
    private static final String TAG = "ActivityTransitionMappingManager";
    private List<ActivityTransitionMappingInfo> infos;
    private Map<String, Integer> returnEventsCache;

    public ActivityTransitionMappingManager() {
        ConcurrentHashMap concurrentHashMap;
        CopyOnWriteArrayList copyOnWriteArrayList;
        Object object = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.infos = object;
        object = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.returnEventsCache = object;
    }

    private boolean isUpdate(ActivityTransitionMappingInfo activityTransitionMappingInfo) {
        for (int i = 0; i < ((ActivityTransitionMappingManager)((Object)activityTransitionMappingInfo2)).infos.size(); ++i) {
            if (!((ActivityTransitionMappingManager)((Object)activityTransitionMappingInfo2)).infos.get(i).equals(activityTransitionMappingInfo)) continue;
            ActivityTransitionMappingInfo activityTransitionMappingInfo2 = ((ActivityTransitionMappingManager)((Object)activityTransitionMappingInfo2)).infos.get(i);
            LogLocation.i(TAG, "need update atMappingInfo:atRequestSize:" + activityTransitionMappingInfo2.getActivityTransitions().size() + "->" + activityTransitionMappingInfo.getActivityTransitions().size());
            activityTransitionMappingInfo2.setActivityTransitions(activityTransitionMappingInfo.getActivityTransitions());
            activityTransitionMappingInfo2.setClientInfo(activityTransitionMappingInfo.getClientInfo());
            return true;
        }
        return false;
    }

    private void callBackWithReport(ActivityTransitionMappingInfo activityTransitionMappingInfo, List<ActivityTransitionEvent> list) {
        ActivityTransitionResult activityTransitionResult;
        ActivityTransitionMappingInfo activityTransitionMappingInfo2 = activityTransitionMappingInfo;
        ActivityTransitionResult activityTransitionResult2 = activityTransitionResult;
        try {
            activityTransitionResult = new ActivityTransitionResult(list);
            activityTransitionMappingInfo2.getCallback().onActivityTransition(activityTransitionResult2);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "Failed to get activity transition callback", true);
        }
    }

    private List<ActivityTransitionEvent> getActivityTransitionEvents(List<ActivityTransition> object, Iterable<MovementEvent> iterable) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        if (object != null && !object.isEmpty() && iterable != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ActivityTransition activityTransition = (ActivityTransition)object.next();
                for (MovementEvent movementEvent : iterable) {
                    ActivityTransitionEvent activityTransitionEvent;
                    String string = movementEvent.getMovement();
                    int n = ActivityRecognitionConstantsMapping.getActivityTypeOpposite(string);
                    int n2 = ActivityRecognitionConstantsMapping.getTransitionTypeOpposite(movementEvent.getEventType());
                    if (activityTransition.getActivityType() != n || activityTransition.getTransitionType() != n2) continue;
                    ActivityTransitionEvent activityTransitionEvent2 = activityTransitionEvent;
                    long l = SystemClock.elapsedRealtimeNanos();
                    activityTransitionEvent = new ActivityTransitionEvent(n, n2, l);
                    arrayList2.add(activityTransitionEvent2);
                }
            }
            return arrayList2;
        }
        return arrayList2;
    }

    public List<ActivityTransitionMappingInfo> getInfos() {
        return this.infos;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addActivityTransitionMappingInfo(List<ActivityTransition> list, ATCallback aTCallback, ClientInfo clientInfo) {
        LogLocation.i(TAG, "addActivityTransitionMappingInfo callback:");
        if (list != null && !list.isEmpty() && aTCallback != null) {
            ActivityTransitionMappingInfo activityTransitionMappingInfo;
            ActivityTransitionMappingInfo activityTransitionMappingInfo2 = activityTransitionMappingInfo;
            activityTransitionMappingInfo2();
            activityTransitionMappingInfo2.setActivityTransitions(list);
            activityTransitionMappingInfo2.setCallback(aTCallback);
            activityTransitionMappingInfo.setClientInfo(clientInfo);
            if (this.infos.isEmpty() || !this.isUpdate(activityTransitionMappingInfo2)) {
                this.infos.add(activityTransitionMappingInfo2);
            }
            LogLocation.i(TAG, "addActivityTransitionMappingInfo end size is " + this.infos.size());
            return;
        }
        LogLocation.i(TAG, "null == transitions || transitions.size() < 1 || null == pendingIntent");
    }

    public List<ActivityTransition> removeActivityTransitionMappingInfo(ATCallback object) {
        ArrayList<ActivityTransitionMappingInfo> arrayList;
        ArrayList<ActivityTransition> arrayList2;
        HashMap<String, Boolean> hashMap;
        LogLocation.i(TAG, "removeActivityTransitionMappingInfo callback: " + object + " ,size is " + this.infos.size(), true);
        HashMap<String, Boolean> hashMap2 = hashMap;
        hashMap = new HashMap<String, Boolean>(this.infos.size());
        ArrayList<ActivityTransition> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<ActivityTransition>();
        ArrayList<ActivityTransitionMappingInfo> arrayList4 = arrayList;
        arrayList = new ArrayList<ActivityTransitionMappingInfo>();
        for (ActivityTransitionMappingInfo activityTransitionMappingInfo : this.infos) {
            Object object2 = activityTransitionMappingInfo.getActivityTransitions();
            if (activityTransitionMappingInfo.getCallback().equals(object)) {
                arrayList4.add(activityTransitionMappingInfo);
                arrayList3.addAll((Collection<ActivityTransition>)object2);
                continue;
            }
            if (object2 == null || object2.size() <= 0) continue;
            Iterator<ActivityTransition> iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                hashMap2.put(((ActivityTransition)object2).getActivityType() + "-" + ((ActivityTransition)object2).getTransitionType(), Boolean.TRUE);
            }
        }
        if (arrayList3.size() > 0) {
            object = arrayList3.iterator();
            while (object.hasNext()) {
                ActivityTransition activityTransition = (ActivityTransition)object.next();
                if (hashMap2.isEmpty() || !hashMap2.containsKey(activityTransition.getActivityType() + "-" + activityTransition.getTransitionType())) continue;
                object.remove();
                LogLocation.i(TAG, "other request contain:" + activityTransition.getActivityType() + "-" + activityTransition.getTransitionType() + ", not disable");
            }
        }
        this.infos.removeAll(arrayList4);
        LogLocation.i(TAG, "removeActivityTransitionMappingInfo end size is " + this.infos.size());
        return arrayList3;
    }

    public List<ActivityTransitionMappingInfo> removeActivityTransitionMappingInfoByPackageName(String string) {
        ArrayList<ActivityTransitionMappingInfo> arrayList;
        LogLocation.i(TAG, "removeActivityTransitionMappingInfoByPackageName:enter:" + string);
        ArrayList<ActivityTransitionMappingInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<ActivityTransitionMappingInfo>();
        for (ActivityTransitionMappingInfo activityTransitionMappingInfo : this.infos) {
            if (!activityTransitionMappingInfo.getClientInfo().getPackageName().equals(string)) continue;
            arrayList2.add(activityTransitionMappingInfo);
        }
        this.infos.removeAll(arrayList2);
        LogLocation.i(TAG, "removeActivityTransitionMappingInfoByPackageName:exit:" + string);
        return arrayList2;
    }

    public void sendActivityTransitionMappingInfo(Iterable<MovementEvent> iterable, Context object) {
        LogLocation.i(TAG, "sendActivityTransitionMappingInfo:requestList size:" + this.infos.size(), true);
        for (ActivityTransitionMappingInfo activityTransitionMappingInfo : this.infos) {
            List<ActivityTransitionEvent> list = this.getActivityTransitionEvents(activityTransitionMappingInfo.getActivityTransitions(), iterable);
            LogLocation.i(TAG, "sendActivityTransitionMappingInfo,events size is " + list.size());
            if (list.size() <= 0) continue;
            this.callBackWithReport(activityTransitionMappingInfo, list);
        }
    }

    public Iterable<MovementEvent> compareReturnEventCache(Iterable<MovementEvent> arrayList) {
        ArrayList<MovementEvent> arrayList2;
        ArrayList<MovementEvent> arrayList3 = arrayList;
        LogLocation.i(TAG, "compareReturnEventCache");
        arrayList = arrayList2;
        arrayList2 = new ArrayList<MovementEvent>();
        Iterator<Object> iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            arrayList.add((MovementEvent)iterator.next());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            MovementEvent movementEvent = (MovementEvent)iterator.next();
            String string = movementEvent.getMovement();
            int n = movementEvent.getEventType();
            LogLocation.i(TAG, "movement " + string + "eventType " + n);
            if (this.returnEventsCache.isEmpty()) {
                this.returnEventsCache.put(string, n);
                continue;
            }
            Integer n2 = this.returnEventsCache.get(string);
            this.returnEventsCache.put(string, n);
            if (n2 == null || n2 != n) continue;
            LogLocation.i(TAG, "already report , remove it");
            iterator.remove();
        }
        return arrayList;
    }

    public boolean isEmptyRequest() {
        List<ActivityTransitionMappingInfo> list = ((ActivityTransitionMappingManager)((Object)list)).infos;
        return list == null || list.isEmpty();
    }
}

