/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.base.activity.permission;

import android.os.Build;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.exception.LocationServiceException;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.PermissionUtil;

public class ARLocationPermissionManager {
    private static final String TAG = "ARLocationPermissionManager";
    private static final String ACTIVITY_RECOGNITION_ANDROID_Q = "android.permission.ACTIVITY_RECOGNITION";
    private static final String PERMISSION_DENIED = "PERMISSION_DENIED";

    public static boolean checkCPActivityRecognitionPermission(String string, int n, int n2) {
        boolean bl;
        if (Build.VERSION.SDK_INT <= 28) {
            bl = true;
            LogLocation.i(string, " Activity recognition permission is " + bl);
        } else {
            bl = PermissionUtil.hasPermission(ContextUtil.getHMSContext(), ACTIVITY_RECOGNITION_ANDROID_Q, n, n2);
            LogLocation.i(string, "Activity recognition permission on android Q   is " + bl);
        }
        if (!bl) {
            LogLocation.e(string, "pid: " + n + ",uid: " + n2 + " has no activity recognition permission ", true);
        }
        return bl;
    }

    public static boolean checkCPActivityRecognitionPermissionByException(String string, String string2, int n, int n2) {
        boolean bl = ARLocationPermissionManager.checkCPActivityRecognitionPermission(string, n, n2);
        n = bl ? 1 : 0;
        if (bl) {
            return n != 0;
        }
        LogLocation.e(string, string2 + " has no activity recognition permission");
        throw new LocationServiceException(10803, "PERMISSION_DENIED " + string2 + " has no Activity Recognition permission");
    }
}

