/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.agc;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.location.lite.common.agc.net.AGCResponse;
import com.huawei.location.lite.common.agc.net.yn;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.grs.LocationNlpGrsHelper;
import com.huawei.location.lite.common.http.HttpClientEx;
import com.huawei.location.lite.common.http.adapter.HttpClientBuilder;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.exception.OnFailureException;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.http.request.HeadBuilder;
import com.huawei.location.lite.common.http.request.RequestJsonBody;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.security.LocationSecurityManager;
import com.huawei.location.lite.common.util.APKUtil;
import com.huawei.location.lite.common.util.PreferencesHelper;
import java.util.UUID;

public class AGCManager {
    private static final String TAG = "AGCManager";
    private static final String TOKEN_KEY = "Token";
    private static final String EXPIRE_TIME_KEY = "ExpireTime";
    private static final String SECURITY_AGC = "AGC_INFO";
    private static final byte[] SYNC_LOCK = new byte[0];
    private static volatile AGCManager instance;
    private final PreferencesHelper preferencesHelper;
    private volatile com.huawei.location.lite.common.agc.yn mAgcInfo;
    private yn mOnlineAgcService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AGCManager getInstance() {
        if (instance != null) return instance;
        byte[] byArray = SYNC_LOCK;
        synchronized (SYNC_LOCK) {
            if (instance != null) return instance;
            instance = new AGCManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AGCManager() {
        PreferencesHelper preferencesHelper;
        PreferencesHelper preferencesHelper2 = preferencesHelper;
        preferencesHelper = new PreferencesHelper("AGCInfo");
        v1.preferencesHelper = preferencesHelper2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private com.huawei.location.lite.common.agc.yn asyncGetAgcInfo() {
        Object object;
        block11: {
            AGCResponse aGCResponse;
            if (((AGCManager)object2).mOnlineAgcService == null) {
                yn yn2;
                object = yn2;
                yn2 = new yn();
                ((AGCManager)object2).mOnlineAgcService = object;
            }
            ((AGCManager)object2).mOnlineAgcService.getClass();
            LogLocation.i("OnlineAgcService", "getOnlineAgcInfo");
            Object object2 = aGCResponse;
            aGCResponse = new AGCResponse();
            object = new RequestJsonBody.Builder().add("fingerprint", APKUtil.getSignatureForPkgName(ContextUtil.getContext().getPackageName())).build();
            String string = UUID.randomUUID().toString();
            String string2 = LocationNlpGrsHelper.getGrsHostAddress("com.huawei.hms.location");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                LogLocation.e("OnlineAgcService", "grsHostAddress is null");
                break block11;
            }
            String string3 = ContextUtil.getContext().getPackageName();
            HeadBuilder headBuilder = new HeadBuilder(string).setPackageName(string3);
            object = new BaseRequest.Builder("/location/v1/getToken").setBaseUrl(string2).setHeads(headBuilder).setBody((RequestJsonBody)object);
            try {
                object2 = new HttpClientEx(ContextUtil.getContext(), new HttpClientBuilder().setNeedCheckAGC(false)).newSubmit(((BaseRequest.Builder)object).build()).execute(AGCResponse.class);
                LogLocation.i("OnlineAgcService", "doHttp, response code is " + ((AGCResponse)object2).getApiCode());
            }
            catch (Exception exception) {
                LogLocation.e("OnlineAgcService", "unknown exception");
            }
            catch (OnErrorException onErrorException) {
                LogLocation.e("OnlineAgcService", "doHttp, OnErrorException: code is " + onErrorException.getApiCode() + ", msg is " + onErrorException.getApiMsg());
            }
            catch (OnFailureException onFailureException) {
                LogLocation.e("OnlineAgcService", "doHttp, OnFailureException: code is " + onFailureException.getErrorCode() + ", msg is " + onFailureException.getMessage());
            }
        }
        object = null;
        if (((AGCResponse)object2).isSuccess()) {
            com.huawei.location.lite.common.agc.yn yn3;
            LogLocation.i("OnlineAgcService", "getOnlineAgcInfo success,save to cache");
            object = yn3;
            ((com.huawei.location.lite.common.agc.yn)object)();
            ((com.huawei.location.lite.common.agc.yn)object).yn(((AGCResponse)object2).getExpireTime());
            yn3.yn(((AGCResponse)object2).getToken());
            AGCManager.getInstance().setAgcCache((com.huawei.location.lite.common.agc.yn)object);
        }
        return object;
    }

    public synchronized com.huawei.location.lite.common.agc.yn getAgcInfo() {
        if (((AGCManager)((Object)locationSecurityManager2)).mAgcInfo != null && System.currentTimeMillis() <= ((AGCManager)((Object)locationSecurityManager2)).mAgcInfo.yn()) {
            LogLocation.i(TAG, "use cache agcInfo");
            return ((AGCManager)((Object)locationSecurityManager2)).mAgcInfo;
        }
        AGCManager aGCManager = locationSecurityManager2;
        aGCManager.mAgcInfo = aGCManager.asyncGetAgcInfo();
        if (aGCManager.mAgcInfo != null) {
            LogLocation.i(TAG, "use agcInfo from online");
            return ((AGCManager)((Object)locationSecurityManager2)).mAgcInfo;
        }
        AGCManager aGCManager2 = locationSecurityManager2;
        long l = aGCManager2.preferencesHelper.getLong(EXPIRE_TIME_KEY);
        String string = aGCManager2.preferencesHelper.getString(TOKEN_KEY);
        if (System.currentTimeMillis() <= l && !TextUtils.isEmpty((CharSequence)string)) {
            LocationSecurityManager locationSecurityManager;
            AGCManager aGCManager3 = locationSecurityManager2;
            LogLocation.i(TAG, "use agcInfo from sp");
            LocationSecurityManager locationSecurityManager2 = locationSecurityManager;
            locationSecurityManager = new LocationSecurityManager(3);
            aGCManager3.mAgcInfo = new com.huawei.location.lite.common.agc.yn();
            aGCManager3.mAgcInfo.yn(locationSecurityManager2.decrypt(string, SECURITY_AGC));
            aGCManager3.mAgcInfo.yn(l);
            return aGCManager3.mAgcInfo;
        }
        return null;
    }

    public synchronized void setAgcCache(com.huawei.location.lite.common.agc.yn yn2) {
        LocationSecurityManager locationSecurityManager;
        AGCManager aGCManager = locationSecurityManager2;
        aGCManager.mAgcInfo = yn2;
        LocationSecurityManager locationSecurityManager2 = locationSecurityManager;
        locationSecurityManager = new LocationSecurityManager(3);
        aGCManager.preferencesHelper.saveString(TOKEN_KEY, locationSecurityManager2.encrypt(yn2.Vw(), SECURITY_AGC));
        long l = yn2.yn();
        aGCManager.preferencesHelper.saveLong(EXPIRE_TIME_KEY, l);
    }

    public String getAppId() {
        block4: {
            try {
                AGCManager aGCManager = AGConnectServicesConfig.fromContext((Context)ContextUtil.getContext());
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "get agc appId by exception");
                return "";
            }
            if (!TextUtils.isEmpty((CharSequence)aGCManager.getString("client/app_id"))) break block4;
            return "";
        }
        return aGCManager.getString("client/app_id");
    }

    public synchronized boolean checkAgc() {
        return AGCManager.getInstance().getAgcInfo() != null;
    }

    public synchronized void notifyAkChange() {
        this.mAgcInfo = null;
    }
}

