/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.android.receiver;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.android.receiver.SafeBroadcastReceiver;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.secure.android.common.intent.SafeIntent;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class GnssAndNetReceiver {
    private static final String TAG = "GnssAndNetReceiver";
    private SafeBroadcastReceiver gnssReceiver;
    private SafeBroadcastReceiver networkReceiver;
    private AtomicInteger networkCnt;
    private boolean isFirstReceive = true;

    public GnssAndNetReceiver() {
        IntentFilter intentFilter;
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.location.MODE_CHANGED");
        this.gnssReceiver = new SafeBroadcastReceiver(){

            @Override
            public void onSafeReceive(Intent intent) {
                if (TextUtils.equals((CharSequence)new SafeIntent(intent).getAction(), (CharSequence)"android.location.MODE_CHANGED")) {
                    GnssAndNetReceiver.this.notifyListeners();
                }
            }

            @Override
            public String receiveThreadName() {
                return "Loc-Receive-GNSS";
            }
        };
        ContextUtil.getContext().registerReceiver((BroadcastReceiver)this.gnssReceiver, intentFilter2);
        LogLocation.i(TAG, "register gnss receiver ");
    }

    private void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        try {
            ContextUtil.getContext().unregisterReceiver(broadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLocation.e(TAG, illegalArgumentException.getMessage());
        }
    }

    static /* synthetic */ boolean access$002(GnssAndNetReceiver gnssAndNetReceiver, boolean bl) {
        gnssAndNetReceiver.isFirstReceive = bl;
        return bl;
    }

    public void registerNetworkObserve() {
        IntentFilter intentFilter;
        AtomicInteger atomicInteger;
        if (this.networkCnt == null) {
            AtomicInteger atomicInteger2;
            atomicInteger = atomicInteger2;
            atomicInteger2 = new AtomicInteger(0);
            this.networkCnt = atomicInteger;
        }
        GnssAndNetReceiver gnssAndNetReceiver = this;
        gnssAndNetReceiver.networkCnt.incrementAndGet();
        LogLocation.d(TAG, "network observe cnt incrementAndGet:" + this.networkCnt.get());
        if (gnssAndNetReceiver.networkReceiver != null) {
            return;
        }
        atomicInteger = intentFilter;
        new IntentFilter().addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.networkReceiver = new SafeBroadcastReceiver(){

            @Override
            public void onSafeReceive(Intent intent) {
                if (TextUtils.equals((CharSequence)new SafeIntent(intent).getAction(), (CharSequence)"android.net.conn.CONNECTIVITY_CHANGE")) {
                    if (GnssAndNetReceiver.this.isFirstReceive) {
                        GnssAndNetReceiver.access$002(GnssAndNetReceiver.this, false);
                        return;
                    }
                    GnssAndNetReceiver.this.notifyListeners();
                }
            }

            @Override
            public String receiveThreadName() {
                return "Loc-Receive-Network";
            }
        };
        ContextUtil.getContext().registerReceiver((BroadcastReceiver)this.networkReceiver, (IntentFilter)atomicInteger);
        LogLocation.i(TAG, "register network receiver");
    }

    public void unRegisterNetworkObserve() {
        AtomicInteger atomicInteger = this.networkCnt;
        if (atomicInteger == null) {
            return;
        }
        if (this.networkReceiver == null) {
            return;
        }
        atomicInteger.decrementAndGet();
        LogLocation.d(TAG, "network observe cnt decrementAndGet:" + this.networkCnt.get());
        if (this.networkCnt.get() <= 0) {
            GnssAndNetReceiver gnssAndNetReceiver = this;
            gnssAndNetReceiver.unregisterReceiver(gnssAndNetReceiver.networkReceiver);
            gnssAndNetReceiver.isFirstReceive = true;
            gnssAndNetReceiver.networkReceiver = null;
            gnssAndNetReceiver.networkCnt = null;
            LogLocation.i(TAG, "unregister network receiver");
        }
    }

    public void unRegisterAllObserve() {
        SafeBroadcastReceiver safeBroadcastReceiver = this.networkReceiver;
        if (safeBroadcastReceiver != null) {
            this.unregisterReceiver(safeBroadcastReceiver);
            this.networkReceiver = null;
            LogLocation.i(TAG, "unregister network receiver");
        }
        if ((safeBroadcastReceiver = this.gnssReceiver) != null) {
            this.unregisterReceiver(safeBroadcastReceiver);
            this.gnssReceiver = null;
            LogLocation.i(TAG, "unregister gnss receiver");
        }
    }

    public abstract void notifyListeners();
}

