/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.android.receiver;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.android.receiver.PackageOperateCallback;
import com.huawei.location.lite.common.android.receiver.SafeBroadcastReceiver;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.secure.android.common.intent.SafeIntent;
import com.huawei.secure.android.common.util.SafeString;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageReceiver
extends SafeBroadcastReceiver {
    private static final String TAG = "PackageReceiver";
    private static final byte[] SYNC_LOCK = new byte[0];
    private static volatile PackageReceiver instance;
    AtomicBoolean isRegisterBr;
    private List<PackageOperateCallback> callbackList;

    public PackageReceiver() {
        CopyOnWriteArrayList copyOnWriteArrayList;
        AtomicBoolean atomicBoolean;
        Object object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.isRegisterBr = object;
        object = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.callbackList = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PackageReceiver getInstance() {
        if (instance != null) return instance;
        byte[] byArray = SYNC_LOCK;
        synchronized (SYNC_LOCK) {
            if (instance != null) return instance;
            instance = new PackageReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private IntentFilter getPackageFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_REPLACED");
        intentFilter.addDataScheme("package");
        return intentFilter;
    }

    public void registerCallback(PackageOperateCallback packageOperateCallback) {
        if (packageOperateCallback != null) {
            packageReceiver3.callbackList.add(packageOperateCallback);
        }
        if (!packageReceiver3.isRegisterBr.get()) {
            PackageReceiver packageReceiver = packageReceiver3;
            PackageReceiver packageReceiver2 = packageReceiver3;
            PackageReceiver packageReceiver3 = PackageReceiver.getInstance();
            ContextUtil.getContext().registerReceiver((BroadcastReceiver)packageReceiver3, packageReceiver2.getPackageFilter());
            packageReceiver.isRegisterBr.set(true);
        }
    }

    public void unregisterCallback(PackageOperateCallback packageOperateCallback) {
        if (packageOperateCallback != null) {
            this.callbackList.remove(packageOperateCallback);
        }
    }

    @Override
    public void onSafeReceive(Intent object) {
        SafeIntent safeIntent;
        if (object == null) {
            LogLocation.e(TAG, "PackageReceiver receive null intent");
            return;
        }
        SafeIntent object22 = safeIntent;
        if (TextUtils.isEmpty((CharSequence)(object = new SafeIntent((Intent)object).getDataString()))) {
            object = "";
        }
        object = SafeString.replace((String)object, (CharSequence)"package:", (CharSequence)"");
        if ("android.intent.action.PACKAGE_REMOVED".equals(object22.getAction())) {
            LogLocation.d(TAG, "package_remove:" + (String)object);
            for (PackageOperateCallback packageOperateCallback : ((PackageReceiver)((Object)this)).callbackList) {
                if (packageOperateCallback == null) continue;
                packageOperateCallback.onRemoved((String)object);
            }
        } else if ("android.intent.action.PACKAGE_ADDED".equals(object22.getAction())) {
            LogLocation.d(TAG, "package_add:" + (String)object);
            for (PackageOperateCallback packageOperateCallback : ((PackageReceiver)((Object)this)).callbackList) {
                if (packageOperateCallback == null) continue;
                packageOperateCallback.onAdded((String)object);
            }
        } else if ("android.intent.action.PACKAGE_REPLACED".equals(object22.getAction())) {
            LogLocation.d(TAG, "package_replace:" + (String)object);
            for (PackageOperateCallback packageOperateCallback : ((PackageReceiver)((Object)this)).callbackList) {
                if (packageOperateCallback == null) continue;
                packageOperateCallback.onReplaced((String)object);
            }
        } else {
            LogLocation.d(TAG, "action ===:" + object22.getAction());
        }
    }

    @Override
    public int threadExitDelayTime() {
        return 0;
    }

    @Override
    public String receiveThreadName() {
        return "Loc_Package_Listener";
    }
}

