/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.android.receiver;

import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.PowerManager;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.android.receiver.SafeBroadcastReceiver;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.secure.android.common.intent.SafeIntent;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ScreenStatusBroadcastReceiver
extends SafeBroadcastReceiver {
    private static final String TAG = "ScreenStatusBroadcastReceiver";
    private static final int SCREEN_OFF_DELAY_MSG = 1005;
    private static final long REPORT_LATENCY_NS_SCREEN_ON = 5000000000L;
    private static final long REPORT_LATENCY_NS_SCREEN_OFF = 200000000000L;
    private static final long CONVERT_RATION_NS = 1000000000L;
    private static final int QUIT_THREAD_DELAY_TIME = 120000;
    private static final String LOCATION_BROADCAST_KIT = "Location_Lite_Broadcast";
    private static long currentReportLatencyNs;
    private static List<ScreenStatusCallback> callbackList;
    private Handler screenOffHandler = null;
    private HandlerThread handlerThread;

    private void postDelayMsg() {
        if (this.handlerThread != null && this.screenOffHandler != null) {
            LogLocation.d(TAG, "screen off remove Messages");
            this.screenOffHandler.removeMessages(1005);
        } else {
            LogLocation.d(TAG, "postDelayMsg new handlerThread");
            this.handlerThread = new HandlerThread(LOCATION_BROADCAST_KIT);
            this.handlerThread.start();
            ScreenStatusBroadcastReceiver screenStatusBroadcastReceiver = this;
            this.screenOffHandler = new Handler(screenStatusBroadcastReceiver.handlerThread.getLooper()){

                public void handleMessage(Message message) {
                    if (message != null && message.what == 1005) {
                        LogLocation.d(ScreenStatusBroadcastReceiver.TAG, "isScreenOn : " + ScreenStatusBroadcastReceiver.isScreenOn());
                        return;
                    }
                    LogLocation.e(ScreenStatusBroadcastReceiver.TAG, "message error");
                }
            };
        }
        LogLocation.d(TAG, "sendEmptyMessageDelayed 5 seconds for screenOff. the result is : " + this.screenOffHandler.sendEmptyMessageDelayed(1005, 5000L));
    }

    public static boolean isScreenOn() {
        boolean bl = false;
        Object object = ContextUtil.getContext().getSystemService("power");
        if (object instanceof PowerManager) {
            bl = ((PowerManager)object).isScreenOn();
        }
        LogLocation.d(TAG, "isCurScreenOn:" + bl);
        return bl;
    }

    private void setCurrentReportLatencyNs(long l) {
        currentReportLatencyNs = l;
    }

    public static long getCurrentReportLatencyNs() {
        long l = currentReportLatencyNs;
        if (l == 0L) {
            l = ScreenStatusBroadcastReceiver.isScreenOn() ? 5000000000L : 200000000000L;
        }
        return l;
    }

    private void onScreenOn() {
        ((ScreenStatusBroadcastReceiver)((Object)iterator)).setCurrentReportLatencyNs(5000000000L);
        LogLocation.d(TAG, "onScreenOn,report latency is:" + currentReportLatencyNs / 1000000000L + "s");
        try {
            Iterator<ScreenStatusCallback> iterator = callbackList.iterator();
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "exec callback onScreenOn exception", true);
        }
        while (true) {
            if (!iterator.hasNext()) break;
            ScreenStatusCallback screenStatusCallback = (ScreenStatusCallback)iterator.next();
            if (screenStatusCallback == null) continue;
            screenStatusCallback.onScreenOn();
            continue;
            break;
        }
    }

    private void onScreenOff() {
        ((ScreenStatusBroadcastReceiver)((Object)iterator)).setCurrentReportLatencyNs(200000000000L);
        LogLocation.d(TAG, "onScreenOff,report latency is:" + currentReportLatencyNs / 1000000000L + "s");
        try {
            Iterator<ScreenStatusCallback> iterator = callbackList.iterator();
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "exec callback onScreenOff exception", true);
        }
        while (true) {
            if (!iterator.hasNext()) break;
            ScreenStatusCallback screenStatusCallback = (ScreenStatusCallback)iterator.next();
            if (screenStatusCallback == null) continue;
            screenStatusCallback.onScreenOff();
            continue;
            break;
        }
    }

    public static synchronized void registerCallback(ScreenStatusCallback screenStatusCallback) {
        if (screenStatusCallback != null && !callbackList.contains(screenStatusCallback)) {
            callbackList.add(screenStatusCallback);
        }
    }

    public static synchronized void unRegisterCallback(ScreenStatusCallback screenStatusCallback) {
        if (screenStatusCallback != null) {
            callbackList.remove(screenStatusCallback);
        }
    }

    static {
        callbackList = new CopyOnWriteArrayList<ScreenStatusCallback>();
    }

    @Override
    public void onSafeReceive(Intent intent) {
        SafeIntent safeIntent;
        SafeIntent safeIntent2 = safeIntent;
        safeIntent = new SafeIntent(intent);
        LogLocation.d(TAG, "onReceive action : " + safeIntent2.getAction());
        if ("android.intent.action.SCREEN_OFF".equals(safeIntent.getAction())) {
            ScreenStatusBroadcastReceiver screenStatusBroadcastReceiver = this;
            screenStatusBroadcastReceiver.onScreenOff();
            screenStatusBroadcastReceiver.postDelayMsg();
        }
        if ("android.intent.action.SCREEN_ON".equals(safeIntent2.getAction())) {
            ScreenStatusBroadcastReceiver screenStatusBroadcastReceiver = this;
            screenStatusBroadcastReceiver.onScreenOn();
            intent = screenStatusBroadcastReceiver.screenOffHandler;
            if (intent != null && intent.hasMessages(1005)) {
                LogLocation.d(TAG, "screen on remove Messages");
                this.screenOffHandler.removeMessages(1005);
            }
        }
    }

    @Override
    public int threadExitDelayTime() {
        return 120000;
    }

    @Override
    public String receiveThreadName() {
        return "Loc-Screen-Receive";
    }

    public static interface ScreenStatusCallback {
        public void onScreenOn();

        public void onScreenOff();
    }
}

