/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.android.service;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;

public abstract class SafeService
extends Service {
    private static final int QUIT_THREAD_MSG = 101;
    private static final int QUIT_THREAD_DELAY_TIME = 0;
    private static final String DEFAULT_SERVICE_THREAD_NAME = "Loc-Safe-Service";
    private volatile Looper mServiceLooper;
    private volatile ServiceHandler mServiceHandler;
    private boolean mRedelivery;

    private void quitLooper() {
        if (this.mServiceLooper != null) {
            this.mServiceLooper.quitSafely();
            this.mServiceLooper = null;
        }
    }

    public void setIntentRedelivery(boolean bl) {
        this.mRedelivery = bl;
    }

    public void onCreate() {
        HandlerThread handlerThread;
        SafeService safeService = this;
        super.onCreate();
        String string = !TextUtils.isEmpty((CharSequence)safeService.serviceThreadName()) ? this.serviceThreadName() : DEFAULT_SERVICE_THREAD_NAME;
        SafeService safeService2 = this;
        HandlerThread handlerThread2 = handlerThread;
        handlerThread2(string);
        handlerThread2.start();
        safeService2.mServiceLooper = handlerThread2.getLooper();
        SafeService safeService3 = this;
        safeService2.mServiceHandler = safeService3.new ServiceHandler(safeService3.mServiceLooper);
    }

    public void onStart(Intent intent, int n) {
        if (safeService2.isOpenNewThread() && safeService2.mServiceHandler != null) {
            SafeService safeService = safeService2;
            SafeService safeService2 = safeService.mServiceHandler.obtainMessage();
            ((Message)safeService2).arg1 = n;
            safeService.mServiceHandler.obtainMessage().obj = intent;
            safeService.mServiceHandler.sendMessage((Message)safeService2);
        } else {
            super.onStart(intent, n);
        }
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        if (this.isOpenNewThread()) {
            this.onStart(intent, n2);
        } else {
            this.onHandleIntent(intent);
        }
        return this.mRedelivery ? 3 : 2;
    }

    public void onDestroy() {
        if (this.mServiceHandler != null) {
            this.mServiceHandler.removeMessages(101);
            this.mServiceHandler = null;
        }
        this.quitLooper();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected abstract void onHandleIntent(Intent var1);

    protected int threadExitDelayTime() {
        return 0;
    }

    protected String serviceThreadName() {
        return DEFAULT_SERVICE_THREAD_NAME;
    }

    protected boolean isOpenNewThread() {
        return true;
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (message.what != 101) {
                ServiceHandler serviceHandler = this;
                serviceHandler.SafeService.this.onHandleIntent((Intent)message.obj);
                serviceHandler.removeMessages(101);
                int n = 101;
                long l = serviceHandler.SafeService.this.threadExitDelayTime() > 0 ? (long)SafeService.this.threadExitDelayTime() : 0L;
                this.sendEmptyMessageDelayed(n, l);
            } else {
                SafeService.this.quitLooper();
            }
        }
    }
}

