/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.chain;

import androidx.annotation.NonNull;
import com.huawei.location.lite.common.chain.Data;

public abstract class Result {
    protected Data outputData;

    @NonNull
    public static Result success() {
        return new Success();
    }

    @NonNull
    public static Result success(@NonNull Data data) {
        return new Success(data);
    }

    @NonNull
    public static Result retry() {
        return new Retry();
    }

    @NonNull
    public static Result failure() {
        return new Failure();
    }

    @NonNull
    public static Result failure(@NonNull Data data) {
        return new Failure(data);
    }

    Result() {
    }

    public Data getOutputData() {
        return this.outputData;
    }

    public static final class Retry
    extends Result {
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object != null && Retry.class == object.getClass();
        }

        public int hashCode() {
            return 429412720;
        }

        public String toString() {
            return "Retry";
        }
    }

    public static final class Failure
    extends Result {
        public Failure() {
            this(Data.EMPTY);
        }

        public Failure(@NonNull Data data) {
            this.outputData = data;
        }

        public boolean equals(Object object) {
            if (failure2 == object) {
                return true;
            }
            if (object != null && Failure.class == object.getClass()) {
                if (object instanceof Failure) {
                    Failure failure = failure2;
                    Failure failure2 = (Failure)object;
                    return failure.outputData.equals(failure2.outputData);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            return -1087636498 + this.outputData.hashCode();
        }

        public String toString() {
            return "Failure {outputData=" + this.outputData + '}';
        }
    }

    public static final class Success
    extends Result {
        public Success() {
            this(Data.EMPTY);
        }

        public Success(@NonNull Data data) {
            this.outputData = data;
        }

        public boolean equals(Object object) {
            if (success2 == object) {
                return true;
            }
            if (object != null && Success.class == object.getClass()) {
                if (object instanceof Success) {
                    Success success = success2;
                    Success success2 = (Success)object;
                    return success.outputData.equals(success2.outputData);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            return 483703957 + this.outputData.hashCode();
        }

        public String toString() {
            return "Success {outputData=" + this.outputData + '}';
        }
    }
}

