/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.chain;

import com.huawei.location.lite.common.chain.Result;
import com.huawei.location.lite.common.chain.Task;
import com.huawei.location.lite.common.chain.TaskRequest;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.List;

public class TaskChain
implements Task.Chain {
    private static final String TAG = "TaskChain";
    private List<Task> taskList;
    private int index = -1;
    private TaskRequest request;

    public TaskChain(List<Task> list, TaskRequest taskRequest) {
        this.taskList = list;
        this.request = taskRequest;
    }

    @Override
    public TaskRequest getRequest() {
        return this.request;
    }

    @Override
    public int proceed() {
        Result result = this.request.getResult();
        if (result instanceof Result.Failure) {
            return 101;
        }
        if (result instanceof Result.Retry) {
            return 102;
        }
        if (this.index == this.taskList.size() - 1) {
            return 100;
        }
        return 103;
    }

    @Override
    public Result runTask(boolean bl) {
        if (!bl) {
            ++this.index;
        }
        TaskChain taskChain = this;
        taskChain.taskList.get(this.index).runTask(this);
        LogLocation.i(TAG, "tasks tid:" + this.getRequest().getTransId());
        return taskChain.getRequest().getResult();
    }
}

