/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.chain;

import com.huawei.location.lite.common.chain.Data;
import com.huawei.location.lite.common.chain.Task;
import com.huawei.location.lite.common.chain.TaskChain;
import com.huawei.location.lite.common.chain.TaskFinishCallBack;
import com.huawei.location.lite.common.chain.TaskRequest;
import com.huawei.location.lite.common.chain.TaskTimeOutException;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TaskClient
implements TaskFinishCallBack {
    private static final String TAG = "TaskChain";
    private List<Task> tasks;
    private TaskRequest taskRequest;
    private TaskFinishCallBack taskFinishCallBack;
    private Data outData;
    private boolean isSuccess;
    private CountDownLatch countDownLatch;

    private TaskClient(Builder object) {
        this.tasks = Collections.unmodifiableList(((Builder)object).tasks);
        object = ((Builder)object).taskRequest;
        this.taskRequest = object;
        this.taskFinishCallBack = ((TaskRequest)object).getTaskFinishCallBack();
        this.taskRequest.setTaskFinishCallBack(this);
        this.countDownLatch = new CountDownLatch(1);
    }

    private void execute() throws TaskTimeOutException {
        TaskClient taskClient = this;
        taskClient.enqueue();
        if (taskClient.isSuccess) {
            this.taskFinishCallBack.onSuccess(this.outData);
        } else {
            this.taskFinishCallBack.onFail(this.outData);
        }
    }

    private void enqueue() throws TaskTimeOutException {
        block7: {
            List<Task> list;
            TaskClient taskClient;
            TaskChain taskChain;
            TaskChain taskChain2;
            try {
                TaskChain taskChain3;
                LogLocation.i(TAG, "tasks is start,tid:" + this.taskRequest.getTransId());
                taskChain2 = taskChain3;
                taskChain = taskChain3;
                TaskClient taskClient2 = this;
                taskClient = taskClient2;
                list = taskClient2.tasks;
            }
            catch (InterruptedException interruptedException) {
                throw new TaskTimeOutException("task interrupted");
            }
            taskChain2(list, taskClient.taskRequest);
            taskChain.runTask(false);
            CountDownLatch countDownLatch = this.countDownLatch;
            long l = this.taskRequest.getMaxTimeOut();
            if (!countDownLatch.await(l, TimeUnit.MILLISECONDS)) break block7;
            LogLocation.i(TAG, "tasks is success,tid:" + this.taskRequest.getTransId());
            return;
        }
        LogLocation.w(TAG, "tasks is timeOut,tid:" + this.taskRequest.getTransId());
        this.taskRequest.setIsTimeOut(true);
        throw new TaskTimeOutException("task timeout");
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public TaskRequest getTaskRequest() {
        return this.taskRequest;
    }

    public void setTaskRequest(TaskRequest taskRequest) {
        this.taskRequest = taskRequest;
    }

    @Override
    public void onFail(Data data) {
        this.outData = data;
        this.isSuccess = false;
        if (this.taskRequest.isAsync()) {
            this.taskFinishCallBack.onFail(data);
        }
        this.countDownLatch.countDown();
    }

    @Override
    public void onSuccess(Data data) {
        this.outData = data;
        this.isSuccess = true;
        if (this.taskRequest.isAsync()) {
            this.taskFinishCallBack.onSuccess(data);
        }
        this.countDownLatch.countDown();
    }

    public void runTasks() throws TaskTimeOutException {
        if (this.tasks.isEmpty()) {
            return;
        }
        if (this.taskRequest.isAsync()) {
            this.enqueue();
        } else {
            this.execute();
        }
    }

    public static final class Builder {
        private List<Task> tasks;
        private TaskRequest taskRequest;

        public Builder() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.tasks = arrayList2;
        }

        public Builder addTask(Task task) {
            if (task != null) {
                if (this.tasks == null) {
                    ArrayList<Task> arrayList;
                    ArrayList<Task> arrayList2 = arrayList;
                    arrayList = new ArrayList<Task>();
                    this.tasks = arrayList2;
                }
                Builder builder = this;
                builder.tasks.add(task);
                return builder;
            }
            throw new IllegalArgumentException("task == null");
        }

        public Builder withTaskRequest(TaskRequest taskRequest) {
            this.taskRequest = taskRequest;
            return this;
        }

        public TaskClient build() {
            return new TaskClient(this);
        }
    }
}

