/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.chain;

import com.huawei.location.lite.common.chain.Data;
import com.huawei.location.lite.common.chain.Result;
import com.huawei.location.lite.common.chain.Task;
import com.huawei.location.lite.common.chain.TaskFinishCallBack;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.UUID;

public class TaskRequest {
    private Data data;
    private Result result;
    private TaskFinishCallBack taskFinishCallBack;
    private int maxTimeOut = 120000;
    private boolean isAsync = false;
    private boolean isTimeOut = false;
    private String transId = UUID.randomUUID().toString();

    public String getTransId() {
        return this.transId;
    }

    public void setInputData(Data data) {
        this.data = data;
    }

    public Data getInputData() {
        return this.data;
    }

    public void setMaxTimeOut(int n) {
        this.maxTimeOut = n;
    }

    public Data getOutputData() {
        Result result = this.result;
        if (result instanceof Result.Success) {
            return ((Result.Success)result).getOutputData();
        }
        if (result instanceof Result.Failure) {
            return ((Result.Failure)result).getOutputData();
        }
        return this.data;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result, Task.Chain chain) {
        this.result = result;
        if (!this.isTimeOut && this.taskFinishCallBack != null) {
            switch (chain.proceed()) {
                default: {
                    this.taskFinishCallBack.onFail(Result.failure().getOutputData());
                    break;
                }
                case 103: {
                    chain.runTask(false);
                    break;
                }
                case 102: {
                    chain.runTask(true);
                    break;
                }
                case 101: {
                    this.taskFinishCallBack.onFail(result.getOutputData());
                    break;
                }
                case 100: {
                    this.taskFinishCallBack.onSuccess(result.getOutputData());
                    break;
                }
            }
        } else {
            LogLocation.w("TaskRequest", "request is time out,tid:" + this.transId);
        }
    }

    public void setTaskFinishCallBack(TaskFinishCallBack taskFinishCallBack) {
        this.taskFinishCallBack = taskFinishCallBack;
    }

    public TaskFinishCallBack getTaskFinishCallBack() {
        return this.taskFinishCallBack;
    }

    public int getMaxTimeOut() {
        return this.maxTimeOut;
    }

    public void setIsTimeOut(boolean bl) {
        this.isTimeOut = bl;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean bl) {
        this.isAsync = bl;
    }
}

