/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.config;

import android.text.TextUtils;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.huawei.location.lite.common.config.ConfigBaseResponse;
import com.huawei.location.lite.common.config.ConfigResponseData;
import com.huawei.location.lite.common.config.ConfigResponseItem;
import com.huawei.location.lite.common.http.HttpClientEx;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.exception.OnFailureException;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.http.request.HeadBuilder;
import com.huawei.location.lite.common.http.request.RequestJsonBody;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.security.LocationSecurityManager;
import com.huawei.location.lite.common.util.ExecutorUtil;
import com.huawei.location.lite.common.util.GsonUtil;
import com.huawei.location.lite.common.util.PreferencesHelper;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigManager {
    private static final String TAG = "ConfigManager";
    private static final String SP_NAME = "com.huawei.hms.location.config";
    private static final String GROUP_NAME = "groupName";
    private static final String GROUP_NAME_LITE_SDK = "liteSDK";
    private static final String KEY_CACHE_TIME = "KEY_CACHE_TIME";
    private static final String KEY_CONFIG_DATA = "KEY_CONFIG_DATA";
    private static final String CONFIG_URL = "/networklocation/v1/configurations";
    private static final String SECURITY_PARAMS = "LOCATION_LITE_SDK";
    public static final long EXPIRED_TIME = 86400000L;
    public static final long MAX_REQUEST_FAILED_INTERVAL = 3600000L;
    public static final int MAX_REQUEST_COUNT = 3;
    private AtomicInteger requestFailedCount;
    private long firstRequestFailedTime;
    private HashMap<String, String> configCache;

    public static ConfigManager getInstance() {
        return Vw.yn;
    }

    private ConfigManager() {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2 = atomicInteger;
        atomicInteger = new AtomicInteger(0);
        v1.requestFailedCount = atomicInteger2;
    }

    private void checkConfigData() {
        PreferencesHelper preferencesHelper;
        PreferencesHelper preferencesHelper2 = preferencesHelper;
        if (this.checkCacheExpired(new PreferencesHelper(SP_NAME))) {
            this.configCache = null;
            this.requestConfigSync();
        } else {
            ConfigManager configManager = this;
            configManager.loadConfigCache(preferencesHelper2);
            if (configManager.configCache == null) {
                LogLocation.e(TAG, "load cache config fail ,reload config from network");
                this.requestConfigSync();
            }
        }
    }

    private void loadConfigCache(PreferencesHelper object) {
        if (((ConfigManager)((Object)type)).configCache != null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)(object = ((PreferencesHelper)object).getString(KEY_CONFIG_DATA)))) {
            LogLocation.e(TAG, "load cache config empty");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)(object = new LocationSecurityManager(3).decrypt((String)object, SECURITY_PARAMS)))) {
            LogLocation.e(TAG, "load config decrypt failed");
            return;
        }
        ConfigManager configManager = type;
        Type type = new TypeToken<HashMap<String, String>>((ConfigManager)((Object)type)){}.getType();
        try {
            configManager.configCache = (HashMap)GsonUtil.getInstance().fromJson((String)object, type);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            LogLocation.e(TAG, "load config jsonSyntax failed");
        }
    }

    private void jsonArray2Map(String object) throws JSONException {
        HashMap hashMap;
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray((String)object);
        object = hashMap;
        hashMap = new HashMap();
        this.configCache = object;
        for (int i = 0; i < jSONArray2.length(); ++i) {
            Object object2 = (ConfigResponseItem)GsonUtil.getInstance().fromJson(jSONArray2.getString(i), ConfigResponseItem.class);
            HashMap<String, String> hashMap2 = this.configCache;
            ConfigResponseItem configResponseItem = object2;
            ConfigResponseItem configResponseItem2 = configResponseItem;
            object2 = configResponseItem.getItemName();
            try {
                hashMap2.put((String)object2, configResponseItem2.getItemValue());
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                LogLocation.e(TAG, "jsonArray2Map failed");
            }
            continue;
        }
    }

    private String requestConfig() {
        FutureTask<String> futureTask;
        FutureTask<String> futureTask2 = futureTask;
        futureTask = new FutureTask<String>(() -> {
            HeadBuilder headBuilder;
            RequestJsonBody.Builder builder = new RequestJsonBody.Builder().add(GROUP_NAME, GROUP_NAME_LITE_SDK);
            Object object = headBuilder;
            headBuilder = new HeadBuilder(String.valueOf(UUID.randomUUID()));
            object = new BaseRequest.Builder(CONFIG_URL).setHeads((HeadBuilder)object).setBody(builder.build());
            try {
                return GsonUtil.getInstance().toJson(new HttpClientEx().newSubmit(((BaseRequest.Builder)object).build()).execute(ConfigResponseData.class).getData());
            }
            catch (OnFailureException onFailureException) {
                LogLocation.e(TAG, "OnFailureException:" + onFailureException.getErrorCode().code + "," + onFailureException.getErrorCode().msg);
            }
            catch (OnErrorException onErrorException) {
                LogLocation.e(TAG, "OnErrorException:code:" + onErrorException.getErrorCode().code + ",apiCode:" + onErrorException.getApiCode() + ",apiMsg:" + onErrorException.getApiMsg());
            }
            return null;
        });
        ExecutorUtil.getInstance().execute(futureTask2);
        try {
            return futureTask.get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            futureTask2.cancel(true);
            LogLocation.e(TAG, "task get response failed by timeOut");
            return null;
        }
        catch (InterruptedException interruptedException) {
            LogLocation.e(TAG, "task get response failed by interrupt");
            return null;
        }
        catch (ExecutionException executionException) {
            LogLocation.e(TAG, "task get response failed by execution");
            return null;
        }
    }

    private void save2Storage(String string) {
        String string2 = new LocationSecurityManager(3).encrypt(string, SECURITY_PARAMS);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            LogLocation.e(TAG, "save config to storage fail");
            return;
        }
        PreferencesHelper preferencesHelper = new PreferencesHelper(SP_NAME);
        preferencesHelper.saveString(KEY_CONFIG_DATA, string2);
        long l = System.currentTimeMillis();
        preferencesHelper.saveLong(KEY_CACHE_TIME, l);
        LogLocation.i(TAG, "save config to storage end");
    }

    private boolean checkCacheExpired(PreferencesHelper preferencesHelper) {
        long l = preferencesHelper.getLong(KEY_CACHE_TIME);
        return l == -1L || System.currentTimeMillis() > l + 86400000L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void requestConfigSync() {
        String string;
        LogLocation.d(TAG, "requestConfigSync start");
        if (System.currentTimeMillis() - this.firstRequestFailedTime < 3600000L && this.requestFailedCount.get() >= 3) {
            LogLocation.d(TAG, "requestConfigSync failed max count");
            return;
        }
        if (this.requestFailedCount.get() == 3) {
            this.requestFailedCount.set(0);
        }
        if (this.configCache != null) {
            LogLocation.e(TAG, "configCache is init");
            return;
        }
        try {
            string = this.requestConfig();
        }
        catch (JSONException jSONException) {
            ConfigManager configManager = this;
            LogLocation.e(TAG, "JSONException");
            configManager.requestFailedCount.incrementAndGet();
            if (configManager.firstRequestFailedTime != 0L) return;
            this.firstRequestFailedTime = System.currentTimeMillis();
            return;
        }
        {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                ConfigManager configManager = this;
                configManager.jsonArray2Map(string);
                configManager.save2Storage(GsonUtil.getInstance().toJson(this.configCache));
                configManager.requestFailedCount.set(0);
                configManager.firstRequestFailedTime = 0L;
                return;
            }
            if (this.requestFailedCount.incrementAndGet() != 1) return;
            this.firstRequestFailedTime = System.currentTimeMillis();
            return;
        }
    }

    public synchronized <T extends ConfigBaseResponse> T updateAndGetConfig(String string, Class<T> clazz) {
        this.configCache = null;
        this.requestConfigSync();
        return this.getConfig(string, clazz);
    }

    public synchronized <T extends ConfigBaseResponse> T getConfig(String string, Class<T> clazz) {
        ConfigManager configManager = object;
        LogLocation.i(TAG, Thread.currentThread().getName() + ",request itemName:" + string);
        configManager.checkConfigData();
        Object object = configManager.configCache;
        if (object == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)(object = (String)((HashMap)object).get(string)))) {
            return null;
        }
        try {
            return (T)((ConfigBaseResponse)GsonUtil.getInstance().fromJson((String)object, clazz));
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            LogLocation.e(TAG, "getConfig failed");
            return null;
        }
    }

    public synchronized String updateAndGetConfig(String string) {
        this.configCache = null;
        this.requestConfigSync();
        return this.getConfig(string);
    }

    public synchronized String getConfig(String string) {
        ConfigManager configManager = hashMap;
        LogLocation.i(TAG, Thread.currentThread().getName() + ",request itemName:" + string);
        configManager.checkConfigData();
        HashMap<String, String> hashMap = configManager.configCache;
        if (hashMap == null) {
            return null;
        }
        return (String)hashMap.get(string);
    }

    public synchronized String getConfig(String string, String string2) {
        ConfigManager configManager = object;
        configManager.checkConfigData();
        Object object = configManager.configCache;
        if (object == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)(object = (String)((HashMap)object).get(string)))) {
            return null;
        }
        string = null;
        try {
            string = String.valueOf(new JSONObject((String)object).get(string2));
        }
        catch (JSONException jSONException) {
            LogLocation.e(TAG, "json parse failed");
        }
        LogLocation.d(TAG, "key=" + string2 + ",value=" + string);
        return string;
    }

    private static class Vw {
        private static final ConfigManager yn = new ConfigManager();
    }
}

