/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.grs;

import android.text.TextUtils;
import com.huawei.hms.commonkit.config.Config;
import com.huawei.hms.framework.network.grs.GrsBaseInfo;
import com.huawei.hms.framework.network.grs.GrsClient;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.DeviceInfoUtil;
import com.huawei.location.lite.common.util.SDKComponentType;
import com.huawei.location.lite.common.util.TelephonyUtil;
import com.huawei.location.lite.common.util.country.CountryCodeUtil;
import com.huawei.location.lite.common.util.country.CountryConfig;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LocationNlpGrsHelper {
    private static final String TAG = "LocationNlpGrsHelper";
    private static final String NAMESPACE = "GRS";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String DEFAULT_DR2_COUNTRY_CODE = "SG";
    private static final int LATCH_AWAIT_TIMEOUT = 5;

    public static String getGrsHostAddress(String string) {
        return LocationNlpGrsHelper.getGrsHostAddress(CountryCodeUtil.getLocationCountryCode(), string, "ROOT");
    }

    public static String getGrsHostAddress(String string, String string2) {
        return LocationNlpGrsHelper.getGrsHostAddress(string, string2, "ROOT");
    }

    public static String getGrsHostAddress(String string, String string2, String string3) {
        String string4 = null;
        FutureTask<String> futureTask = new FutureTask<String>(() -> {
            String string3 = string2;
            string3.hashCode();
            int n = -1;
            switch (string3.hashCode()) {
                default: {
                    break;
                }
                case 1753801149: {
                    if (!string2.equals("com.huawei.hms.oobe")) break;
                    n = 6;
                    break;
                }
                case 980023935: {
                    if (!string2.equals("AGREEMENTROUTE")) break;
                    n = 5;
                    break;
                }
                case 979105389: {
                    if (!string2.equals("MAPROUTE")) break;
                    n = 4;
                    break;
                }
                case 514974498: {
                    if (!string2.equals("LOGSERVERROUTE")) break;
                    n = 3;
                    break;
                }
                case 394921051: {
                    if (!string2.equals("HIANALYTICROUTE")) break;
                    n = 2;
                    break;
                }
                case -1725663847: {
                    if (!string2.equals("HIGEOROUTE")) break;
                    n = 1;
                    break;
                }
                case -2024253630: {
                    if (!string2.equals("SITEROUTE")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    string = LocationNlpGrsHelper.getGrsHost(string, string2, string3);
                    break;
                }
                case 6: {
                    Object[] objectArray = new Object[2];
                    string = objectArray;
                    objectArray[0] = string2;
                    objectArray[1] = "ROOT";
                    string = Config.getString((String)NAMESPACE, (String)String.format(Locale.ENGLISH, "grs://%s/%s", string));
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = LocationNlpGrsHelper.getGrsHost(string, "com.huawei.location.extService", string2);
                    break;
                }
                case 0: 
                case 1: {
                    string = LocationNlpGrsHelper.getGrsHost(string, "com.huawei.hms.location", string2);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            if (string2.equals("LOGSERVERROUTE") && DeviceInfoUtil.getDeviceFeature(ContextUtil.getContext()) == 8) {
                LogLocation.d(TAG, "host is null,device is car, getMcc()");
                if ("460".equals(TelephonyUtil.getMcc())) {
                    string = LocationNlpGrsHelper.getGrsHost("CN", "com.huawei.location.extService", string2);
                }
            }
            return string;
        });
        futureTask.run();
        try {
            string4 = futureTask.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            LogLocation.e(TAG, "getGrsHostAddress future timeOut error");
        }
        catch (ExecutionException executionException) {
            LogLocation.e(TAG, "getGrsHostAddress future exec error");
        }
        catch (InterruptedException interruptedException) {
            LogLocation.e(TAG, "getGrsHostAddress future interr error");
        }
        LogLocation.d(TAG, "getGrsHostAddress finally serviceName:" + string2 + ", host:" + string4);
        return string4;
    }

    private static String getGrsHost(String string, String string2, String string3) {
        String string4 = LocationNlpGrsHelper.getGrsHostRel(string, string2, string3);
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            return string4;
        }
        return LocationNlpGrsHelper.finallyRetry(string, string2, string3);
    }

    private static String finallyRetry(String string, String string2, String string3) {
        if (CountryConfig.isDRCountry(string)) {
            return null;
        }
        if (TextUtils.equals((CharSequence)string2, (CharSequence)"com.huawei.hms.location")) {
            return LocationNlpGrsHelper.getGrsHostRel(DEFAULT_DR2_COUNTRY_CODE, string2, string3);
        }
        if (!TextUtils.equals((CharSequence)UNKNOWN, (CharSequence)string) && (TextUtils.equals((CharSequence)string3, (CharSequence)"LOGSERVERROUTE") || TextUtils.equals((CharSequence)string2, (CharSequence)"LOGSERVERROUTE"))) {
            return LocationNlpGrsHelper.getGrsHostRel(DEFAULT_DR2_COUNTRY_CODE, string2, string3);
        }
        if (TextUtils.equals((CharSequence)string2, (CharSequence)"com.huawei.tsms") && SDKComponentType.getComponentType() == 100) {
            return LocationNlpGrsHelper.getGrsHostRel(DEFAULT_DR2_COUNTRY_CODE, string2, string3);
        }
        return null;
    }

    private static String getGrsHostRel(String string, String string2, String string3) {
        Object object;
        if (SDKComponentType.getComponentType() == 100) {
            Object[] objectArray;
            object = objectArray;
            objectArray = new GrsBaseInfo();
            if (!TextUtils.equals((CharSequence)string2, (CharSequence)"SITEROUTE") && !TextUtils.equals((CharSequence)string2, (CharSequence)"HIANALYTICROUTE")) {
                object.setSerCountry(string.toUpperCase(Locale.ROOT));
            } else {
                object.setIssueCountry(string.toUpperCase(Locale.ROOT));
            }
            object = new GrsClient(ContextUtil.getContext(), (GrsBaseInfo)object).synGetGrsUrl(string2, string3);
        } else {
            Object[] objectArray = new Object[3];
            object = objectArray;
            objectArray[0] = string2;
            objectArray[1] = string3;
            objectArray[2] = string;
            object = Config.getString((String)NAMESPACE, (String)String.format(Locale.ENGLISH, "grs://%s/%s?serCountry=%s", object));
        }
        LogLocation.i(TAG, "getGrsHostAddress serviceName:" + string2 + ", host:" + (String)object + ", addressesKey:" + string3 + ", countryCode:" + string);
        return object;
    }

    public static String getLocationIPAddress() {
        return LocationNlpGrsHelper.getGrsHostRel(UNKNOWN, "com.huawei.hms.location", "ROOT");
    }
}

