/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http;

import android.annotation.SuppressLint;
import android.content.Context;
import com.huawei.location.lite.common.http.OkRequestTask;
import com.huawei.location.lite.common.http.adapter.HttpClientAdapter;
import com.huawei.location.lite.common.http.adapter.HttpClientBuilder;
import com.huawei.location.lite.common.http.adapter.IHttpSDKRequestTask;
import com.huawei.location.lite.common.http.adapter.InterceptorAdapter;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.interceptor.AGCInterceptor;
import com.huawei.location.lite.common.http.interceptor.CommonInterceptor;
import com.huawei.location.lite.common.http.interceptor.UcsAuthInterceptor;
import com.huawei.location.lite.common.log.LogLocation;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

@SuppressLint(value={"CheckResult"})
public class HttpClientReal
extends HttpClientAdapter {
    private static final ConnectionPool CONNECTION_POOL;
    private OkHttpClient httpClient;

    public HttpClientReal(HttpClientBuilder httpClientBuilder, Context context) {
        super(httpClientBuilder, context);
    }

    static {
        int n = HttpClientAdapter.MAX_CONNECT_SIZE;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        CONNECTION_POOL = new ConnectionPool(n, 30000L, timeUnit);
    }

    @Override
    protected void initHttpClient() {
        X509TrustManager x509TrustManager;
        Object object;
        int n;
        int n2;
        TimeUnit timeUnit;
        LogLocation.d("HttpClientReal", "OkHttpClient init...");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(CONNECTION_POOL).retryOnConnectionFailure(false).protocols(Collections.unmodifiableList(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1)));
        int n3 = this.pingInterval;
        if (n3 > 0) {
            long l = n3;
            timeUnit = TimeUnit.MILLISECONDS;
            builder.pingInterval(l, timeUnit);
        }
        if ((n3 = this.readTimeout) > 0) {
            long l = n3;
            timeUnit = TimeUnit.MILLISECONDS;
            builder.readTimeout(l, timeUnit);
        }
        if ((n2 = this.writeTimeout) > 0) {
            long l = n2;
            timeUnit = TimeUnit.MILLISECONDS;
            builder.writeTimeout(l, timeUnit);
        }
        if ((n = this.connectTimeout) > 0) {
            long l = n;
            timeUnit = TimeUnit.MILLISECONDS;
            builder.connectTimeout(l, timeUnit);
        }
        if ((object = this.proxy) != null) {
            builder.proxy((Proxy)object);
        }
        if ((object = this.hostnameVerifier) != null) {
            builder.hostnameVerifier((HostnameVerifier)object);
        }
        if ((object = this.sslSocketFactory) != null && (x509TrustManager = this.x509TrustManager) != null) {
            builder.sslSocketFactory((SSLSocketFactory)object, x509TrustManager);
        }
        this.httpClient = builder.build();
    }

    @Override
    protected void addCustomInterceptors() {
        HttpClientReal httpClientReal = this;
        httpClientReal.interceptors.add(new CommonInterceptor());
        if (httpClientReal.isNeedCheckUcsAuth) {
            this.interceptors.add(new UcsAuthInterceptor());
        }
        if (this.isNeedCheckAGC) {
            this.interceptors.add(new AGCInterceptor());
        }
    }

    @Override
    public IHttpSDKRequestTask newRequestTask() throws OnErrorException {
        return new OkRequestTask(this.httpClient);
    }

    @Override
    public List<InterceptorAdapter> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void evictAllConnections() {
        if (this.httpClient != null) {
            CONNECTION_POOL.evictAll();
            this.httpClient = null;
        }
    }
}

