/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http;

import androidx.annotation.NonNull;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpExecutorUtil {
    private static final String LOCATION_POOL_PREFIX_DEFAULT = "Loc-Http-Pool";
    private static final int THREAD_CORE = 10;
    private static final int THREAD_MAX = 100;
    private static final long KEEP_ALIVE_TIME = 60L;
    private final ThreadPoolExecutor executor;

    public static HttpExecutorUtil getInstance() {
        return HttpExecutorUtilHolder.INSTANCE;
    }

    private HttpExecutorUtil() {
        NamedThreadFactory namedThreadFactory;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
        HttpExecutorUtil httpExecutorUtil = object;
        Object object = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        NamedThreadFactory namedThreadFactory2 = namedThreadFactory;
        namedThreadFactory = new NamedThreadFactory(LOCATION_POOL_PREFIX_DEFAULT);
        threadPoolExecutor2(10, 100, 60L, (TimeUnit)((Object)object), linkedBlockingQueue2, namedThreadFactory2);
        httpExecutorUtil.executor = threadPoolExecutor2;
        threadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void execute(Runnable runnable) {
        try {
            this.getExecutor().execute(runnable);
        }
        catch (Throwable throwable) {
            LogLocation.e("ExecutorUtil", "ExecutorUtil fatal error", true);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger counter;
        private final String poolName;

        NamedThreadFactory(String string) {
            AtomicInteger atomicInteger;
            AtomicInteger atomicInteger2 = atomicInteger;
            atomicInteger = new AtomicInteger(1);
            v1.counter = atomicInteger2;
            v1.poolName = string;
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            return new Thread(runnable, this.poolName + "-" + this.counter.getAndIncrement());
        }
    }

    private static class HttpExecutorUtilHolder {
        private static final HttpExecutorUtil INSTANCE = new HttpExecutorUtil();

        private HttpExecutorUtilHolder() {
        }
    }
}

