/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.plug.PluginManager;
import com.huawei.location.lite.common.plug.PluginReqMessage;
import com.huawei.location.lite.common.report.ReportBuilder;
import com.huawei.location.lite.common.report.Tracker;
import com.huawei.location.lite.common.util.GsonUtil;
import com.huawei.location.lite.common.util.SDKComponentType;
import com.huawei.location.lite.common.util.StringUtil;

public class HttpReportHelper {
    private static final String TAG = "HttpReportHelper";
    private static final String LOCATION_SERVER_API = "Location_serverApi";
    private static final int MAX_PATH_LENGTH = 60;
    public static final String ONLINE_LOCATION_URL = "/networklocation/v1/onlineLocation";
    private static final String HTTP_SDK_COST_TIME = "httpSdkCostTime";
    public static final String HTTP_NEED_REPORT = "NeedReport";
    private ReportBuilder reportBuilder;

    public HttpReportHelper(ReportBuilder reportBuilder) {
        HttpReportHelper httpReportHelper = this;
        httpReportHelper.reportBuilder = reportBuilder;
        httpReportHelper.initReport();
    }

    private void initReport() {
        if (this.reportBuilder == null) {
            ReportBuilder reportBuilder;
            ReportBuilder reportBuilder2 = reportBuilder;
            reportBuilder = new ReportBuilder();
            this.reportBuilder = reportBuilder2;
        }
        this.reportBuilder.setCallTime();
    }

    private void addExt(BaseRequest object, String string) {
        if (TextUtils.equals((CharSequence)((BaseRequest)object).getPath(), (CharSequence)ONLINE_LOCATION_URL) && !TextUtils.equals((CharSequence)string, (CharSequence)String.valueOf(200)) && !TextUtils.isEmpty((CharSequence)(object = ((BaseRequest)object).getHeads().get("X-CP-Info")))) {
            this.reportBuilder.setExtParam("X-CP-Info", (String)object);
        }
    }

    private String url2Dr(String string) {
        ArrayMap arrayMap;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "UNKNOWN";
        }
        HttpReportHelper httpReportHelper = arrayMap;
        new ArrayMap().put((Object)"-drcn", (Object)"DR1");
        httpReportHelper.put("locationtest.", "DR1");
        httpReportHelper.put("-dra", "DR2");
        httpReportHelper.put("locationtestSingapore.", "DR2");
        httpReportHelper.put("-dre", "DR3");
        httpReportHelper.put("locationtestEurope.", "DR3");
        httpReportHelper.put("-drru", "DR4");
        httpReportHelper.put("locationtestRussia.", "DR4");
        for (String string2 : httpReportHelper.keySet()) {
            if (!string.contains(string2)) continue;
            return (String)httpReportHelper.get(string2);
        }
        return "UNKNOWN";
    }

    public void reportHttpResult(BaseRequest object, String string, String string2) {
        PluginReqMessage pluginReqMessage;
        block12: {
            Object object2;
            if (object == null) {
                LogLocation.e(TAG, "request param exception");
                return;
            }
            if (TextUtils.equals((CharSequence)"0", (CharSequence)((BaseRequest)object).getHeads().get(HTTP_NEED_REPORT))) {
                LogLocation.w(TAG, "this request not need report");
                return;
            }
            if (this.reportBuilder == null) {
                ReportBuilder reportBuilder;
                object2 = reportBuilder;
                reportBuilder = new ReportBuilder();
                this.reportBuilder = object2;
            }
            this.reportBuilder.setApiName(LOCATION_SERVER_API);
            object2 = ((BaseRequest)object).getHeads().get("X-Request-ID");
            this.reportBuilder.setTransactionID((String)object2);
            object2 = ((BaseRequest)object).getPath();
            if (((String)object2).length() > 60) {
                this.reportBuilder.setRequestUrl(((String)object2).substring(0, 60));
            } else {
                this.reportBuilder.setRequestUrl((String)object2);
            }
            if (!StringUtil.isEmpty(string)) {
                this.reportBuilder.setErrorCode(string);
            }
            if (!StringUtil.isEmpty(string2)) {
                this.reportBuilder.setErrorMessage(string2);
            }
            if (!TextUtils.equals((CharSequence)string, (CharSequence)String.valueOf(200)) && TextUtils.isEmpty((CharSequence)this.reportBuilder.getMcc())) {
                this.reportBuilder.setMCC(this.url2Dr(((BaseRequest)object).getBaseUrl()));
            }
            HttpReportHelper httpReportHelper = this;
            httpReportHelper.addExt((BaseRequest)object, string);
            httpReportHelper.reportBuilder.setCostTime();
            if (SDKComponentType.getComponentType() != 100) break block12;
            Tracker.getInstance().onMaintEvent(this.reportBuilder);
            Tracker.getInstance().onOperationEvent(this.reportBuilder);
        }
        object = pluginReqMessage;
        try {
            new PluginReqMessage().setData(GsonUtil.getInstance().toJson((Object)this.reportBuilder));
            Bundle bundle = new Bundle();
            bundle.putString("report_type", "server_report");
            ((PluginReqMessage)object).setExtraData(bundle);
            PluginManager.getInstance().startFunction(102, "report", (PluginReqMessage)object, null);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "reportHttpResult exception");
        }
    }

    public void setHttpSDKCostTime(long l) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        ((HttpReportHelper)((Object)stringBuilder2)).reportBuilder.setExtParam(HTTP_SDK_COST_TIME, stringBuilder.append(l).append("").toString());
    }
}

