/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.adapter;

import com.huawei.location.lite.common.http.adapter.ResponseBodyAdapter;
import com.huawei.location.lite.common.http.request.HeadBuilder;

public class ResponseAdapter {
    private ResponseBodyAdapter body;
    private HeadBuilder headers;
    private int code;
    private String message;
    private long sentRequestAtMillis;
    private long receivedResponseAtMillis;
    private String url;

    private ResponseAdapter(Builder builder) {
        this.body = builder.body;
        this.headers = builder.headers;
        this.code = builder.code;
        this.message = builder.message;
        this.sentRequestAtMillis = builder.sentRequestAtMillis;
        this.receivedResponseAtMillis = builder.receivedResponseAtMillis;
        this.url = builder.url;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public long getSentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public long getReceivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    public long getSDKCostTime() {
        return this.receivedResponseAtMillis - this.sentRequestAtMillis;
    }

    public HeadBuilder getHeaders() {
        return this.headers;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public ResponseBodyAdapter getBody() {
        return this.body;
    }

    public boolean isOK() {
        return this.code == 200;
    }

    public boolean isSuccessful() {
        int n = this.code;
        return n >= 200 && n < 300;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "ResponseAdapter{body=" + this.body.toString() + ", headers=" + this.headers.toString() + ", code=" + this.code + ", message='" + this.message + '\'' + ", sentRequestAtMillis=" + this.sentRequestAtMillis + ", receivedResponseAtMillis=" + this.receivedResponseAtMillis + ", url='" + this.url + '\'' + '}';
    }

    public static final class Builder {
        private ResponseBodyAdapter body;
        private HeadBuilder headers;
        private int code;
        private String message;
        private long sentRequestAtMillis;
        private long receivedResponseAtMillis;
        private String url;

        public Builder() {
        }

        private Builder(ResponseAdapter responseAdapter) {
            this.body = responseAdapter.body;
            this.headers = responseAdapter.headers;
            this.code = responseAdapter.code;
            this.message = responseAdapter.message;
            this.sentRequestAtMillis = responseAdapter.sentRequestAtMillis;
            this.receivedResponseAtMillis = responseAdapter.receivedResponseAtMillis;
            this.url = responseAdapter.url;
        }

        public Builder body(ResponseBodyAdapter responseBodyAdapter) {
            this.body = responseBodyAdapter;
            return this;
        }

        public Builder headers(HeadBuilder headBuilder) {
            this.headers = headBuilder;
            return this;
        }

        public Builder code(int n) {
            this.code = n;
            return this;
        }

        public Builder message(String string) {
            this.message = string;
            return this;
        }

        public Builder receivedResponseAtMillis(long l) {
            this.receivedResponseAtMillis = l;
            return this;
        }

        public Builder sentRequestAtMillis(long l) {
            this.sentRequestAtMillis = l;
            return this;
        }

        public Builder url(String string) {
            this.url = string;
            return this;
        }

        public ResponseAdapter build() {
            return new ResponseAdapter(this);
        }
    }
}

