/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.adapter;

import java.nio.charset.StandardCharsets;

public class ResponseBodyAdapter {
    private String contentType;
    private long contentLength;
    private byte[] responseByte;

    private ResponseBodyAdapter(Builder builder) {
        this.contentType = builder.contentType;
        this.contentLength = builder.contentLength;
        this.responseByte = builder.responseByte;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public final byte[] bytes() {
        return this.responseByte;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "ResponseBodyAdapter{contentType='" + this.contentType + '\'' + ", contentLength=" + this.contentLength + ", responseByte=" + new String(this.responseByte, StandardCharsets.UTF_8) + '}';
    }

    public static final class Builder {
        private String contentType;
        private long contentLength;
        private byte[] responseByte;

        public Builder() {
        }

        public Builder(ResponseBodyAdapter responseBodyAdapter) {
            this.contentType = responseBodyAdapter.contentType;
            this.contentLength = responseBodyAdapter.contentLength;
            this.responseByte = responseBodyAdapter.responseByte;
        }

        public Builder contentType(String string) {
            this.contentType = string;
            return this;
        }

        public Builder contentLength(long l) {
            this.contentLength = l;
            return this;
        }

        public Builder bytes(byte[] byArray) {
            this.responseByte = byArray;
            return this;
        }

        public ResponseBodyAdapter build() {
            return new ResponseBodyAdapter(this);
        }
    }
}

