/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.exception;

import java.util.HashMap;
import java.util.Map;

public class ErrorCode {
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;
    public static final int INTERNAL_ERROR = 10000;
    public static final int GET_RESPONSE_FAILED = 10300;
    public static final int STRING_PARSE_FAILED = 10301;
    public static final int NO_NETWORK = 10302;
    public static final int JSON_PARSE_FAILED = 10304;
    public static final int LOCATION_SERVER_ERROR = 10315;
    public static final int RESPONSE_IS_NULL = 10307;
    public static final int COMMON_NETWORK_KIT_NOT_INIT = 10308;
    public static final int PARAM_ERROR_EMPTY = 10309;
    public static final int TSS_SIGN_PARAM_ERROR = 10500;
    public static final int TSS_GET_CREDENTIAL_API_FAILED = 10501;
    public static final int TSS_GET_CREDENTIAL_JSON_PARSE_FAILED = 10502;
    public static final int TSS_GET_CREDENTIAL_EXC_FAILED = 10503;
    public static final int TSS_GET_CREDENTIAL_TIME_OUT = 10504;
    public static final int TSS_GET_CREDENTIAL_TIME_OUT_RETURN = 10505;
    public static final int TSS_GET_CREDENTIAL_INTER_EXC = 10506;
    public static final int TSS_GET_SECRET_FAILED_CREDENTIAL_EMPTY = 10510;
    public static final int TSS_GET_SECRET_API_FAILED = 10511;
    public static final int TSS_GET_SECRET_JSON_PARSE_FAILED = 10512;
    public static final int TSS_GET_SECRET_EXC_FAILED = 10513;
    public static final int TSS_GET_SECRET_TIME_OUT = 10514;
    public static final int TSS_GET_SECRET_TIME_OUT_RETURN = 10515;
    public static final int TSS_GET_SECRET_INTER_EXC = 10516;
    public static final int TSS_GET_SECRET_FAILED_OTHER = 10517;
    public static final int TSS_GET_SECRET_DROPPING_CUR_IS_VALID = 10518;
    public static final int TSS_ENCRYPT_FAILED = 10519;
    public static final int TSS_GET_SECRET_SUCCESS = 10520;
    public static final int UCS_SIGN_FAILED = 10550;
    private static final Map<Integer, String> ERROR_CODE_DESC_MAP = new HashMap<Integer, String>();
    public int code;
    public String msg;

    public ErrorCode(int n, String string) {
        this.code = n;
        this.msg = string;
    }

    public static ErrorCode valueOf(int n) {
        Map<Integer, String> map = ERROR_CODE_DESC_MAP;
        if (map.containsKey(n)) {
            return new ErrorCode(n, map.get(n));
        }
        return new ErrorCode(10000, map.get(10000));
    }

    public static String valueOfKey(int n) {
        Map<Integer, String> map = ERROR_CODE_DESC_MAP;
        if (map.containsKey(n)) {
            return map.get(n);
        }
        return map.get(10000);
    }

    static {
        ERROR_CODE_DESC_MAP.put(0, "success");
        ERROR_CODE_DESC_MAP.put(1, "inner error");
        ERROR_CODE_DESC_MAP.put(200, "HTTP_OK");
        ERROR_CODE_DESC_MAP.put(201, "HTTP_CREATED");
        ERROR_CODE_DESC_MAP.put(202, "HTTP_ACCEPTED");
        ERROR_CODE_DESC_MAP.put(203, "HTTP_NOT_AUTHORITATIVE");
        ERROR_CODE_DESC_MAP.put(204, "HTTP_NO_CONTENT");
        ERROR_CODE_DESC_MAP.put(205, "HTTP_RESET");
        ERROR_CODE_DESC_MAP.put(206, "HTTP_PARTIAL");
        ERROR_CODE_DESC_MAP.put(300, "HTTP_MULT_CHOICE");
        ERROR_CODE_DESC_MAP.put(301, "HTTP_MOVED_PERM");
        ERROR_CODE_DESC_MAP.put(302, "HTTP_MOVED_TEMP");
        ERROR_CODE_DESC_MAP.put(303, "HTTP_SEE_OTHER");
        ERROR_CODE_DESC_MAP.put(304, "HTTP_NOT_MODIFIED");
        ERROR_CODE_DESC_MAP.put(305, "HTTP_USE_PROXY");
        ERROR_CODE_DESC_MAP.put(400, "HTTP_BAD_REQUEST");
        ERROR_CODE_DESC_MAP.put(401, "HTTP_UNAUTHORIZED");
        ERROR_CODE_DESC_MAP.put(402, "HTTP_PAYMENT_REQUIRED");
        ERROR_CODE_DESC_MAP.put(403, "HTTP_FORBIDDEN");
        ERROR_CODE_DESC_MAP.put(404, "HTTP_NOT_FOUND");
        ERROR_CODE_DESC_MAP.put(405, "HTTP_BAD_METHOD");
        ERROR_CODE_DESC_MAP.put(406, "HTTP_NOT_ACCEPTABLE");
        ERROR_CODE_DESC_MAP.put(407, "HTTP_PROXY_AUTH");
        ERROR_CODE_DESC_MAP.put(408, "HTTP_CLIENT_TIMEOUT");
        ERROR_CODE_DESC_MAP.put(409, "HTTP_CONFLICT");
        ERROR_CODE_DESC_MAP.put(410, "HTTP_GONE");
        ERROR_CODE_DESC_MAP.put(411, "HTTP_LENGTH_REQUIRED");
        ERROR_CODE_DESC_MAP.put(412, "HTTP_PRECON_FAILED");
        ERROR_CODE_DESC_MAP.put(413, "HTTP_ENTITY_TOO_LARGE");
        ERROR_CODE_DESC_MAP.put(414, "HTTP_REQ_TOO_LONG");
        ERROR_CODE_DESC_MAP.put(415, "HTTP_UNSUPPORTED_TYPE");
        ERROR_CODE_DESC_MAP.put(500, "HTTP_INTERNAL_ERROR");
        ERROR_CODE_DESC_MAP.put(501, "HTTP_NOT_IMPLEMENTED");
        ERROR_CODE_DESC_MAP.put(502, "HTTP_BAD_GATEWAY");
        ERROR_CODE_DESC_MAP.put(503, "HTTP_UNAVAILABLE");
        ERROR_CODE_DESC_MAP.put(504, "HTTP_GATEWAY_TIMEOUT");
        ERROR_CODE_DESC_MAP.put(505, "HTTP_VERSION");
        ERROR_CODE_DESC_MAP.put(10000, "internal error");
        ERROR_CODE_DESC_MAP.put(10300, "GET_RESPONSE_FAILED");
        ERROR_CODE_DESC_MAP.put(10302, "no network");
        ERROR_CODE_DESC_MAP.put(10304, "json parse failed");
        ERROR_CODE_DESC_MAP.put(10301, "server response format is error");
        ERROR_CODE_DESC_MAP.put(10315, "server response error code");
        ERROR_CODE_DESC_MAP.put(10307, "okHttp Response is null");
        ERROR_CODE_DESC_MAP.put(10309, "param error");
        ERROR_CODE_DESC_MAP.put(10308, "common network kit not init");
        ERROR_CODE_DESC_MAP.put(10500, "TSS_SIGN_PARAM_ERROR");
        ERROR_CODE_DESC_MAP.put(10501, "TSS_GET_CREDENTIAL_API_FAILED");
        ERROR_CODE_DESC_MAP.put(10502, "TSS_GET_CREDENTIAL_JSON_PARSE_FAILED");
        ERROR_CODE_DESC_MAP.put(10503, "TSS_GET_CREDENTIAL_EXC_FAILED");
        ERROR_CODE_DESC_MAP.put(10504, "TSS_GET_CREDENTIAL_TIME_OUT");
        ERROR_CODE_DESC_MAP.put(10505, "TSS_GET_CREDENTIAL_TIME_OUT_RETURN");
        ERROR_CODE_DESC_MAP.put(10506, "TSS_GET_CREDENTIAL_INTER_EXC");
        ERROR_CODE_DESC_MAP.put(10510, "TSS_GET_SECRET_FAILED_CREDENTIAL_EMPTY");
        ERROR_CODE_DESC_MAP.put(10511, "TSS_GET_SECRET_API_FAILED");
        ERROR_CODE_DESC_MAP.put(10512, "TSS_GET_SECRET_JSON_PARSE_FAILED");
        ERROR_CODE_DESC_MAP.put(10513, "TSS_GET_SECRET_EXC_FAILED");
        ERROR_CODE_DESC_MAP.put(10514, "TSS_GET_SECRET_TIME_OUT");
        ERROR_CODE_DESC_MAP.put(10515, "TSS_GET_SECRET_TIME_OUT_RETURN");
        ERROR_CODE_DESC_MAP.put(10516, "TSS_GET_SECRET_INTER_EXC");
        ERROR_CODE_DESC_MAP.put(10517, "TSS_GET_SECRET_FAILED_OTHER");
        ERROR_CODE_DESC_MAP.put(10518, "TSS_GET_SECRET_DROPPING_CUR_IS_VALID");
        ERROR_CODE_DESC_MAP.put(10519, "TSS_ENCRYPT_FAILED");
        ERROR_CODE_DESC_MAP.put(10520, "TSS_GET_SECRET_SUCCESS");
        ERROR_CODE_DESC_MAP.put(10550, "UCS_SIGN_FAILED");
    }

    public String toString() {
        return "ErrorCode{code=" + this.code + ", msg='" + this.msg + '\'' + '}';
    }
}

