/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.interceptor;

import android.text.TextUtils;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.http.adapter.InterceptorAdapter;
import com.huawei.location.lite.common.http.adapter.ResponseAdapter;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.exception.OnFailureException;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.DeviceInfoUtil;
import java.io.IOException;

public abstract class BaseCommonInterceptor
implements InterceptorAdapter {
    protected static final String TAG = "CommonHeadsInterceptor";
    protected static final String HMS_CORE_VERSION = "X-HmsCore-V";
    protected static final String LOCATION_KIT_VERSION = "X-LocationKit-V";
    protected static final String EMUI_VERSION = "X-OS-V";
    protected static final String PHONE_MODEL = "X-PhoneModel";
    protected static final String DEVICE_TYPE = "X-Device-Type";
    protected static final String LOCATOR_SDK_VERSION = "X-LocatorSdk-V";
    protected static final String USER_AGENT = "User-Agent";
    protected static final String APPID = "appid";
    protected static final String PARAM_CLIENT_VERSION = "clientVersion";
    protected static final String PARAM_CLIENT_LITE_VERSION = "clientLiteSDKVersion";

    private void addCommonHeads(BaseRequest.Builder builder) {
        this.addHead(builder, DEVICE_TYPE, Integer.toString(DeviceInfoUtil.getDeviceFeature(ContextUtil.getContext())));
        this.addHead(builder, PHONE_MODEL, DeviceInfoUtil.getDeviceModel());
    }

    protected static String getUserAgent() {
        StringBuilder stringBuilder;
        String string = System.getProperty("http.agent");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u001f' && c < '\u007f') {
                stringBuilder2.append(c);
                continue;
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = (int)c;
            stringBuilder2.append(String.format("\\u%04x", objectArray2));
        }
        return stringBuilder2.toString();
    }

    @Override
    public ResponseAdapter intercept(InterceptorAdapter.Chain chain) throws IOException, OnFailureException, OnErrorException {
        BaseCommonInterceptor baseCommonInterceptor = builder;
        BaseRequest.Builder builder = chain.request().newBuilder();
        baseCommonInterceptor.addCommonHeads(builder);
        baseCommonInterceptor.addCustomHeads(builder);
        baseCommonInterceptor.addCustomQuery(builder);
        return chain.proceed(builder.build());
    }

    public abstract void addCustomHeads(BaseRequest.Builder var1);

    public abstract void addCustomQuery(BaseRequest.Builder var1);

    void addHead(BaseRequest.Builder builder, String string, String string2) {
        block4: {
            block3: {
                try {
                    builder.addHeader(string, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break block3;
                }
                catch (NullPointerException nullPointerException) {}
                break block4;
            }
            LogLocation.d(TAG, "add head failed : key or value is null or illegal");
        }
    }
}

