/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.interceptor;

import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.http.adapter.InterceptorAdapter;
import com.huawei.location.lite.common.http.adapter.ResponseAdapter;
import com.huawei.location.lite.common.http.exception.AuthException;
import com.huawei.location.lite.common.http.exception.ErrorCode;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.exception.OnFailureException;
import com.huawei.location.lite.common.http.interceptor.BaseAuthInterceptor;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.http.sign.SignRequest;
import com.huawei.location.lite.common.http.sign.ucs.UCSSignHelper;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.wisesecurity.ucs.common.exception.UcsCryptoException;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import java.io.IOException;

public class UcsAuthInterceptor
extends BaseAuthInterceptor {
    private static final String TAG = "UcsAuthInterceptor";
    private static final int MAX_SIGN_RETRY_COUNT = 3;
    private static final int REAPPLY_THE_CREDENTIAL = 1020;
    private int requestTimes = 0;

    private boolean reTrySign(long l) {
        if (l == 1020L && ++this.requestTimes <= 3) {
            UCSSignHelper.getInstance().reApplyCredential();
            return true;
        }
        return false;
    }

    @Override
    public ResponseAdapter intercept(InterceptorAdapter.Chain chain) throws IOException, OnFailureException, OnErrorException {
        return chain.proceed(this.auth(chain.request()));
    }

    @Override
    public BaseRequest sign(BaseRequest baseRequest, SignRequest signRequest) throws IOException {
        block6: {
            BaseRequest baseRequest2 = baseRequest;
            String string = UCSSignHelper.getInstance().sign(ContextUtil.getContext(), signRequest);
            LogLocation.d(TAG, "X_REQUEST_ID:" + baseRequest.getHeads().get("X-Request-ID"));
            try {
                LogLocation.d(TAG, "auth:" + string);
                return baseRequest2.newBuilder().addHeader("authorization", string).build();
            }
            catch (UcsCryptoException ucsCryptoException) {
                LogLocation.e(TAG, "UcsCryptoException:" + ucsCryptoException.getMessage());
                if (this.reTrySign(ucsCryptoException.getErrorCode())) {
                    return this.sign(baseRequest, signRequest);
                }
            }
            catch (UcsException ucsException) {
                LogLocation.e(TAG, "UcsException:errorCode:" + ucsException.getErrorCode() + ",message:" + ucsException.getMessage());
                if (!this.reTrySign(ucsException.getErrorCode())) break block6;
                return this.sign(baseRequest, signRequest);
            }
        }
        LogLocation.e(TAG, "AuthException:10550");
        throw new AuthException(ErrorCode.valueOf(10550));
    }
}

