/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.parse;

import android.text.TextUtils;
import com.huawei.location.lite.common.http.adapter.ResponseAdapter;
import com.huawei.location.lite.common.http.adapter.ResponseBodyAdapter;
import com.huawei.location.lite.common.http.exception.ErrorCode;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.exception.OnFailureException;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.http.request.HeadBuilder;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.ByteString;

public class ParseHttpUtils {
    private static final String TAG = "ParseHttpUtils";

    public static Request parseRequest(BaseRequest iterator, Request.Builder builder) throws OnErrorException {
        BaseRequest baseRequest;
        if (iterator == null) {
            return null;
        }
        LogLocation.d(TAG, "baseRequest:" + iterator);
        Map.Entry entry2 = ((BaseRequest)((Object)iterator)).getMethod();
        RequestBody requestBody = null;
        if (TextUtils.equals((CharSequence)"POST", (CharSequence)((Object)entry2))) {
            requestBody = RequestBody.create((MediaType)(!TextUtils.isEmpty((CharSequence)((BaseRequest)((Object)iterator)).getContentType()) ? MediaType.parse((String)((BaseRequest)((Object)iterator)).getContentType()) : MediaType.parse((String)"application/json; charset=utf-8")), (ByteString)ByteString.of((byte[])((BaseRequest)((Object)iterator)).getBody()));
        }
        try {
            baseRequest = iterator;
            builder.url(((BaseRequest)((Object)iterator)).getFullUrl()).method((String)((Object)entry2), requestBody);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OnErrorException(ErrorCode.valueOf(10309));
        }
        iterator = baseRequest.getHeads().getHeaders();
        if (iterator == null) {
            return builder.build();
        }
        for (Map.Entry entry2 : ((HashMap)((Object)iterator)).entrySet()) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)entry2.getValue()))) continue;
            builder.addHeader((String)entry2.getKey(), (String)entry2.getValue());
        }
        return builder.build();
    }

    private static HashMap<String, String> getHeaders(Headers headers) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        for (String string : headers.names()) {
            Object object = headers.values(string);
            if (object.isEmpty()) continue;
            object = object.iterator();
            while (object.hasNext()) {
                hashMap2.put(string, (String)object.next());
            }
        }
        return hashMap2;
    }

    public static ResponseAdapter parseResponseAdapter(Response response) throws OnFailureException {
        Object object = response.body();
        if (object != null) {
            HashMap<String, String> hashMap = ParseHttpUtils.getHeaders(response.headers());
            Object object2 = object.contentType();
            ResponseBodyAdapter.Builder builder = new ResponseBodyAdapter.Builder().bytes(HttpUtils.toByteArray(object.byteStream()));
            object2 = object2 != null ? object2.toString() : "";
            object = builder.contentType((String)object2).contentLength(object.contentLength()).build();
            return new ResponseAdapter.Builder().body((ResponseBodyAdapter)object).headers(new HeadBuilder().addAll(hashMap)).message(response.message()).code(response.code()).url(response.request().url().toString()).build();
        }
        throw new OnFailureException(ErrorCode.valueOf(10300));
    }
}

