/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.request;

import android.net.Uri;
import android.text.TextUtils;
import com.huawei.location.lite.common.grs.LocationNlpGrsHelper;
import com.huawei.location.lite.common.http.request.HeadBuilder;
import com.huawei.location.lite.common.http.request.RequestJsonBody;
import com.huawei.location.lite.common.http.request.RequestsStreamBody;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.HttpUtils;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class BaseRequest {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private final String method;
    private String baseUrl;
    private String path;
    private SortedMap<String, String> queryMap;
    private final HeadBuilder heads;
    private final String contentType;
    private final byte[] body;

    public BaseRequest(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.heads = builder.heads;
        this.body = builder.body;
        this.method = builder.method;
        this.contentType = builder.contentType;
        this.path = builder.path;
        this.queryMap = builder.queryMap;
        this.parsePathQuery();
    }

    private void parsePathQuery() {
        String string;
        Serializable serializable;
        block14: {
            if (!this.path.contains("?")) {
                return;
            }
            if (this.queryMap == null) {
                TreeMap<String, String> treeMap;
                serializable = treeMap;
                treeMap = new TreeMap<String, String>();
                this.queryMap = serializable;
            }
            serializable = URI.create(HttpUtils.urlDecode(this.baseUrl + this.path));
            string = ((URI)serializable).getQuery();
            if (string != null) break block14;
            return;
        }
        String string2 = string;
        BaseRequest baseRequest = this;
        Serializable serializable2 = serializable;
        BaseRequest baseRequest2 = this;
        baseRequest2.baseUrl = ((URI)serializable).getScheme() + "://" + ((URI)serializable).getHost();
        baseRequest.path = ((URI)serializable2).getPath();
        serializable = string2.split("&");
        int n = ((String[])serializable).length;
        for (int i = 0; i < n; ++i) {
            Object object = ((String)((Object)serializable[i])).split("=");
            if (((String[])object).length != 2) continue;
            SortedMap<String, String> sortedMap = this.queryMap;
            String[] stringArray = object;
            object = object[0];
            try {
                sortedMap.put((String)object, stringArray[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogLocation.e("BaseRequest", "parse query failed");
                break;
            }
            continue;
        }
    }

    public HeadBuilder getHeads() {
        return this.heads;
    }

    public String getMethod() {
        return this.method;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public SortedMap<String, String> getQueryMap() {
        return this.queryMap;
    }

    public String getQueryString() {
        StringBuilder stringBuilder;
        if (((BaseRequest)((Object)stringBuilder2)).queryMap == null) {
            return "";
        }
        BaseRequest baseRequest = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : baseRequest.queryMap.entrySet()) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("&");
            }
            stringBuilder2.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return stringBuilder2.toString();
    }

    public String getFullUrl() {
        BaseRequest baseRequest = this;
        Uri.Builder builder = Uri.parse((String)baseRequest.baseUrl).buildUpon();
        if (!TextUtils.isEmpty((CharSequence)baseRequest.path)) {
            builder.path(((BaseRequest)((Object)this)).path);
        }
        if ((this = ((BaseRequest)((Object)this)).queryMap) == null) {
            return HttpUtils.urlDecode(builder.build().toString());
        }
        for (Map.Entry entry : this.entrySet()) {
            builder.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return HttpUtils.urlDecode(builder.build().toString());
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return "BaseRequest{method='" + this.method + '\'' + ", baseUrl='" + this.baseUrl + '\'' + ", path='" + this.path + '\'' + ", heads=" + this.heads + ", contentType='" + this.contentType + '\'' + ", body=" + new String(this.body, StandardCharsets.UTF_8) + '}';
    }

    public Builder newBuilder() {
        BaseRequest baseRequest = this;
        byte[] byArray = baseRequest.body;
        return new Builder(this.path).setBaseUrl(this.baseUrl).setBody(byArray, baseRequest.contentType).setHeads(this.heads).setMethod(this.method).addAllQuery(this.queryMap);
    }

    public static final class Builder {
        private SortedMap<String, String> queryMap;
        private String baseUrl;
        private String path;
        private byte[] body;
        private String contentType;
        private String method = "POST";
        private HeadBuilder heads;

        public Builder(String string) {
            this.path = string;
        }

        public Builder setBaseUrl(String string) {
            this.baseUrl = string;
            return this;
        }

        public Builder addQuery(String string, String string2) {
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                if (this.queryMap == null) {
                    TreeMap<String, String> treeMap;
                    TreeMap<String, String> treeMap2 = treeMap;
                    treeMap = new TreeMap<String, String>();
                    this.queryMap = treeMap2;
                }
                Builder builder = this;
                builder.queryMap.put(string, string2);
                return builder;
            }
            return this;
        }

        public Builder addAllQuery(SortedMap<String, String> sortedMap) {
            if (sortedMap == null) {
                return this;
            }
            if (this.queryMap == null) {
                TreeMap<String, String> treeMap;
                TreeMap<String, String> treeMap2 = treeMap;
                treeMap = new TreeMap<String, String>();
                this.queryMap = treeMap2;
            }
            Builder builder = this;
            builder.queryMap.putAll(sortedMap);
            return builder;
        }

        public Builder setBody(RequestJsonBody requestJsonBody) {
            this.body = requestJsonBody.getBody().getBytes();
            this.contentType = requestJsonBody.contentType();
            return this;
        }

        public Builder setBody(byte[] byArray, String string) {
            this.body = byArray;
            this.contentType = string;
            return this;
        }

        public Builder setBody(RequestsStreamBody requestsStreamBody) {
            this.body = requestsStreamBody.getBody();
            this.contentType = requestsStreamBody.contentType();
            return this;
        }

        public Builder setHeads(HeadBuilder headBuilder) {
            this.heads = headBuilder;
            return this;
        }

        public Builder addHeader(String string, String string2) {
            if (this.heads == null) {
                HeadBuilder headBuilder;
                HeadBuilder headBuilder2 = headBuilder;
                headBuilder = new HeadBuilder();
                this.heads = headBuilder2;
            }
            Builder builder = this;
            builder.heads.add(string, string2);
            return builder;
        }

        public Builder addHeaders(HashMap<String, String> hashMap) {
            if (this.heads == null) {
                HeadBuilder headBuilder;
                HeadBuilder headBuilder2 = headBuilder;
                headBuilder = new HeadBuilder();
                this.heads = headBuilder2;
            }
            if (hashMap != null) {
                this.heads.addAll(hashMap);
            }
            return this;
        }

        public Builder removeHeader(String string) {
            HeadBuilder headBuilder = this.heads;
            if (headBuilder == null) {
                return this;
            }
            headBuilder.remove(string);
            return this;
        }

        public Builder setMethod(String string) {
            this.method = string;
            return this;
        }

        public BaseRequest build() {
            if (TextUtils.isEmpty((CharSequence)this.baseUrl)) {
                this.baseUrl = LocationNlpGrsHelper.getGrsHostAddress("com.huawei.hms.location");
            }
            return new BaseRequest(this);
        }
    }
}

