/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.request;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.UUID;

public class HeadBuilder {
    public static final String X_REQUEST_ID = "X-Request-ID";
    public static final String CLIENT_CP_NAME = "X-CP-Info";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    public static final String CLIENT_SDK_VERSION = "x-client-sdk-version";
    private final HashMap<String, String> headers;

    public HeadBuilder() {
        this(UUID.randomUUID().toString());
    }

    public HeadBuilder(@NonNull String string) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        v1.headers = new HashMap(16);
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = UUID.randomUUID().toString();
        }
        Object object = hashMap2;
        ((HashMap)object).put(X_REQUEST_ID, string);
        ((HashMap)object).put(CONTENT_TYPE, APPLICATION_JSON);
    }

    public HeadBuilder setContentType(@NonNull String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.headers.put(CONTENT_TYPE, string);
        }
        return this;
    }

    public HeadBuilder setCPKitSDKVersion(@NonNull String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.headers.put(CLIENT_SDK_VERSION, string);
        }
        return this;
    }

    public HeadBuilder setPackageName(@NonNull String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.headers.put(CLIENT_CP_NAME, string);
        }
        return this;
    }

    public HeadBuilder addAll(@NonNull HashMap<String, String> hashMap) {
        if (hashMap != null) {
            this.headers.putAll(hashMap);
        }
        return this;
    }

    public HeadBuilder add(String string, String string2) {
        if (string != null && string2 != null) {
            this.headers.put(string, string2);
        }
        return this;
    }

    public String get(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.headers.get(string);
    }

    public String remove(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.headers.remove(string);
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "HeadBuilder{headers=" + this.headers + '}';
    }
}

