/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.request;

import android.text.TextUtils;
import com.huawei.location.lite.common.http.adapter.RequestBodyAdapter;
import com.huawei.location.lite.common.log.LogLocation;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestJsonBody
extends RequestBodyAdapter {
    private static final String TAG = "RequestJsonBody";
    public static final String APPLICATION_JSON_UTF_8 = "application/json; charset=utf-8";
    private String body;

    public RequestJsonBody(Builder builder) {
        if (builder.dataFormatType == 1) {
            if (!TextUtils.isEmpty((CharSequence)builder.rawBody)) {
                this.body = builder.rawBody.substring(0, builder.rawBody.length() - 1);
            }
        } else {
            this.body = builder.jsonBody.toString();
        }
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String contentType() {
        return APPLICATION_JSON_UTF_8;
    }

    public static final class Builder {
        public static final int DATA_FORMAT_TYPE_RAW = 1;
        private JSONObject jsonBody;
        private StringBuilder rawBody;
        private int dataFormatType;

        public Builder() {
            JSONObject jSONObject;
            Builder builder = jSONObject;
            jSONObject = new JSONObject();
            v1.jsonBody = builder;
        }

        public Builder(int n) {
            StringBuilder stringBuilder;
            JSONObject jSONObject;
            Object object = jSONObject;
            jSONObject = new JSONObject();
            v1.jsonBody = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder("");
            v1.rawBody = object;
            v1.dataFormatType = n;
        }

        public Builder setBody(JSONObject jSONObject) {
            this.jsonBody = jSONObject;
            return this;
        }

        public Builder add(String string, String string2) {
            block6: {
                if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                    block5: {
                        if (this.dataFormatType != 1) break block5;
                        this.rawBody.append(string).append("=").append(string2).append("&");
                        break block6;
                    }
                    try {
                        this.jsonBody.put(string, (Object)string2);
                    }
                    catch (JSONException jSONException) {
                        LogLocation.e(RequestJsonBody.TAG, "add: failed");
                    }
                }
            }
            return this;
        }

        public RequestJsonBody build(JSONObject jSONObject) {
            this.jsonBody = jSONObject;
            return new RequestJsonBody(this);
        }

        public RequestJsonBody build() {
            return new RequestJsonBody(this);
        }
    }
}

