/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.http.sign.ucs;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.location.lite.common.agc.AGCManager;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.grs.LocationNlpGrsHelper;
import com.huawei.location.lite.common.http.exception.AuthException;
import com.huawei.location.lite.common.http.exception.ErrorCode;
import com.huawei.location.lite.common.http.sign.SignRequest;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.report.Tracker;
import com.huawei.location.lite.common.util.PreferencesHelper;
import com.huawei.location.lite.common.util.country.CountryCodeUtil;
import com.huawei.wisesecurity.kfs.ha.message.ReportMsgBuilder;
import com.huawei.wisesecurity.ucs.common.exception.UcsCryptoException;
import com.huawei.wisesecurity.ucs.common.exception.UcsException;
import com.huawei.wisesecurity.ucs.common.log.ILogUcs;
import com.huawei.wisesecurity.ucs.credential.Credential;
import com.huawei.wisesecurity.ucs.credential.CredentialClient;
import com.huawei.wisesecurity.ucs.credential.crypto.signer.CredentialSignAlg;
import com.huawei.wisesecurity.ucs.credential.crypto.signer.CredentialSigner;
import com.huawei.wisesecurity.ucs.credential.outer.GrsCapability;
import com.huawei.wisesecurity.ucs.credential.outer.HACapability;
import com.huawei.wisesecurity.ucs.credential.outer.NetworkCapability;
import com.huawei.wisesecurity.ucs.credential.outer.NetworkRequest;
import com.huawei.wisesecurity.ucs.credential.outer.NetworkResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class UCSSignHelper {
    private static final String TAG = "UCSSignHelper";
    private static final String PACKAGE_NAME = "com.huawei.hms.location";
    private static final String APP_KEY_ID = "hmslocation";
    private static final long NEED_UPDATE_PERIOD = 3600000L;
    private static final String KEY_CREDENTIAL_CACHE = "credentialCache";
    private static final String KEY_CREDENTIAL_EXPIRED_TIME = "credentialExpiredTime";
    private Credential credential;
    private CredentialClient credentialClient;

    private UCSSignHelper() {
    }

    public static UCSSignHelper getInstance() {
        return UCSSignHelperHolder.INSTANCE;
    }

    private boolean checkAndInitCredential(Context context) {
        PreferencesHelper preferencesHelper;
        Object object = this.credential;
        if (object != null && !this.isNeedUpdate(object.getExpireTime())) {
            return true;
        }
        LogLocation.i(TAG, "init credential from sp");
        object = preferencesHelper;
        preferencesHelper = new PreferencesHelper("location_credential");
        this.credential = this.initCredentialFromSp(context, (PreferencesHelper)object);
        if (this.credential != null) {
            return true;
        }
        LogLocation.i(TAG, "init credential from network");
        this.credential = this.initCredentialFromNetwork(context);
        if (this.credential != null) {
            AGCManager.getInstance().notifyAkChange();
            long l = this.credential.getExpireTime();
            ((PreferencesHelper)object).saveLong(KEY_CREDENTIAL_EXPIRED_TIME, l);
            ((PreferencesHelper)object).saveString(KEY_CREDENTIAL_CACHE, this.credential.toString());
            LogLocation.i(TAG, "Credential init success, expire time is :" + this.credential.getExpireTime());
            return true;
        }
        return false;
    }

    private Credential initCredentialFromSp(Context context, PreferencesHelper object) {
        long l = ((PreferencesHelper)object).getLong(KEY_CREDENTIAL_EXPIRED_TIME);
        if (l > 0L && !this.isNeedUpdate(l)) {
            if (TextUtils.isEmpty((CharSequence)(object = ((PreferencesHelper)object).getString(KEY_CREDENTIAL_CACHE)))) {
                LogLocation.e(TAG, "sp credential is null");
                return null;
            }
            try {
                context = new CredentialClient.Builder().context(context).build();
            }
            catch (UcsException ucsException) {
                LogLocation.e(TAG, "init credential form sp failed :" + ucsException.getErrorCode());
                return null;
            }
            this.credentialClient = context;
            return context.genCredentialFromString((String)object);
        }
        LogLocation.e(TAG, "sp credential is expired,credentialExpiredTime:" + l);
        return null;
    }

    private boolean isNeedUpdate(Long l) {
        return System.currentTimeMillis() > l || l - System.currentTimeMillis() < 3600000L;
    }

    private synchronized Credential initCredentialFromNetwork(Context context) {
        CredentialClient credentialClient;
        try {
            credentialClient = new CredentialClient.Builder().context(context).serCountry(CountryCodeUtil.getLocationCountryCode()).networkRetryTime(1).networkTimeOut(10000).appId(AGCManager.getInstance().getAppId()).grsCapability((GrsCapability)new GrsCapabilityImpl()).haCapability((HACapability)new HACapabilityImpl()).networkCapability((NetworkCapability)new NetworkCapabilityImpl()).logInstance((ILogUcs)new LogUcsImpl()).build();
        }
        catch (UcsException ucsException) {
            LogLocation.e(TAG, "init credential form network failed :" + ucsException.getErrorCode());
            return null;
        }
        this.credentialClient = credentialClient;
        return credentialClient.applyCredential(PACKAGE_NAME);
    }

    private String realSign(SignRequest signRequest) throws UcsCryptoException, UcsException {
        Credential credential = ((UCSSignHelper)object).credential;
        if (credential != null && !((UCSSignHelper)object).isNeedUpdate(credential.getExpireTime())) {
            credential = new CredentialSigner.Builder().withCredential(((UCSSignHelper)object).credential).withAlg(CredentialSignAlg.HMAC_SHA256).withCredentialClient(((UCSSignHelper)object).credentialClient).build();
            String string = Long.toString(System.currentTimeMillis());
            Locale locale = Locale.ENGLISH;
            Object[] objectArray = new Object[6];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = signRequest.getMethod();
            objectArray2[1] = signRequest.getPath();
            objectArray2[2] = signRequest.getQuery();
            objectArray2[3] = signRequest.getPayload();
            objectArray[4] = ((UCSSignHelper)object).credential.getAccessKey();
            objectArray[5] = string;
            objectArray2 = String.format(locale, "%s&%s&%s&%s&ak=%s&timestamp=%s", objectArray2);
            if (!TextUtils.isEmpty((CharSequence)signRequest.getHeadSigned()[0])) {
                Object[] objectArray3 = new Object[2];
                Object[] objectArray4 = objectArray3;
                objectArray4[0] = objectArray2;
                objectArray3[1] = signRequest.getHeadSigned()[0];
                objectArray2 = String.format(locale, "%s&%s", objectArray4);
            }
            LogLocation.d(TAG, "newStringToSign:" + (String)objectArray2);
            credential = credential.getSignHandler().from((String)objectArray2).signBase64();
            LogLocation.i(TAG, "sign successful");
            Object[] objectArray5 = new Object[4];
            Object[] objectArray6 = objectArray2 = objectArray5;
            objectArray6[0] = APP_KEY_ID;
            objectArray6[1] = string;
            objectArray2[2] = credential;
            objectArray5[3] = ((UCSSignHelper)object).credential.getAccessKey();
            Object object = String.format(locale, "EXT-AUTH-CLOUDSOA-HMAC-SHA256 appid=%s,timestamp=%s,signature=%s,ak=%s", objectArray2);
            if (!TextUtils.isEmpty((CharSequence)signRequest.getHeadSigned()[1])) {
                Credential credential2 = new Object[2];
                credential = credential2;
                credential[0] = object;
                credential2[1] = signRequest.getHeadSigned()[1];
                object = String.format(locale, "%s,signedHeaders=%s", (Object[])credential);
            }
            return object;
        }
        LogLocation.e(TAG, "credential is not ready");
        return "";
    }

    public String sign(Context context, SignRequest signRequest) throws UcsCryptoException, UcsException, AuthException {
        LogLocation.d(TAG, "begin to sign");
        if (this.checkAndInitCredential(context)) {
            return this.realSign(signRequest);
        }
        LogLocation.e(TAG, "Credential init fail,sign fail");
        throw new AuthException(ErrorCode.valueOf(10550));
    }

    public void reApplyCredential() {
        LogLocation.i(TAG, "reApplyCredential");
        this.credential = null;
        PreferencesHelper preferencesHelper = new PreferencesHelper("location_credential");
        preferencesHelper.remove(KEY_CREDENTIAL_EXPIRED_TIME);
        preferencesHelper.remove(KEY_CREDENTIAL_CACHE);
        this.checkAndInitCredential(ContextUtil.getContext());
    }

    private static class LogUcsImpl
    implements ILogUcs {
        private LogUcsImpl() {
        }

        public void d(String string, String string2) {
            LogLocation.d(string, string2);
        }

        public void i(String string, String string2) {
            LogLocation.i(string, string2);
        }

        public void w(String string, String string2) {
            LogLocation.w(string, string2);
        }

        public void e(String string, String string2) {
            LogLocation.e(string, string2);
        }
    }

    private static class HACapabilityImpl
    implements HACapability {
        private HACapabilityImpl() {
        }

        public void onEvent(Context context, String string, ReportMsgBuilder reportMsgBuilder) {
            LinkedHashMap linkedHashMap = reportMsgBuilder.build();
            Tracker.getInstance().onEvent(1, string, linkedHashMap);
        }
    }

    private static class NetworkCapabilityImpl
    implements NetworkCapability {
        private NetworkCapabilityImpl() {
        }

        private NetworkResponse execute(Request request) throws IOException {
            block5: {
                NetworkResponse networkResponse;
                Object object = TimeUnit.MILLISECONDS;
                try {
                    object = new OkHttpClient.Builder().callTimeout(10000L, (TimeUnit)((Object)object)).connectTimeout(10000L, (TimeUnit)((Object)object)).retryOnConnectionFailure(false).build().newCall(request).execute();
                }
                catch (IOException iOException) {
                    LogLocation.e(UCSSignHelper.TAG, "UCS http failed by exception");
                    throw iOException;
                }
                request = networkResponse;
                request();
                request.setCode(object.code());
                networkResponse.setHeaders(object.headers().toMultimap());
                if (object.body() == null) break block5;
                request.setBody(object.body().string());
            }
            return request;
        }

        public void initConfig(int n, int n2) {
        }

        public NetworkResponse get(NetworkRequest networkRequest) throws IOException {
            LogLocation.d(UCSSignHelper.TAG, "NetworkCapabilityImpl ucs http getUrl\uff1a" + networkRequest.getUrl());
            return this.execute(new Request.Builder().url(networkRequest.getUrl()).headers(Headers.of((Map)networkRequest.getHeaders())).build());
        }

        public NetworkResponse post(NetworkRequest networkRequest) throws IOException {
            LogLocation.d(UCSSignHelper.TAG, "NetworkCapabilityImpl ucs http postUrl\uff1a" + networkRequest.getUrl());
            return this.execute(new Request.Builder().url(networkRequest.getUrl()).headers(Headers.of((Map)networkRequest.getHeaders())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)networkRequest.getBody())).build());
        }
    }

    private static class GrsCapabilityImpl
    implements GrsCapability {
        private GrsCapabilityImpl() {
        }

        public String synGetGrsUrl(String string, String string2) {
            LogLocation.d(UCSSignHelper.TAG, "GrsCapabilityImpl synGetGrsUrl" + string);
            return LocationNlpGrsHelper.getGrsHostAddress(CountryCodeUtil.getLocationCountryCode(), string, string2);
        }
    }

    private static class UCSSignHelperHolder {
        private static final UCSSignHelper INSTANCE = new UCSSignHelper();

        private UCSSignHelperHolder() {
        }
    }
}

