/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.log.logwrite;

import android.text.TextUtils;
import android.util.Log;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.logwrite.AppLog;
import com.huawei.location.lite.common.log.logwrite.DateUtil;
import com.huawei.location.lite.common.log.logwrite.FileParam;
import com.huawei.location.lite.common.log.logwrite.LogWriteConstants;
import com.huawei.location.lite.common.util.PermissionUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LogWrite {
    private static final String TAG = "LogWrite";
    private static final long DAY_TO_MILL = 86400000L;
    private static final int TWO = 2;
    private static final int FIVE = 5;
    private static final int TWENTY = 20;
    private static final int UNIT_CONVERSION = 1024;
    private static final int FILE_NAME_LENTH = 28;
    private static final int DOWN_LINE_INDEX = 17;
    private static final String PATTERN_ONE = "yyyyMMdd_HHmmss";
    private static final String PATTERN_TWO = "yy-MM-dd HH:mm:ss.SSS";
    private static boolean enableWriteLog = false;
    private Map<String, FileParam> fileInfoMap;
    private int maxFileNum;
    private int maxFileSize;
    private long maxFileExpired;
    private String logDirPath;

    public LogWrite() {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.fileInfoMap = concurrentHashMap2;
        v1.logDirPath = null;
    }

    public static boolean isEnableWriteLog() {
        return enableWriteLog;
    }

    public static void setEnableWriteLog(boolean bl) {
        enableWriteLog = bl;
    }

    private FileParam getFileInfo(String string) {
        FileParam fileParam;
        if (this.fileInfoMap.containsKey(string)) {
            return this.fileInfoMap.get(string);
        }
        FileParam fileParam2 = fileParam;
        fileParam = new FileParam();
        String string2 = this.logDirPath;
        if (!string.equals("log") && string.equals("location")) {
            string2 = this.logDirPath + LogWriteConstants.DEBUG_PATH + LogWriteConstants.LOCATION_PATH;
        }
        fileParam2.setFileDirPath(string2);
        this.fileInfoMap.put(string, fileParam2);
        return fileParam2;
    }

    private String getMsgByFileType(AppLog appLog) {
        if (appLog.getFileType().equals("location")) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = appLog.getMsg() + System.lineSeparator();
            return String.format(Locale.ENGLISH, "%s", objectArray2);
        }
        Object[] objectArray = new Object[4];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = super.getNow();
        objectArray3[1] = appLog.getLevel();
        objectArray[2] = appLog.getTag();
        objectArray[3] = appLog.getMsg() + System.lineSeparator() + Log.getStackTraceString((Throwable)appLog.getTr());
        return String.format(Locale.ENGLISH, "%s: %s/%s: %s", objectArray3);
    }

    private void doWrite(AppLog object, FileParam fileParam) throws IOException {
        String string = ((LogWrite)((Object)string)).getMsgByFileType((AppLog)object);
        object = fileParam.getWriter();
        if (object != null) {
            Object object2 = object;
            ((Writer)object2).append(string);
            ((BufferedWriter)object2).flush();
        }
    }

    private boolean isFileFull(String object, String string, String string2) {
        File file;
        String string3 = object;
        object = file;
        file = new File(string, string2);
        if (string3.equals("location")) {
            return ((File)object).length() > (long)0x100000;
        }
        return ((File)object).length() > (long)this.maxFileSize;
    }

    private void beforeWriteCheck(FileParam fileParam, String string) throws IOException {
        File file;
        FileParam fileParam2 = fileParam;
        Object object = fileParam2.getFileName();
        String string2 = fileParam2.getFileDirPath();
        if (!TextUtils.isEmpty((CharSequence)object)) {
            if (new File(string2, (String)object).exists()) {
                return;
            }
            Log.i((String)TAG, (String)"writeToFile file is not exit");
        }
        object = file;
        if (!new File(string2).exists()) {
            LogWrite logWrite = this;
            Log.i((String)TAG, (String)"beforeWriteCheck None of the paths exist--Create a path--Create a file");
            fileParam.setNeedCheck(false);
            logWrite.creatFolder(string2);
            logWrite.createNewLogFile(fileParam, logWrite.makeLogFileName(string), string);
        } else {
            this.pathExistsDeal((File)object, fileParam, string);
        }
    }

    private File[] getExistedFiles(File file2, String string2) {
        if (string2.equals("location")) {
            return file2.listFiles((file, string) -> string.startsWith("Location") && string.endsWith(".csv") && string.length() == 28 && "_".equals(String.valueOf(string.charAt(17))));
        }
        return file2.listFiles((file, string) -> string.startsWith("Location") && string.endsWith(".log") && string.length() == 28 && "_".equals(String.valueOf(string.charAt(17))));
    }

    private void pathExistsDeal(File fileArray, FileParam fileParam, String string) throws IOException {
        String string2 = fileParam.getFileDirPath();
        if (fileParam.isFirstWrite()) {
            this.filesNumAndUsefulCheck(string2, string);
            fileParam.setNeedCheck(false);
        }
        if ((fileArray = this.getExistedFiles((File)fileArray, string)) == null) {
            Log.e((String)TAG, (String)"beforeWriteCheck  existedFiles is null");
            return;
        }
        if (fileArray.length == 0) {
            LogWrite logWrite = this;
            Log.i((String)TAG, (String)"beforeWriteCheck  Path Exist -- No File -- Create File");
            fileParam.setNeedCheck(false);
            logWrite.createNewLogFile(fileParam, logWrite.makeLogFileName(string), string);
        } else {
            try {
                Arrays.sort(fileArray, new FileComparator());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)TAG, (String)"beforeWriteCheck Arrays sort IllegalArgumentException");
            }
            fileParam.setFileName(fileArray[fileArray.length - 1].getName());
        }
    }

    private void creatFolder(String string) {
        File file;
        File file2 = file;
        if (!new File(string).exists()) {
            boolean bl = false;
            try {
                bl = file2.mkdirs();
            }
            catch (SecurityException securityException) {
                Log.e((String)TAG, (String)"createFolder SecurityException:");
            }
            if (!bl) {
                Log.e((String)TAG, (String)"createFolder fail");
                return;
            }
            Log.i((String)TAG, (String)"createFolder success");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void createNewLogFile(FileParam var1_1, String var2_2, String var3_3) throws IOException {
        block15: {
            v0 = var1_1;
            var4_4 = v0.getFileDirPath();
            var5_5 /* !! */  = v0.getWriter();
            if (TextUtils.isEmpty((CharSequence)var4_4) || TextUtils.isEmpty((CharSequence)var2_2)) break block15;
            var6_6 = v1;
            v1 = new File(var4_4, var2_2);
            var7_7 = v2;
            v2 = new FileOutputStream(var6_6, true);
            var8_8 = LogWrite.class;
            synchronized (LogWrite.class) {
                block14: {
                    if (var5_5 /* !! */  != null) {
                        try {
                            var5_5 /* !! */ .close();
                        }
                        catch (IOException v3) {
                            Log.e((String)"LogWrite", (String)"createNewLogFile IOException");
                        }
                    }
lbl20:
                    // 5 sources

                    v4 = var1_1;
                    v5 = v4;
                    v6 = v4;
                    {
                        catch (Throwable v7) {
                            // ** MonitorExit[var8_8] (shouldn't be in output)
                            throw v7;
                        }
                    }
                    var5_5 /* !! */  = v8;
                    v8 = new OutputStreamWriter((OutputStream)var7_7, StandardCharsets.UTF_8);
                    v5.setWriter(new BufferedWriter(var5_5 /* !! */ ));
                    if (!v6.isNeedCheck()) ** GOTO lbl33
                    this.filesNumAndUsefulCheck(var4_4, var3_3);
lbl33:
                    // 2 sources

                    var1_1.setFileName(var2_2);
                    LogWrite.enableWriteLog = true;
                    if (!var3_3.equals("location")) break block14;
                    if (var6_6.length() != 0L) break block14;
                    v9 = var1_1;
                    v10 = v9;
                    v9.getWriter().append(LogWrite.getCSVFileHeader());
                    v10.getWriter().flush();
                }
                Log.i((String)"LogWrite", (String)("createNewLogFile:File creation complete logFileName:" + var2_2));
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return;
                ** GOTO lbl20
            }
        }
        Log.e((String)"LogWrite", (String)"createNewLogFile Exception");
    }

    private static String getCSVFileHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("writeTime");
        stringBuilder.append(",");
        stringBuilder.append("transId");
        stringBuilder.append(",");
        stringBuilder.append("provider");
        stringBuilder.append(",");
        stringBuilder.append("latitude");
        stringBuilder.append(",");
        stringBuilder.append("longitude");
        stringBuilder.append(",");
        stringBuilder.append("accuracy");
        stringBuilder.append(",");
        stringBuilder.append("locationTime");
        stringBuilder.append(",");
        stringBuilder.append("speed");
        stringBuilder.append(",");
        stringBuilder.append("sessionId");
        stringBuilder.append(",");
        stringBuilder.append("sourceType");
        stringBuilder.append(",");
        stringBuilder.append("locateType");
        stringBuilder.append(",");
        stringBuilder.append("vendorType");
        stringBuilder.append(",");
        stringBuilder.append("src");
        stringBuilder.append(",");
        stringBuilder.append("switchHd");
        stringBuilder.append(",");
        stringBuilder.append("floor");
        stringBuilder.append(",");
        stringBuilder.append("floorAcc");
        stringBuilder.append(",");
        stringBuilder.append("buildingId");
        stringBuilder.append(System.lineSeparator());
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void filesNumAndUsefulCheck(String var1_2, String var2_3) {
        block20: {
            block21: {
                block19: {
                    var3_6 = v0;
                    v0 = new File((String)var1_2);
                    var1_2 = this.getExistedFiles(var3_6, var2_3);
                    if (var1_2 == null || var1_2.length <= 0) break block20;
                    try {
                        Arrays.sort(var1_2, new FileComparator());
                    }
                    catch (IllegalArgumentException v1) {
                        Log.e((String)"LogWrite", (String)"Arrays sort IllegalArgumentException");
                    }
                    v2 = this;
                    v3 = var1_2;
                    v4 = var1_2.length;
                    var3_7 = v2.getFileSavaTimeMill(v3[v4 - 1]);
                    v5 = System.currentTimeMillis();
                    if (v5 - var3_7 <= this.maxFileExpired) break block19;
                    v6 = this;
                    v7 = var1_2;
                    Log.i((String)"LogWrite", (String)"filesNumAndUsefulCheck:The latest saved files are more than maxFileExpired delete all files");
                    v6.deleteFiles(v7, -1);
                    break block21;
                }
                ** try [egrp 7[TRYBLOCK] [14, 13 : 93->95)] { 
lbl32:
                // 4 sources

                for (var2_4 = var1_2.length - 1; var2_4 >= 0; --var2_4) {
                    var3_7 = this.getFileSavaTimeMill(var1_2[var2_4]);
                    v8 = System.currentTimeMillis();
                    if (v8 - var3_7 <= this.maxFileExpired) continue;
                    Log.i((String)"LogWrite", (String)("filesNumAndUsefulCheck:delete the exceed file:" + var1_2[var2_4].getName()));
                    if (var1_2[var2_4].delete()) continue;
                    try {
                        Log.e((String)"LogWrite", (String)"filesNumAndUsefulCheck:delete the exceed file result false");
                    }
lbl48:
                    // 13 sources

                    catch (Exception v9) {
                        Log.i((String)"LogWrite", (String)"filesNumAndUsefulCheck:Exception");
                        break;
                    }
lbl52:
                    // 13 sources

                    catch (SecurityException v10) {
                        Log.i((String)"LogWrite", (String)"filesNumAndUsefulCheck:SecurityException");
                        break;
                    }
                    continue;
                }
            }
            var2_5 = this.maxFileNum;
            if (var1_2.length >= var2_5) {
                var0_1 = var1_2.length - var2_5;
                Log.i((String)"LogWrite", (String)"createNewLogFile Exceeded the maximum number of files--Delete the earliest file.");
                this.deleteFiles(var1_2, var0_1);
            }
        }
    }

    private long getFileSavaTimeMill(File file) throws SecurityException {
        return file.lastModified();
    }

    /*
     * Exception decompiling
     */
    private boolean deleteFiles(File[] var1_3, int var2_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 61->67)] java.lang.SecurityException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openLogFile(FileParam fileParam) throws IOException {
        FileParam fileParam2 = fileParam;
        Object object = fileParam2.getFileDirPath();
        Object object2 = fileParam2.getFileName();
        if (fileParam.getWriter() == null) {
            if (!TextUtils.isEmpty((CharSequence)object) && !TextUtils.isEmpty((CharSequence)object2)) {
                FileOutputStream fileOutputStream;
                File file;
                File file2 = file;
                file = new File((String)object, (String)object2);
                object = fileOutputStream;
                fileOutputStream = new FileOutputStream(file2, true);
                object2 = LogWrite.class;
                synchronized (object2) {
                    fileParam.setWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)object, StandardCharsets.UTF_8)));
                    // ** MonitorExit[com.huawei.location.lite.common.log.logwrite.LogWrite.class] (shouldn't be in output)
                }
            } else {
                Log.e((String)TAG, (String)"openLogFile Exception");
                return;
            }
        }
    }

    private String makeLogFileName(String object) {
        Object object2 = ".log";
        if (((String)object).equals("location")) {
            object2 = ".csv";
        }
        object = Calendar.getInstance().getTime();
        return "Location." + new SimpleDateFormat(PATTERN_ONE, Locale.getDefault()).format((Date)object) + (String)object2;
    }

    private String getNow() {
        return DateUtil.formate(Calendar.getInstance().getTime(), PATTERN_TWO);
    }

    public void init(int n, String string, int n2, int n3) {
        if (n > 0) {
            this.maxFileSize = Math.min(n, 2);
            this.maxFileSize = this.maxFileSize * 1024 * 1024;
        } else {
            this.maxFileSize = 0x200000;
        }
        this.maxFileNum = n2 > 0 ? Math.min(n2, 20) : 20;
        if (n3 > 0) {
            long l;
            this.maxFileExpired = l = (long)Math.min(n3, 5);
            this.maxFileExpired = l * 86400000L;
        } else {
            this.maxFileExpired = 432000000L;
        }
        if (string != null) {
            this.logDirPath = string;
            LogWrite.setEnableWriteLog(true);
        } else {
            LogWrite.setEnableWriteLog(false);
        }
        Log.i((String)TAG, (String)"LogWrite init complete");
    }

    /*
     * Exception decompiling
     */
    public void writeToFile(AppLog var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 10[TRYBLOCK] [16 : 129->137)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        v0 = this;
        this = LogWrite.class;
        synchronized (LogWrite.class) {
            var1_1 = v0.fileInfoMap.entrySet().iterator();
lbl6:
            // 4 sources

            while (var1_1.hasNext()) {
                var2_2 = var1_1.next().getValue();
                if (var2_2 == null) continue;
                ** GOTO lbl14
            }
            ** GOTO lbl23
            {
                catch (Throwable v1) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    throw v1;
                }
lbl14:
                // 1 sources

                if (var2_2.getWriter() == null) ** GOTO lbl6
                try {
                    var2_2.getWriter().close();
                }
                catch (IOException v2) {}
                {
                    Log.e((String)"LogWrite", (String)"shutdown IOException");
                }
            }
            {
                var2_2.setWriter(null);
                ** GOTO lbl6
lbl23:
                // 1 sources

                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
        }
    }

    public boolean permissionCheck(String string) {
        if (!(string.startsWith("/data/user/") || string.startsWith("/data/data/") || string.startsWith("data/data/") || string.startsWith("data/user/"))) {
            if (!PermissionUtil.checkSelfPermission(ContextUtil.getContext(), "android.permission.READ_EXTERNAL_STORAGE")) {
                Log.e((String)TAG, (String)"READ_EXTERNAL_PERMISSION Permission check unPass");
                return false;
            }
            if (!PermissionUtil.checkSelfPermission(ContextUtil.getContext(), "android.permission.WRITE_EXTERNAL_STORAGE")) {
                Log.e((String)TAG, (String)"WRITE_EXTERNAL_PERMISSION Permission check unPass");
                return false;
            }
        }
        return true;
    }

    private static class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FileComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            return (int)(file.lastModified() - file2.lastModified());
        }
    }
}

