/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.log.logwrite;

import android.text.TextUtils;
import android.util.Log;
import com.huawei.location.lite.common.log.logwrite.AppLog;
import com.huawei.location.lite.common.log.logwrite.LogWrite;
import com.huawei.location.lite.common.log.logwrite.LogWriteParam;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public final class LogWriteManager {
    private static final String TAG = "LogWriteManager";
    private static final String THREAD_NAME = "LogWriteThread";
    private static final int MAX_WAIT_TIMEOUT = 60;
    private static final Object OBJECT_LOCK = new Object();
    private static LogWriteManager mInstance = new LogWriteManager();
    private volatile String logPath;
    private int perFileSize = -1;
    private int fileMaxNum = -1;
    private int fileExpiredTime = -1;
    private final BlockingQueue<AppLog> blockingQueue;
    private WriteWorker worker;
    private boolean isStarted;
    private boolean isInit;
    private LogWrite logWrite;

    private LogWriteManager() {
        WriteWorker writeWorker;
        ArrayBlockingQueue<AppLog> arrayBlockingQueue;
        Object object = arrayBlockingQueue;
        arrayBlockingQueue = new ArrayBlockingQueue<AppLog>(256);
        this.blockingQueue = object;
        object = writeWorker;
        writeWorker = new WriteWorker();
        this.worker = object;
        this.isStarted = false;
        this.isInit = false;
        Log.i((String)TAG, (String)"LogWriteManager onCreate");
    }

    public static LogWriteManager getInstance() {
        return mInstance;
    }

    private void start() {
        block4: {
            if (this.isStarted) break block4;
            try {
                LogWriteManager logWriteManager = this;
                logWriteManager.isStarted = true;
                logWriteManager.worker.setName(THREAD_NAME);
                logWriteManager.worker.start();
            }
            catch (Exception exception) {
                LogWriteManager logWriteManager = this;
                Log.i((String)TAG, (String)"worker Exception");
                logWriteManager.isStarted = false;
                logWriteManager.isInit = false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                LogWriteManager logWriteManager = this;
                Log.i((String)TAG, (String)"worker IllegalThreadStateException");
                logWriteManager.isStarted = false;
                logWriteManager.isInit = false;
            }
        }
    }

    private void write(LogWriteManager logWriteManager) throws InterruptedException {
        Object object = TimeUnit.SECONDS;
        object = logWriteManager.blockingQueue.poll(60L, (TimeUnit)((Object)object));
        LogWrite logWrite = ((LogWriteManager)((Object)appLog)).logWrite;
        if (logWrite != null) {
            if (object != null) {
                logWrite.writeToFile((AppLog)object);
            } else {
                LogWriteManager logWriteManager2 = appLog;
                logWrite.shutdown();
                AppLog appLog = logWriteManager.blockingQueue.take();
                logWriteManager2.logWrite.writeToFile(appLog);
            }
        }
    }

    static /* synthetic */ boolean access$602(LogWriteManager logWriteManager, boolean bl) {
        logWriteManager.isStarted = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void init(LogWriteParam var1_1) {
        var2_2 = LogWriteManager.OBJECT_LOCK;
        synchronized (var2_2) {
            block8: {
                if (this.isInit) ** GOTO lbl28
                v1 = var1_1;
                Log.i((String)"LogWriteManager", (String)"first init");
                if (!TextUtils.isEmpty((CharSequence)v1.getLogPath())) ** GOTO lbl20
                v2 = var2_2;
                Log.i((String)"LogWriteManager", (String)"logPath is empty");
                // ** MonitorExit[v2] (shouldn't be in output)
                return;
lbl20:
                // 1 sources

                this.logPath = var1_1.getLogPath();
                this.perFileSize = var1_1.getFileSize();
                this.fileMaxNum = var1_1.getFileNum();
                this.fileExpiredTime = var1_1.getFileExpiredTime();
                this.logWrite = new LogWrite();
                this.start();
                this.isInit = true;
                break block8;
lbl28:
                // 1 sources

                Log.i((String)"LogWriteManager", (String)"already init");
            }
            return;
        }
    }

    public void stop() {
        LogWriteManager logWriteManager;
        AppLog appLog;
        ((LogWriteManager)((Object)appLog2)).isStarted = false;
        AppLog appLog2 = appLog;
        appLog = new AppLog("I", TAG, "printWorker is stop", null);
        logWriteManager.appendLog(appLog2);
    }

    public boolean appendLog(AppLog appLog) {
        return this.blockingQueue.offer(appLog);
    }

    public String getLogPath() {
        return this.logPath;
    }

    class WriteWorker
    extends Thread {
        WriteWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = LogWriteManager.this;
            Object object2 = OBJECT_LOCK;
            synchronized (object2) {
                LogWriteManager logWriteManager = object;
                int n = logWriteManager.perFileSize;
                String string = logWriteManager.logPath;
                int n2 = logWriteManager.fileMaxNum;
                int n3 = logWriteManager.fileExpiredTime;
                LogWriteManager.this.logWrite.init(n, string, n2, n3);
            }
            while (((LogWriteManager)object).isStarted) {
                try {
                    LogWriteManager.this.write((LogWriteManager)object);
                }
                catch (Error error) {
                    Log.i((String)LogWriteManager.TAG, (String)"PrintWoker Error");
                    break;
                }
                catch (Exception exception) {
                    Log.i((String)LogWriteManager.TAG, (String)"PrintWoker IllegalMonitorStateException");
                    break;
                }
                catch (InterruptedException interruptedException) {
                    Log.i((String)LogWriteManager.TAG, (String)"PrintWoker InterruptedException");
                    break;
                }
            }
            Log.i((String)LogWriteManager.TAG, (String)"PrintWoker end.");
            if (LogWriteManager.this.logWrite != null) {
                AppLog appLog;
                WriteWorker writeWorker = this;
                object = appLog;
                appLog = new AppLog("I", LogWriteManager.TAG, "PrintWoker end.", "log", null);
                writeWorker.LogWriteManager.this.logWrite.writeToFile((AppLog)object);
                writeWorker.LogWriteManager.this.logWrite.shutdown();
            }
            LogWriteManager.access$602(LogWriteManager.this, false);
        }
    }
}

