/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.plug;

import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.plug.ProductId;
import com.huawei.location.lite.common.plug.ProductPlugPath;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PluginServiceLoader<S> {
    private static final String TAG = "PluginServiceLoader";
    private final Class<S> service;
    private LinkedHashMap<String, S> providers = new LinkedHashMap();
    private LinkedHashMap<Integer, List<String>> plugins = new LinkedHashMap();

    public static <S> PluginServiceLoader<S> load(Class<S> clazz) {
        return new PluginServiceLoader<S>(clazz);
    }

    private PluginServiceLoader(Class<S> clazz) {
        this.service = Objects.requireNonNull(clazz, "Service interface cannot be null");
        this.reload();
    }

    private List<S> loaderServiceProvider(int n) {
        ArrayList<S> arrayList;
        ArrayList<S> arrayList2 = arrayList;
        arrayList = new ArrayList<S>();
        List<String> list = this.plugins.get(n);
        if (list != null && !list.isEmpty()) {
            list = list.iterator();
            while (list.hasNext()) {
                arrayList2.add(this.loaderServiceProvider((String)list.next()));
            }
        }
        return arrayList2;
    }

    private S loaderServiceProvider(String string) {
        Object object = this.providers.get(string);
        if (object != null) {
            return object;
        }
        object = null;
        try {
            object = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLocation.e(TAG, "Provider " + string + " not found");
        }
        if (!this.service.isAssignableFrom((Class<?>)object)) {
            LogLocation.e(TAG, "Provider " + string + " not a subtype");
        }
        S s = null;
        if (object != null) {
            try {
                s = this.service.cast(((Class)object).newInstance());
            }
            catch (InstantiationException instantiationException) {
                LogLocation.e(TAG, "Provider" + string + " InstantiationException ");
            }
            catch (IllegalAccessException illegalAccessException) {
                LogLocation.e(TAG, "Provider" + string + " IllegalAccessException ");
            }
        }
        this.providers.put(string, s);
        return s;
    }

    private void parserProductId() {
        if (!this.plugins.isEmpty()) {
            return;
        }
        Field[] fieldArray = ProductId.class.getDeclaredFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            block13: {
                block14: {
                    Object object = fieldArray[i];
                    String[] stringArray = ((Field)object).getAnnotation(ProductPlugPath.class);
                    String string = ((Field)object).getName();
                    if (!(((Field)object).get(string) instanceof Integer) || stringArray == null) break block13;
                    stringArray = stringArray.paths();
                    if (stringArray == null) break block14;
                    if (stringArray.length == 0) break block14;
                    if (!(((Field)object).get(string) instanceof Integer)) continue;
                    LinkedHashMap<Integer, List<String>> linkedHashMap = this.plugins;
                    String[] stringArray2 = stringArray;
                    object = (Integer)((Field)object).get(string);
                    try {
                        linkedHashMap.put((Integer)object, Arrays.asList(stringArray2));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        LogLocation.e(TAG, "parserProductId");
                        break;
                    }
                    continue;
                }
                return;
            }
            return;
        }
    }

    public List<S> loadService(int n) {
        this.parserProductId();
        return this.loaderServiceProvider(n);
    }

    public Set<Integer> getPlugins() {
        if (this.plugins.isEmpty()) {
            this.parserProductId();
        }
        return this.plugins.keySet();
    }

    public final void reload() {
        PluginServiceLoader pluginServiceLoader = this;
        pluginServiceLoader.providers.clear();
        pluginServiceLoader.plugins.clear();
    }
}

