/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.report;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.huawei.location.lite.common.agc.AGCManager;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.util.APKUtil;
import com.huawei.location.lite.common.util.DeviceInfoUtil;
import com.huawei.location.lite.common.util.NetworkUtil;
import com.huawei.location.lite.common.util.ROMUtil;
import com.huawei.location.lite.common.util.SDKComponentType;
import com.huawei.location.lite.common.util.TelephonyUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ReportBuilder {
    protected static final String CP_SDK_TYPE = "1";
    protected static final String OPEN_SDK_TYPE = "2";
    protected static final String CLOUD_FENCE_TYPE = "3";
    protected static final String FULL_SDK_TYPE = "4";
    private static final String ROM_NOG_ABROAD = "1001";
    private static final String ROM_G_ABROAD = "1002";
    private static final String ROM_CN_HW = "1003";
    private static final String ROM_NO_HW = "2001";
    private static final String ROM_HW_PAD = "1100";
    private static final String ROM_HW_WATCH = "1200";
    protected LinkedHashMap<String, String> linkedHashMap;
    private String eventId;
    private long callTime;

    public ReportBuilder() {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap = new SyncLinkedHashMap<String, String>();
        reportBuilder.setBrand();
        reportBuilder.setManufacturer();
        reportBuilder.setCallTime();
        reportBuilder.setWifiEnable();
        reportBuilder.setService("hwLocation");
        reportBuilder.setNetworkType(NetworkUtil.getNetworkState());
        reportBuilder.setNetworkValid(NetworkUtil.isCurActiveNetInfoValid(ContextUtil.getContext()));
        reportBuilder.setMCC(TelephonyUtil.getMcc());
        reportBuilder.setLocationSdkType(FULL_SDK_TYPE);
        reportBuilder.setLBSVersionCode(APKUtil.getLBSVersionCode());
        reportBuilder.setRomType(reportBuilder.getRomType());
        reportBuilder.setPackage(ContextUtil.getContext().getPackageName());
        reportBuilder.setVersion(String.valueOf(212000300));
        if (SDKComponentType.getComponentType() == 100) {
            this.setAppID(AGCManager.getInstance().getAppId());
        }
    }

    public ReportBuilder setNetworkValid(boolean bl) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("netWorkValid", "" + bl);
        return reportBuilder;
    }

    public final ReportBuilder setBrand() {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("brand", DeviceInfoUtil.getBrand());
        return reportBuilder;
    }

    public final ReportBuilder setManufacturer() {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("pub_mfc", DeviceInfoUtil.getManufacturer());
        return reportBuilder;
    }

    public final String getRomType() {
        return ROMUtil.isHuaweiPlatformDevice() ? (DeviceInfoUtil.getDeviceFeature(ContextUtil.getContext()) == 1 ? ROM_HW_PAD : (DeviceInfoUtil.isHuaweiWatch() ? ROM_HW_WATCH : (ROMUtil.isChineseRom() ? ROM_CN_HW : (ROMUtil.isGmsRom() ? ROM_G_ABROAD : ROM_NOG_ABROAD)))) : ROM_NO_HW;
    }

    public final ReportBuilder setWifiEnable() {
        if (!TelephonyUtil.checkWifiIsEnable(ContextUtil.getContext())) {
            this.linkedHashMap.put("wifiEnable", "false");
        }
        return this;
    }

    public final ReportBuilder setWLANScan() {
        if (!TelephonyUtil.checkWLANScan(ContextUtil.getContext())) {
            this.linkedHashMap.put("WLANScan", "false");
        }
        return this;
    }

    protected final ReportBuilder setLBSVersionCode(long l) {
        StringBuilder stringBuilder;
        ReportBuilder reportBuilder = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        reportBuilder.linkedHashMap.put("lbs_version", stringBuilder.append(l).append("").toString());
        return reportBuilder;
    }

    public final ReportBuilder setPackage(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("package", string);
        return reportBuilder;
    }

    public final ReportBuilder setSrc(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("src", string);
        return reportBuilder;
    }

    public final ReportBuilder setAppID(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("appid", string);
        return reportBuilder;
    }

    public final ReportBuilder setVersion(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("version", string);
        return reportBuilder;
    }

    public final ReportBuilder setModuleName(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("module", string);
        return reportBuilder;
    }

    public final ReportBuilder setService(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("service", string);
        return reportBuilder;
    }

    public final ReportBuilder setMCC(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("MCC", string);
        return reportBuilder;
    }

    public String getMcc() {
        LinkedHashMap<String, String> linkedHashMap = ((ReportBuilder)((Object)linkedHashMap)).linkedHashMap;
        return linkedHashMap == null ? "" : (String)linkedHashMap.get("MCC");
    }

    public final ReportBuilder setLocationEnable(boolean bl) {
        if (!bl) {
            this.linkedHashMap.put("locEnable", "false");
        }
        return this;
    }

    public final ReportBuilder setApiName(String string) {
        this.linkedHashMap.put("apiName", string);
        this.eventId = string;
        return this;
    }

    public String getEventId() {
        return this.eventId;
    }

    public final ReportBuilder setResult(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("result", string);
        return reportBuilder;
    }

    public final ReportBuilder setCallTime() {
        long l = System.currentTimeMillis();
        this.linkedHashMap.put("callTime", String.valueOf(l));
        this.callTime = l;
        return this;
    }

    public final ReportBuilder setCostTime() {
        long l = System.currentTimeMillis() - this.callTime;
        if (l <= 0L) {
            l = 0L;
        }
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("costTime", String.valueOf(l));
        return reportBuilder;
    }

    public final ReportBuilder setTransactionID(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("transId", string);
        return reportBuilder;
    }

    public final ReportBuilder setOperator(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("operator", string);
        return reportBuilder;
    }

    public final ReportBuilder setNetworkType(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("networkType", string);
        return reportBuilder;
    }

    public final ReportBuilder setExtParam(@NonNull String string, @NonNull String string2) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put(string, string2);
        return reportBuilder;
    }

    public final ReportBuilder setExt(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("ext", string);
        return reportBuilder;
    }

    public final ReportBuilder setErrorCode(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("errorCode", string);
        return reportBuilder;
    }

    public final ReportBuilder setErrorMessage(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("errorMessage", string);
        return reportBuilder;
    }

    public final ReportBuilder setRomType(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("rom_type", string);
        return reportBuilder;
    }

    public final ReportBuilder setTag(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("tag", string);
        return reportBuilder;
    }

    public final ReportBuilder setCpAppVersion(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("cpAppVersion", string);
        return reportBuilder;
    }

    public final ReportBuilder setLocationSdkType(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("lcSdkType", string);
        return reportBuilder;
    }

    public final ReportBuilder setRequestUrl(String string) {
        ReportBuilder reportBuilder = this;
        reportBuilder.linkedHashMap.put("requestUrl", string);
        return reportBuilder;
    }

    public LinkedHashMap<String, String> build() {
        return this.linkedHashMap;
    }

    private static class SyncLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final Object SYNC_LOCK = new Object();

        private SyncLinkedHashMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresApi(api=24)
        @Nullable
        public V putIfAbsent(K k, V v) {
            SyncLinkedHashMap syncLinkedHashMap = object;
            Object object = SYNC_LOCK;
            synchronized (object) {
                return super.putIfAbsent(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            SyncLinkedHashMap syncLinkedHashMap = object;
            Object object = SYNC_LOCK;
            synchronized (object) {
                return super.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public V put(K k, V v) {
            SyncLinkedHashMap syncLinkedHashMap = object;
            Object object = SYNC_LOCK;
            synchronized (object) {
                return super.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(@NonNull Map<? extends K, ? extends V> map) {
            Object object = SYNC_LOCK;
            synchronized (object) {
                super.putAll(map);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            SyncLinkedHashMap syncLinkedHashMap = object2;
            Object object2 = SYNC_LOCK;
            synchronized (object2) {
                return super.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresApi(api=24)
        public V getOrDefault(Object object, V v) {
            SyncLinkedHashMap syncLinkedHashMap = object2;
            Object object2 = SYNC_LOCK;
            synchronized (object2) {
                return super.getOrDefault(object, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(@Nullable Object object, @Nullable Object object2) {
            SyncLinkedHashMap syncLinkedHashMap = object3;
            Object object3 = SYNC_LOCK;
            synchronized (object3) {
                return super.remove(object, object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = SYNC_LOCK;
            synchronized (object) {
                super.clear();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public V remove(@Nullable Object object) {
            SyncLinkedHashMap syncLinkedHashMap = object2;
            Object object2 = SYNC_LOCK;
            synchronized (object2) {
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            SyncLinkedHashMap syncLinkedHashMap = object;
            Object object = SYNC_LOCK;
            synchronized (object) {
                return super.entrySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        public String toString() {
            SyncLinkedHashMap syncLinkedHashMap = object;
            Object object = SYNC_LOCK;
            synchronized (object) {
                return super.toString();
            }
        }
    }
}

