/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.report;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.huawei.hms.framework.network.grs.GrsApp;
import com.huawei.hms.hatool.HmsHiAnalyticsUtils;
import com.huawei.location.lite.common.agc.AGCManager;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.grs.LocationNlpGrsHelper;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.report.ReportBuilder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tracker {
    private static volatile Tracker instance;
    private static final String TAG = "LocationTracker";
    private static final String LOCATION_KIT = "Location-Full-";
    private static final int CACHE_SIZE = 100;
    private static final long DELAY_TIME = 3600000L;
    private static final int MESSAGE_DEFAULT = 1;
    private static final int MESSAGE_INIT = 2;
    private static final byte[] SYNC_LOCK;
    private AtomicBoolean isInitialized;
    private final Map<String, LinkedHashMap> maintenanceCacheEventId;
    private final Map<String, LinkedHashMap> operatjionCacheEventId;
    private volatile boolean reportTask;
    private LocationReportHandler reportHandler;

    private Tracker() {
        LocationReportHandler locationReportHandler;
        HandlerThread handlerThread;
        HashMap hashMap;
        HashMap hashMap2;
        AtomicBoolean atomicBoolean;
        Serializable serializable = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        this.isInitialized = serializable;
        serializable = hashMap2;
        hashMap2 = new HashMap(16, 0.85f);
        this.maintenanceCacheEventId = serializable;
        serializable = hashMap;
        hashMap = new HashMap(16, 0.85f);
        this.operatjionCacheEventId = serializable;
        this.reportTask = false;
        serializable = handlerThread;
        new HandlerThread("Location-Full-LocationTracker").start();
        LocationReportHandler locationReportHandler2 = locationReportHandler;
        locationReportHandler = new LocationReportHandler(serializable.getLooper());
        this.reportHandler = locationReportHandler2;
        LogLocation.i(TAG, "LocationTracker init");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Tracker getInstance() {
        if (instance != null) return instance;
        byte[] byArray = SYNC_LOCK;
        synchronized (SYNC_LOCK) {
            if (instance != null) return instance;
            instance = new Tracker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initHiAnalytics() {
        if (this.isInitialized.get()) {
            return;
        }
        String string = LocationNlpGrsHelper.getGrsHostAddress(GrsApp.getInstance().getIssueCountryCode(ContextUtil.getContext()), "HIANALYTICROUTE");
        LogLocation.d(TAG, "hiAnalyticsUrl:" + string);
        if (TextUtils.isEmpty((CharSequence)string)) {
            LogLocation.i(TAG, "initHiAnalytics  hiAnalyticsUrl is empty.");
            this.isInitialized.set(false);
            return;
        }
        LogLocation.i(TAG, "initHiAnalytics begin.");
        String string2 = AGCManager.getInstance().getAppId();
        HmsHiAnalyticsUtils.init((Context)ContextUtil.getContext(), (boolean)false, (boolean)false, (boolean)false, (String)string, (String)string2);
        if (HmsHiAnalyticsUtils.getInitFlag()) {
            this.isInitialized.set(true);
        }
        this.processUnreportedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean checkUninitializedAnalytics(int n, String string, LinkedHashMap<String, String> linkedHashMap) {
        if (this.isInitialized.get()) {
            return false;
        }
        LogLocation.d(TAG, "checkUninitializedAnalytics not initialized");
        if (n == 0) {
            Tracker tracker = this;
            Map<String, LinkedHashMap> map = tracker.operatjionCacheEventId;
            // MONITORENTER : map
            if (tracker.operatjionCacheEventId.size() > 100) {
                this.operatjionCacheEventId.clear();
                LogLocation.d(TAG, "out of size clear cache");
            }
            Map<String, LinkedHashMap> map2 = map;
            this.operatjionCacheEventId.put(this.encodeKey(string, n), linkedHashMap);
            // MONITOREXIT : map2
        } else if (1 == n) {
            Tracker tracker = this;
            Map<String, LinkedHashMap> map = tracker.maintenanceCacheEventId;
            // MONITORENTER : map
            if (tracker.maintenanceCacheEventId.size() > 100) {
                this.maintenanceCacheEventId.clear();
                LogLocation.d(TAG, "out of size clear cache");
            }
            Map<String, LinkedHashMap> map3 = map;
            this.maintenanceCacheEventId.put(this.encodeKey(string, n), linkedHashMap);
            // MONITOREXIT : map3
        } else {
            LogLocation.d(TAG, "onEvent type =" + n);
        }
        this.init();
        return true;
    }

    private String encodeKey(String string, int n) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return string + "|" + n + "|" + UUID.randomUUID().toString();
    }

    private String decodeKeyForEventId(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return string.split("\\|")[0];
    }

    private String decodeKeyForType(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return string.split("\\|")[1];
    }

    private void processUnreportedData() {
        Tracker tracker = this;
        tracker.processUnreportedDataUtil(tracker.operatjionCacheEventId);
        tracker.processUnreportedDataUtil(tracker.maintenanceCacheEventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processUnreportedDataUtil(Map<String, LinkedHashMap> map) {
        Map<String, LinkedHashMap> map2 = map;
        synchronized (map2) {
            if (!map2.isEmpty()) {
                for (Map.Entry<String, LinkedHashMap> entry : map.entrySet()) {
                    if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                        Tracker tracker = this;
                        int n = Integer.parseInt(this.decodeKeyForType(entry.getKey()));
                        tracker.onEvent(n, tracker.decodeKeyForEventId(entry.getKey()), entry.getValue());
                        continue;
                    }
                    LogLocation.e(TAG, "mapEntry.getKey() == null");
                }
                map.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void doReport() {
        LocationReportHandler locationReportHandler;
        if (!this.reportTask && (locationReportHandler = this.reportHandler) != null) {
            locationReportHandler.sendEmptyMessageDelayed(1, 3600000L);
            this.reportTask = true;
        }
    }

    static /* synthetic */ boolean access$002(Tracker tracker, boolean bl) {
        tracker.reportTask = bl;
        return bl;
    }

    static {
        SYNC_LOCK = new byte[0];
    }

    public void init() {
        if (this.isInitialized.get()) {
            return;
        }
        this.reportHandler.sendEmptyMessage(2);
    }

    public void onMaintEvent(ReportBuilder object) {
        Tracker tracker = string;
        ReportBuilder reportBuilder = object;
        LogLocation.i(TAG, "onMaintEvent:" + ((ReportBuilder)object).build().toString());
        String string = reportBuilder.getEventId();
        object = reportBuilder.build();
        tracker.onEvent(1, string, (LinkedHashMap<String, String>)object);
        tracker.doReport();
    }

    public void onOperationEvent(ReportBuilder object) {
        Tracker tracker = string;
        ReportBuilder reportBuilder = object;
        String string = reportBuilder.getEventId();
        object = reportBuilder.build();
        tracker.onEvent(0, string, (LinkedHashMap<String, String>)object);
    }

    public synchronized void onEvent(int n, String string, LinkedHashMap<String, String> linkedHashMap) {
        if (this.checkUninitializedAnalytics(n, string, linkedHashMap)) {
            return;
        }
        if (!HmsHiAnalyticsUtils.getInitFlag()) {
            LogLocation.d(TAG, "onEvent HA init is false");
            return;
        }
        LogLocation.d(TAG, "analyticsInstance.onEvent");
        HmsHiAnalyticsUtils.onEvent((int)n, (String)string, linkedHashMap);
    }

    public void onReport() {
        if (HmsHiAnalyticsUtils.getInitFlag()) {
            LogLocation.d(TAG, "analyticsInstance.onReport");
            HmsHiAnalyticsUtils.onReport();
        }
    }

    private class LocationReportHandler
    extends Handler {
        LocationReportHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            int n = message.what;
            if (n != 1) {
                if (n == 2) {
                    Tracker.this.initHiAnalytics();
                }
            } else {
                LocationReportHandler locationReportHandler = this;
                LogLocation.d(Tracker.TAG, "handleMessage case 1, begin to report");
                locationReportHandler.Tracker.this.onReport();
                Tracker.access$002(locationReportHandler.Tracker.this, false);
            }
        }
    }
}

