/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.LruCache;
import androidx.annotation.NonNull;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.android.receiver.PackageOperateCallback;
import com.huawei.location.lite.common.android.receiver.PackageReceiver;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.CollectionsUtils;
import com.huawei.secure.android.common.util.SafeString;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class APKUtil {
    private static final String TAG = "APKUtil";
    private static final String LBS_PKG_NAME = "com.huawei.lbs";
    private static final String AUTHORITIES = "content://com.huawei.hms.servicemanager";
    private static final String METHOD_GET_AAID = "getAAID";
    private static final String KEY_AAID = "AAID";
    private static String aaid;
    private static LruCache<String, ApkInfo> apkInfoLruCache;

    public static int getTargetSdkVersion(String string) {
        return APKUtil.getApkInfo((String)string, (int)16384).targetSdkVersion;
    }

    public static boolean isSystemApplication(String string) {
        return (APKUtil.getApkInfo((String)string, (int)16384).applicationFlag & 1) != 0;
    }

    public static synchronized String getAAID() {
        block4: {
            if (TextUtils.isEmpty((CharSequence)aaid)) {
                Bundle bundle = ContextUtil.getHMSContext().getContentResolver().call(Uri.parse((String)AUTHORITIES), METHOD_GET_AAID, null, null);
                if (bundle == null) break block4;
                try {
                    aaid = bundle.getString(KEY_AAID);
                }
                catch (Exception exception) {
                    LogLocation.d(TAG, "getAAID Exception");
                }
            }
        }
        LogLocation.d(TAG, "getAAID:" + aaid);
        return aaid;
    }

    public static Map<String, String> getPackageVersionCode(String string) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        long l = -1L;
        String string2 = "";
        if (string != null && !string.isEmpty()) {
            HashMap<String, String> hashMap3 = hashMap2;
            long l2 = APKUtil.getVersionCode(string);
            String string3 = APKUtil.getVersionName(string);
            LogLocation.d(TAG, string + ":versionName:" + string3 + ", versionCode:" + l2);
            hashMap3.put("versionCode", String.valueOf(l2));
            hashMap3.put("versionName", string3);
            return hashMap3;
        }
        HashMap<String, String> hashMap4 = hashMap2;
        hashMap4.put("versionCode", String.valueOf(l));
        hashMap4.put("versionName", string2);
        LogLocation.d(TAG, "packageName is empty, return -1");
        return hashMap4;
    }

    public static String getPackageVersionName(String string) {
        return APKUtil.getVersionName(string);
    }

    public static String getVersionName() {
        return APKUtil.getVersionName(ContextUtil.getContext().getPackageName());
    }

    public static int getUidByPackageName(String string) {
        int n = -1;
        if (string != null && !string.isEmpty()) {
            return APKUtil.getApkInfo((String)string, (int)1).uid;
        }
        LogLocation.d(TAG, "packageName is empty, return -1");
        return n;
    }

    public static String getAppName(Context context) {
        if (context == null) {
            return "";
        }
        return context.getResources().getString(APKUtil.getApkInfo((String)context.getPackageName(), (int)16384).applicationLabelRes);
    }

    public static long getAppVersionCode(Context context) {
        if (context == null) {
            return -1L;
        }
        return APKUtil.getVersionCode(context.getPackageName());
    }

    public static long getThirdAppVersionCode(@NonNull String string) {
        return APKUtil.getVersionCode(string);
    }

    public static long getHMSVersionCode() {
        return APKUtil.getAppVersionCode(ContextUtil.getHMSContext());
    }

    public static long getLocationVersionCode() {
        return APKUtil.getAppVersionCode(ContextUtil.getContext());
    }

    public static long getLBSVersionCode() {
        return APKUtil.getThirdAppVersionCode(LBS_PKG_NAME);
    }

    private static long getVersionCode(String string) {
        return APKUtil.getApkInfo((String)string, (int)16384).versionCode;
    }

    private static String getVersionName(String string) {
        return APKUtil.getApkInfo((String)string, (int)16384).versionName;
    }

    public static String getSignatureForPkgName(String string) {
        return APKUtil.getApkInfo((String)string, (int)64).defSecretSignature;
    }

    private static String getSignature(Signature[] signatureArray) {
        if (CollectionsUtils.isEmpty(signatureArray)) {
            LogLocation.d(TAG, "signatures is empty!");
            return null;
        }
        try {
            return APKUtil.getSignatureString(signatureArray[0]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LogLocation.d(TAG, "NoSuchAlgorithmException!");
            return null;
        }
    }

    private static String getSignatureString(Signature object) throws NoSuchAlgorithmException {
        StringBuilder stringBuilder;
        byte[] byArray = MessageDigest.getInstance("SHA256").digest(object.toByteArray());
        object = byArray;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(SafeString.substring((String)Integer.toHexString(object[i] & 0xFF | 0x100), (int)1, (int)3).toUpperCase(Locale.ROOT));
        }
        return stringBuilder2.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ApkInfo getApkInfo(String string, int n) {
        ApkInfo apkInfo;
        if (TextUtils.isEmpty((CharSequence)string)) {
            LogLocation.d(TAG, "package name is empty");
            return new ApkInfo();
        }
        if (apkInfoLruCache == null) {
            apkInfoLruCache = new LruCache(4);
        }
        if ((apkInfo = (ApkInfo)apkInfoLruCache.get((Object)string)) == null) return APKUtil.getPackageInfo(apkInfo, string, n);
        LogLocation.d(TAG, "getPackageInfo From Cache");
        if (n != 1) {
            if (n != 64) {
                if (n != 16384) return APKUtil.getPackageInfo(apkInfo, string, n);
                if (apkInfo.versionCode <= 0L) return APKUtil.getPackageInfo(apkInfo, string, n);
                return apkInfo;
            }
            if (TextUtils.isEmpty((CharSequence)apkInfo.defSecretSignature)) return APKUtil.getPackageInfo(apkInfo, string, n);
            return apkInfo;
        }
        if (apkInfo.uid <= 0) return APKUtil.getPackageInfo(apkInfo, string, n);
        return apkInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ApkInfo getPackageInfo(ApkInfo apkInfo, String string, int n) {
        PackageManager packageManager = ContextUtil.getContext().getPackageManager();
        if (apkInfo == null) {
            ApkInfo apkInfo2;
            apkInfo = apkInfo2;
            apkInfo2 = new ApkInfo();
        }
        try {
            block11: {
                block10: {
                    LogLocation.d(TAG, "getPackageInfo From PackageManager");
                    packageManager = packageManager.getPackageInfo(string, n);
                    if (packageManager == null) {
                        return apkInfo;
                    }
                    if (n == 1) break block10;
                    if (n != 64) {
                        if (n == 16384) {
                            apkInfo.versionName = packageManager.versionName;
                            long l = Build.VERSION.SDK_INT >= 28 ? packageManager.getLongVersionCode() : (long)packageManager.versionCode;
                            ApkInfo apkInfo3 = apkInfo;
                            apkInfo.versionCode = l;
                            packageManager = packageManager.applicationInfo;
                            apkInfo3.targetSdkVersion = packageManager.targetSdkVersion;
                            apkInfo3.applicationLabelRes = packageManager.labelRes;
                            apkInfo3.applicationFlag = packageManager.flags;
                        }
                        break block11;
                    } else {
                        Signature signature = !CollectionsUtils.isEmpty(packageManager.signatures) ? packageManager.signatures[0] : null;
                        apkInfo.signature = signature;
                        apkInfo.defSecretSignature = APKUtil.getSignature(packageManager.signatures);
                    }
                    break block11;
                }
                apkInfo.uid = packageManager.applicationInfo.uid;
            }
            if (n == 64) return apkInfo;
            apkInfoLruCache.put((Object)string, (Object)apkInfo);
        }
        catch (Exception exception) {
            LogLocation.d(TAG, "Package  manager  has  died Exception");
            return apkInfo;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            LogLocation.d(TAG, "NameNotFoundException!");
        }
        return apkInfo;
    }

    private static void updateLruCache(String string) {
        if (apkInfoLruCache.get((Object)string) != null) {
            apkInfoLruCache.remove((Object)string);
        }
    }

    static {
        PackageReceiver.getInstance().registerCallback(new PackageOperateCallback(){

            @Override
            public void onRemoved(String string) {
                APKUtil.updateLruCache(string);
            }

            @Override
            public void onAdded(String string) {
            }

            @Override
            public void onReplaced(String string) {
                APKUtil.updateLruCache(string);
            }
        });
    }

    public static class ApkInfo {
        public long versionCode = -1L;
        public String versionName;
        public String defSecretSignature;
        public int uid;
        public int targetSdkVersion;
        public int applicationFlag;
        public int applicationLabelRes;
        public Signature signature;
    }
}

