/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.content.Context;
import android.content.pm.FeatureInfo;
import android.os.Build;
import android.text.TextUtils;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.ROMUtil;
import com.huawei.location.lite.common.util.SystemPropertiesUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeviceInfoUtil {
    private static final String TAG = "DeviceInfoUtil";
    public static final int DEVICE_TYPE_UNKNOWN = -1;
    public static final int DEVICE_TYPE_HANDSET = 0;
    public static final int DEVICE_TYPE_PAD = 1;
    public static final int DEVICE_TYPE_WATCH = 2;
    public static final int DEVICE_TYPE_KID_WATCH = 3;
    public static final int DEVICE_TYPE_TV = 4;
    public static final int DEVICE_TYPE_MOBILE_TV = 5;
    public static final int DEVICE_TYPE_GLASS = 6;
    public static final int DEVICE_TYPE_EARPHONE = 7;
    public static final int DEVICE_TYPE_CAR = 8;
    private static final String FEATURE_HUAWEI = "com.huawei.software.features.";
    private static final String FEATURE_HONOR = "com.hihonor.software.features.";
    private static final String HUAWEI_FEATURE_DIALOG = "com.huawei.software.features.car.ux.activity.dialog";
    private static final String[] FEATURE_ANDROID;
    private static final String IS_EMULATOR = "1";
    private static final List<String> KID_CHARACTERS;
    private static final String USERTYPE_NORMAL = "normal";
    private static final String USERTYPE_KID = "kid";
    private static final DeviceType[] D_TYPE_LIST;
    private static volatile int deviceType;
    private static volatile String userType;
    private static volatile String pubMfc;
    private static volatile String brand;
    private static volatile String model;

    private DeviceInfoUtil() {
    }

    public static synchronized String getManufacturer() {
        if (!TextUtils.isEmpty((CharSequence)pubMfc)) {
            return pubMfc;
        }
        pubMfc = Build.MANUFACTURER;
        return pubMfc;
    }

    public static synchronized String getBrand() {
        if (!TextUtils.isEmpty((CharSequence)brand)) {
            return brand;
        }
        brand = Build.BRAND;
        return brand;
    }

    public static synchronized String getDeviceModel() {
        if (!TextUtils.isEmpty((CharSequence)model)) {
            return model;
        }
        model = Build.MODEL;
        return model;
    }

    public static boolean isBloomDevice() {
        return DeviceInfoUtil.getDeviceFeature(ContextUtil.getContext()) == 1 && TextUtils.equals((CharSequence)DeviceInfoUtil.getDeviceProperty(ContextUtil.getContext(), "userType"), (CharSequence)USERTYPE_KID);
    }

    public static boolean isWatch() {
        return DeviceInfoUtil.getDeviceFeature(ContextUtil.getContext()) == 2;
    }

    public static boolean isHuaweiWatch() {
        return DeviceInfoUtil.isWatch() && ROMUtil.isHuaweiPlatformDevice();
    }

    public static int getDeviceFeature(Context context) {
        if (deviceType != -1) {
            LogLocation.d(TAG, "get deviceType from cache: " + deviceType);
            return deviceType;
        }
        if (context == null) {
            LogLocation.d(TAG, "context is null.");
            return deviceType;
        }
        int n = DeviceInfoUtil.detectDeviceType(context);
        if (n != -1) {
            deviceType = n;
        }
        LogLocation.d(TAG, "Final DeviceType: " + deviceType);
        return n;
    }

    public static String getDeviceProperty(Context context, String string) {
        if (context == null) {
            LogLocation.d(TAG, "context is null.");
            return "";
        }
        String string2 = string;
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 1336193813: {
                if (!string.equals("emulator")) break;
                n = 2;
                break;
            }
            case -266464859: {
                if (!string.equals("userType")) break;
                n = 1;
                break;
            }
            case -820075192: {
                if (!string.equals("vendor")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return "";
            }
            case 2: {
                return DeviceInfoUtil.getEmulator();
            }
            case 1: {
                return DeviceInfoUtil.getUserType(context);
            }
            case 0: 
        }
        return DeviceInfoUtil.getVendor();
    }

    private static int detectDeviceType(Context context) {
        if ((context = context.getPackageManager()) == null) {
            LogLocation.d(TAG, "packageManager is null.");
            return -1;
        }
        int n = -1;
        FeatureInfo[] featureInfoArray = new FeatureInfo[]{};
        try {
            featureInfoArray = context.getSystemAvailableFeatures();
        }
        catch (RuntimeException runtimeException) {
            LogLocation.d(TAG, "Package  manager  has  died Exception");
        }
        int n2 = DeviceInfoUtil.detectHuaweiFeature(featureInfoArray);
        LogLocation.d(TAG, "1. detectHuaweiFeature: " + n2);
        if (n2 != -1) {
            if (n2 != 0) {
                return n2;
            }
        } else {
            n2 = n;
        }
        n = DeviceInfoUtil.detectAndroidFeature(featureInfoArray);
        LogLocation.d(TAG, "2. detectAndroidFeature: " + n);
        if (n != -1) {
            return n;
        }
        n = DeviceInfoUtil.detectSystemProperty();
        LogLocation.d(TAG, "3. detectSystemProperty: " + n);
        if (n == -1) {
            n = n2;
        }
        return n;
    }

    private static int detectAndroidFeature(FeatureInfo[] featureInfoArray) {
        HashSet<String> hashSet;
        LogLocation.d(TAG, "Checking Android Features...");
        HashSet<String> hashSet2 = hashSet;
        hashSet = new HashSet<String>();
        for (Object object : featureInfoArray) {
            if (object == null || TextUtils.isEmpty((CharSequence)(object = DeviceInfoUtil.parseNickNameByAndroidFeature(object.name)))) continue;
            hashSet2.add((String)object);
        }
        return DeviceInfoUtil.getTypeFromDTypeList(hashSet2);
    }

    private static int getTypeFromDTypeList(Set<String> set) {
        LogLocation.d(TAG, "androidFeaturesNickNames :" + set);
        int n = -1;
        for (String string : set) {
            DeviceType[] deviceTypeArray = D_TYPE_LIST;
            int n2 = D_TYPE_LIST.length;
            for (int i = 0; i < n2; ++i) {
                DeviceType deviceType = deviceTypeArray[i];
                if (!string.equals(deviceType.androidFeature)) continue;
                DeviceType deviceType2 = deviceType;
                n = deviceType2.id;
                if (!deviceType2.hwHasSubFeatures) break;
            }
            if (n == -1) continue;
        }
        return n;
    }

    private static String parseNickNameByAndroidFeature(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = null;
        String[] stringArray = FEATURE_ANDROID;
        int n = FEATURE_ANDROID.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i];
            if (!string.startsWith(string3)) continue;
            string2 = string.substring(string3.length());
            break;
        }
        LogLocation.d(TAG, "featureInfoName relative nick name :" + string2);
        return string2;
    }

    private static int detectHuaweiFeature(FeatureInfo[] featureInfoArray) {
        int n = -1;
        LogLocation.d(TAG, "Checking Huawei Features...");
        for (FeatureInfo featureInfo : featureInfoArray) {
            String string;
            if (featureInfo == null || TextUtils.isEmpty((CharSequence)(string = featureInfo.name))) continue;
            if (string.startsWith(FEATURE_HUAWEI)) {
                string = string.substring(29);
            } else {
                if (!string.startsWith(FEATURE_HONOR)) continue;
                string = string.substring(30);
            }
            DeviceType[] deviceTypeArray = D_TYPE_LIST;
            int n2 = D_TYPE_LIST.length;
            for (int i = 0; i < n2; ++i) {
                DeviceType deviceType = deviceTypeArray[i];
                if (!string.equals(deviceType.huaweiFeature)) continue;
                DeviceType deviceType2 = deviceType;
                n = deviceType2.id;
                if (!deviceType2.hwHasSubFeatures) break;
            }
            if (n == -1) continue;
            LogLocation.d(TAG, "Huawei Feature is found: " + featureInfo.name);
            break;
        }
        return n;
    }

    private static int detectSystemProperty() {
        LogLocation.d(TAG, "Checking system properties...");
        Object object = SystemPropertiesUtil.getCharacter();
        if (TextUtils.isEmpty((CharSequence)object)) {
            return -1;
        }
        object = Arrays.asList(((String)object).split(",", 10));
        int n = -1;
        DeviceType[] deviceTypeArray = D_TYPE_LIST;
        int n2 = D_TYPE_LIST.length;
        for (int i = 0; i < n2; ++i) {
            DeviceType deviceType = deviceTypeArray[i];
            if (!object.contains(deviceType.androidPropChar)) continue;
            DeviceType deviceType2 = deviceType;
            n = deviceType2.id;
            if (!deviceType2.hwHasSubFeatures) break;
        }
        if (n == -1) {
            LogLocation.d(TAG, "System property not found.");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static String getHwSystemProperties() {
        block11: {
            void var0_8;
            Object object = Class.forName("com.huawei.android.app.PackageManagerEx");
            object = ((Class)object).getDeclaredMethod("getHwSystemAvailableFeatures", new Class[0]).invoke(object, new Object[0]);
            if (!(object instanceof FeatureInfo[])) break block11;
            try {
                return DeviceInfoUtil.checkNormalOrKid((FeatureInfo[])object);
            }
            catch (Throwable throwable) {
                LogLocation.d(TAG, "Failed to resolve class: " + throwable.getMessage());
                break block11;
            }
            catch (ClassCastException classCastException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            LogLocation.d(TAG, "Didn't find class: " + var0_8.getMessage());
        }
        return USERTYPE_NORMAL;
    }

    private static String checkNormalOrKid(FeatureInfo[] featureInfoArray) {
        if (featureInfoArray != null && featureInfoArray.length != 0) {
            int n = featureInfoArray.length;
            for (int i = 0; i < n; ++i) {
                String string = featureInfoArray[i].name;
                if (TextUtils.isEmpty((CharSequence)string)) continue;
                if (string.startsWith(FEATURE_HUAWEI)) {
                    string = string.substring(29);
                } else {
                    if (!string.startsWith(FEATURE_HONOR)) continue;
                    string = string.substring(30);
                }
                if (!KID_CHARACTERS.contains(string)) continue;
                LogLocation.d(TAG, "get a kid feature name: " + string);
                return USERTYPE_KID;
            }
            return USERTYPE_NORMAL;
        }
        return USERTYPE_NORMAL;
    }

    private static String getUserType(Context context) throws InvalidParameterException {
        if (!userType.isEmpty()) {
            LogLocation.d(TAG, "get userType from cache: " + userType);
            return userType;
        }
        if ((context = context.getPackageManager()) != null) {
            try {
                userType = DeviceInfoUtil.checkNormalOrKid(context.getSystemAvailableFeatures());
            }
            catch (RuntimeException runtimeException) {
                LogLocation.d(TAG, "Package  manager  has  died Exception");
            }
            if (!userType.equalsIgnoreCase(USERTYPE_KID)) {
                userType = DeviceInfoUtil.getHwSystemProperties();
            }
            LogLocation.d(TAG, "getUserType: " + userType);
            return userType;
        }
        throw new InvalidParameterException("context.getPackageManger is null.");
    }

    private static String getVendor() {
        String string = SystemPropertiesUtil.getVendor();
        LogLocation.d(TAG, "getVendor: " + string);
        return string;
    }

    private static String getEmulator() {
        String string = SystemPropertiesUtil.getEmulator();
        LogLocation.d(TAG, "getEmulator: " + string);
        if (IS_EMULATOR.equalsIgnoreCase(string)) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    public static boolean isHwDialogThemeForCar(Context context) {
        return DeviceInfoUtil.isSupportFeatureForCar(context, HUAWEI_FEATURE_DIALOG);
    }

    private static boolean isSupportFeatureForCar(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            if (DeviceInfoUtil.isCar(context)) {
                return DeviceInfoUtil.isSupportFeature(context, string);
            }
            return false;
        }
        return false;
    }

    public static boolean isSupportFeature(Context featureInfoArray, String string) {
        if (featureInfoArray != null && !TextUtils.isEmpty((CharSequence)string)) {
            int n;
            featureInfoArray = featureInfoArray.getPackageManager().getSystemAvailableFeatures();
            try {
                n = featureInfoArray.length;
            }
            catch (RuntimeException runtimeException) {
                LogLocation.d(TAG, "feature get failure");
                return false;
            }
            for (int i = 0; i < n; ++i) {
                String string2 = featureInfoArray[i].name;
                if (TextUtils.isEmpty((CharSequence)string2)) continue;
                if (!TextUtils.equals((CharSequence)string2, (CharSequence)string)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isCar(Context context) {
        return DeviceInfoUtil.getDeviceFeature(context) == 8;
    }

    static {
        DeviceType deviceType;
        DeviceType deviceType2;
        DeviceType deviceType3;
        DeviceType deviceType4;
        DeviceType deviceType5;
        DeviceType deviceType6;
        DeviceType deviceType7;
        DeviceType deviceType8;
        DeviceType deviceType9;
        DeviceType deviceType10;
        FEATURE_ANDROID = new String[]{"android.hardware.type.", "android.software."};
        KID_CHARACTERS = Arrays.asList("kidpad", "kidwatch");
        DeviceType[] deviceTypeArray = new DeviceType[10];
        DeviceType deviceType11 = deviceType10;
        deviceType10 = new DeviceType(0, "handset", false, "default", null);
        deviceTypeArray[0] = deviceType11;
        deviceType11 = deviceType9;
        deviceType9 = new DeviceType(1, "pad", false, "tablet", null);
        deviceTypeArray[1] = deviceType11;
        deviceType11 = deviceType8;
        deviceType8 = new DeviceType(2, "watch", true, "watch", "watch");
        deviceTypeArray[2] = deviceType11;
        deviceType11 = deviceType7;
        deviceType7 = new DeviceType(3, "kidwatch", false, "kidwatch", null);
        deviceTypeArray[3] = deviceType11;
        deviceType11 = deviceType6;
        deviceType6 = new DeviceType(4, "tv", true, "tv", "television");
        deviceTypeArray[4] = deviceType11;
        deviceType11 = deviceType5;
        deviceType5 = new DeviceType(4, "tv", true, "tv", "leanback");
        deviceTypeArray[5] = deviceType11;
        deviceType11 = deviceType4;
        deviceType4 = new DeviceType(5, "mobiletv", false, "mobiletv", null);
        deviceTypeArray[6] = deviceType11;
        deviceType11 = deviceType3;
        deviceType3 = new DeviceType(6, "glass", false, null, null);
        deviceTypeArray[7] = deviceType11;
        deviceType11 = deviceType2;
        deviceType2 = new DeviceType(7, "earphone", false, null, null);
        deviceTypeArray[8] = deviceType11;
        deviceType11 = deviceType;
        deviceType = new DeviceType(8, "car", false, "car", "automotive");
        deviceTypeArray[9] = deviceType11;
        D_TYPE_LIST = deviceTypeArray;
        DeviceInfoUtil.deviceType = -1;
        userType = "";
        pubMfc = "";
        brand = "";
        model = "";
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceProperty {
        public static final String USERTYPE = "userType";
        public static final String VENDOR = "vendor";
        public static final String EMULATOR = "emulator";
    }

    private static final class DeviceType {
        private final int id;
        private final String huaweiFeature;
        private final boolean hwHasSubFeatures;
        private final String androidPropChar;
        private final String androidFeature;

        private DeviceType(int n, String string, boolean bl, String string2, String string3) {
            this.id = n;
            this.huaweiFeature = string;
            this.hwHasSubFeatures = bl;
            this.androidPropChar = string2;
            this.androidFeature = string3;
        }
    }
}

