/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorManager {
    private static final String THREADNAME_HEADER = "common";

    public static ExecutorService newCachedThreadPool(String object) {
        SynchronousQueue<Runnable> synchronousQueue;
        object = ExecutorManager.createThreadFactory((String)object);
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue2, (ThreadFactory)object);
    }

    public static ExecutorService newSingleThreadExecutor(String string) {
        return Executors.newSingleThreadExecutor(ExecutorManager.createThreadFactory(string));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int n, String object) {
        object = ExecutorManager.createThreadFactory((String)object);
        return new ScheduledThreadPoolExecutor(n, (ThreadFactory)object);
    }

    public static ExecutorService newFixedThreadPool(int n, int n2, String object) {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        object = ExecutorManager.createThreadFactory((String)object);
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        return new ThreadPoolExecutor(n, n2, 60L, timeUnit, linkedBlockingQueue2, (ThreadFactory)object);
    }

    public static ThreadFactory createThreadFactory(final String string) {
        if (string != null && !string.trim().isEmpty()) {
            return new ThreadFactory(){
                private final AtomicInteger threadNumbers;
                {
                    AtomicInteger atomicInteger;
                    AtomicInteger atomicInteger2 = atomicInteger;
                    atomicInteger = new AtomicInteger(0);
                    v1.threadNumbers = atomicInteger2;
                }

                @Override
                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, "Location_" + string + "_" + this.threadNumbers.getAndIncrement());
                }
            };
        }
        throw new NullPointerException("ThreadName is empty");
    }
}

