/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import androidx.annotation.NonNull;
import com.huawei.location.lite.common.log.LogLocation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorUtil {
    private static final String LOCATION_POOL_PREFIX_DEFAULT = "Location-Task";
    private static final String LOCATION_POOL_DELAY_PREFIX_DEFAULT = "Loc-Task-Delay";
    private static final int THREAD_CORE = 10;
    private static final int THREAD_MAX = 100;
    private static final long KEEP_ALIVE_TIME = 60L;
    private final ThreadPoolExecutor executor;
    private final ScheduledThreadPoolExecutor scheduledExecutor;

    public static ExecutorUtil getInstance() {
        return ExecutorsHolder.INSTANCE;
    }

    private ExecutorUtil() {
        NamedThreadFactory namedThreadFactory;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        NamedThreadFactory namedThreadFactory2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        NamedThreadFactory namedThreadFactory3 = namedThreadFactory2;
        namedThreadFactory2 = new NamedThreadFactory(LOCATION_POOL_PREFIX_DEFAULT);
        threadPoolExecutor2(10, 100, 60L, timeUnit, linkedBlockingQueue2, namedThreadFactory3);
        ((ExecutorUtil)((Object)namedThreadFactory4)).executor = threadPoolExecutor2;
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        threadPoolExecutor2 = scheduledThreadPoolExecutor;
        ExecutorUtil executorUtil = namedThreadFactory4;
        NamedThreadFactory namedThreadFactory4 = namedThreadFactory;
        namedThreadFactory = new NamedThreadFactory(LOCATION_POOL_DELAY_PREFIX_DEFAULT);
        super(10, namedThreadFactory4);
        executorUtil.scheduledExecutor = threadPoolExecutor2;
        scheduledThreadPoolExecutor.setKeepAliveTime(60L, timeUnit);
        scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public void execute(Runnable runnable) {
        try {
            this.getExecutor().execute(runnable);
        }
        catch (Throwable throwable) {
            LogLocation.e("ExecutorUtil", "ExecutorUtil fatal error", true);
        }
    }

    public void execute(FutureTask futureTask) {
        try {
            Thread thread = new Thread(futureTask);
            thread.setName(Thread.currentThread().getName());
            thread.start();
        }
        catch (Throwable throwable) {
            LogLocation.e("ExecutorUtil", "ExecutorUtil futureTask error", true);
        }
    }

    public ScheduledFuture execute(Runnable runnable, long l, TimeUnit timeUnit) {
        try {
            return this.getScheduledExecutor().schedule(runnable, l, timeUnit);
        }
        catch (Throwable throwable) {
            LogLocation.e("ExecutorUtil", "scheduledExecutor schedule fatal error", true);
            return null;
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger counter;
        private final String poolName;

        NamedThreadFactory(String string) {
            AtomicInteger atomicInteger;
            AtomicInteger atomicInteger2 = atomicInteger;
            atomicInteger = new AtomicInteger(1);
            v1.counter = atomicInteger2;
            v1.poolName = string;
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            return new Thread(runnable, this.poolName + "-" + this.counter.getAndIncrement());
        }
    }

    private static class ExecutorsHolder {
        private static final ExecutorUtil INSTANCE = new ExecutorUtil();

        private ExecutorsHolder() {
        }
    }
}

