/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.APKUtil;
import com.huawei.location.lite.common.util.PreferencesHelper;
import com.huawei.location.lite.common.util.SDKComponentType;
import com.huawei.location.lite.common.util.unzip.AssetUnZipManager;
import com.huawei.location.lite.common.util.unzip.IUnzip;
import com.huawei.location.lite.common.util.unzip.Un7Z;
import com.huawei.secure.android.common.encrypt.hash.FileSHA256;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class LoadSoUtil {
    public static final String SP_UNZIP_SO_RESULT = "sp_unzip_so_result";
    public static final String CPU_ARM_64_BIT = "arm64-v8a";
    public static final String CPU_ARM_32_BIT = "armeabi-v7a";
    private static final String TAG = "LoadSoUtil";
    private static final String JNI_DIR_PREFIX = "jniLibs";
    private static boolean isLoadSuccess = false;

    public static synchronized void initLoadSo() {
        boolean bl;
        Un7Z un7Z;
        AssetUnZipManager assetUnZipManager;
        ArrayList<String> arrayList;
        PreferencesHelper preferencesHelper;
        Object object = preferencesHelper;
        Object object2 = String.valueOf(APKUtil.getAppVersionCode(ContextUtil.getContext()));
        if (new PreferencesHelper(SP_UNZIP_SO_RESULT).getBoolean((String)object2)) {
            LogLocation.e(TAG, "load so have init success");
            isLoadSuccess = true;
            return;
        }
        PreferencesHelper preferencesHelper2 = object;
        String string = object2;
        object = LoadSoUtil.getSoDirSavePath();
        object2 = LoadSoUtil.getCurrentCpuAbi(ContextUtil.getContext());
        ArrayList<String> arrayList2 = arrayList;
        arrayList2();
        arrayList.add((String)object2);
        object2 = assetUnZipManager;
        Object object3 = object;
        object = un7Z;
        un7Z = new Un7Z();
        ((AssetUnZipManager)object2)(JNI_DIR_PREFIX, (IUnzip)object);
        ((AssetUnZipManager)object2).setFilterZipDirs(arrayList2);
        isLoadSuccess = bl = assetUnZipManager.copyZipFileFromAssets((String)object3);
        preferencesHelper2.saveBoolean(string, bl);
    }

    public static synchronized boolean assetsSoFileUnZip(String object) {
        boolean bl;
        block7: {
            ArrayList<String> arrayList;
            if (TextUtils.isEmpty((CharSequence)object)) {
                return false;
            }
            String string = LoadSoUtil.getSoDirSavePath();
            String string2 = LoadSoUtil.getCurrentCpuAbi(ContextUtil.getContext());
            ArrayList<String> arrayList2 = arrayList;
            arrayList2();
            arrayList.add(string2);
            try {
                object = AssetUnZipManager.createFileFromInputStream(ContextUtil.getContext(), (String)object, JNI_DIR_PREFIX);
            }
            catch (IOException iOException) {
                LogLocation.e(TAG, "assetsFileUnZip IOException");
                return false;
            }
            bl = new Un7Z().doUnzip(((File)object).getCanonicalPath(), string, arrayList2, null);
            if (((File)object).delete()) break block7;
            LogLocation.e(TAG, "assetsFileUnZip, delete file exception");
        }
        return bl;
    }

    public static synchronized boolean loadLocalSo(String string) {
        return LoadSoUtil.loadLocalSo(string, "", false);
    }

    public static synchronized boolean loadLocalSo(String string, String string2, boolean bl) {
        File file;
        if (!isLoadSuccess) {
            LogLocation.e(TAG, "init load so fail");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)(string = LoadSoUtil.getSoFileSavePath(string)))) {
            return false;
        }
        File file2 = file;
        if (!new File(string).exists()) {
            LogLocation.e(TAG, "load Local so error because of so file not exist");
            return false;
        }
        if (bl && !FileSHA256.validateFileSHA256((File)file2, (String)string2)) {
            return false;
        }
        System.load(string);
        return true;
    }

    private static String getSoFileSavePath(String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && string.contains(".so")) {
            String string2 = File.separator;
            return LoadSoUtil.getSoDirSavePath() + string2 + LoadSoUtil.getCurrentCpuAbi(ContextUtil.getContext()) + string2 + string;
        }
        LogLocation.e(TAG, "so name not valid");
        return "";
    }

    private static String getSoDirSavePath() {
        StringBuilder stringBuilder;
        CharSequence charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = charSequence.append(LoadSoUtil.getFilePath(SDKComponentType.getComponentType() == 200 ? ContextUtil.getHMSContext() : ContextUtil.getContext()));
        charSequence = File.separator;
        return stringBuilder2.append((String)charSequence).append("kits").append((String)charSequence).append(ContextUtil.getContext().getPackageName()).append((String)charSequence).append(APKUtil.getAppVersionCode(ContextUtil.getContext())).append((String)charSequence).append("lib").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFilePath(Context context) {
        try {
            if (Build.VERSION.SDK_INT < 24) return context.getFilesDir().getCanonicalPath();
        }
        catch (IOException iOException) {
            LogLocation.e(TAG, "getCanonicalPath is IOException");
            return null;
        }
        return context.createDeviceProtectedStorageContext().getFilesDir().getCanonicalPath();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static String getCurrentCpuAbi(Context object) {
        void var0_3;
        String string = "arm64";
        int n = Build.VERSION.SDK_INT;
        if (n >= 23 ? Process.is64Bit() : n >= 21 && !TextUtils.isEmpty((CharSequence)object.getApplicationInfo().nativeLibraryDir) && object.getApplicationInfo().nativeLibraryDir.contains(string)) {
            String string2 = CPU_ARM_64_BIT;
            return var0_3;
        }
        String string3 = CPU_ARM_32_BIT;
        return var0_3;
    }

    public static boolean loadSo(String string, String string2) {
        block7: {
            File file;
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            File file2 = file;
            try {
                if (!new File(string2 + File.separator + string).exists()) break block7;
            }
            catch (IOException iOException) {
                LogLocation.d(TAG, "loadSo exception:Invalid file path");
                return false;
            }
            if (file2.length() <= 0L) break block7;
            System.load(file2.getCanonicalPath());
            return true;
        }
        return false;
    }
}

